/*
 * Decompiled with CFR 0.152.
 */
package com.sintinium.oauth.gui.profile;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.exceptions.InvalidCredentialsException;
import com.mojang.authlib.exceptions.UserMigratedException;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.sintinium.oauth.gui.ErrorScreen;
import com.sintinium.oauth.gui.LoginLoadingScreen;
import com.sintinium.oauth.gui.LoginScreen;
import com.sintinium.oauth.gui.OAuthScreen;
import com.sintinium.oauth.gui.profile.FakePlayer;
import com.sintinium.oauth.gui.profile.ProfileEntry;
import com.sintinium.oauth.gui.profile.ProfileList;
import com.sintinium.oauth.login.LoginUtil;
import com.sintinium.oauth.login.MicrosoftLogin;
import com.sintinium.oauth.profile.MicrosoftProfile;
import com.sintinium.oauth.profile.OfflineProfile;
import com.sintinium.oauth.profile.ProfileManager;
import com.sintinium.oauth.util.PlayerRenderers;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.MainMenuScreen;
import net.minecraft.client.gui.screen.MultiplayerScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.model.PlayerModel;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerModelPart;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import org.apache.logging.log4j.LogManager;

public class ProfileSelectionScreen
extends OAuthScreen {
    private ProfileList profileList;
    private Button removeAccountButton;
    private Button loginButton;
    private Button loginOfflineButton;
    private ProfileEntry initialEntry;

    public ProfileSelectionScreen() {
        super((ITextComponent)new StringTextComponent("Profiles"));
    }

    public ProfileSelectionScreen(ProfileEntry initialEntry) {
        this();
        this.initialEntry = initialEntry;
    }

    private static void onMojangType() {
        ProfileSelectionScreen.setScreen(new LoginScreen());
    }

    public void onLoginButton() {
        this.onLoginButton((ProfileEntry)this.profileList.func_230958_g_());
    }

    public void func_231152_a_(Minecraft p_96575_, int p_96576_, int p_96577_) {
        ProfileEntry selected = (ProfileEntry)this.profileList.func_230958_g_();
        super.func_231152_a_(p_96575_, p_96576_, p_96577_);
        if (selected != null) {
            this.profileList.func_231039_at__().stream().filter(entry -> entry.getProfile().getUUID().equals(selected.getProfile().getUUID())).findFirst().ifPresent(profile -> this.profileList.setSelected((ProfileEntry)((Object)profile)));
        }
    }

    protected void func_231160_c_() {
        this.profileList = new ProfileList(this, Minecraft.func_71410_x(), this.field_230708_k_, this.field_230709_l_, 32, this.field_230709_l_ - 52, 16);
        this.profileList.loadProfiles();
        FakePlayer.getInstance().clearCache();
        if (LoginUtil.isOnline()) {
            GameProfile profile = ProfileManager.getInstance().getGameProfileOrNull(Minecraft.func_71410_x().func_110432_I().func_148256_e().getId());
            if (profile == null) {
                profile = Minecraft.func_71410_x().func_110432_I().func_148256_e();
            }
            FakePlayer.getInstance().setSkin(profile);
            FakePlayer.getInstance().setSkin(profile);
        } else if (this.profileList.func_230958_g_() != null) {
            ProfileEntry entry = (ProfileEntry)this.profileList.func_230958_g_();
            FakePlayer.getInstance().setSkin(entry.getProfile().getGameProfile());
            FakePlayer.getInstance().setSkin(entry.getProfile().getGameProfile());
        } else {
            FakePlayer.getInstance().setSkin(null);
        }
        this.addButton(this.field_230708_k_ / 2 - 45 - 90 - 2, this.field_230709_l_ - 2 - 20, 90, "Add Account", p_onPress_1_ -> this.onMicrosoftType(null));
        this.removeAccountButton = this.addButton(this.field_230708_k_ / 2 - 45, this.field_230709_l_ - 2 - 20, 90, "Remove Account", p_onPress_1_ -> {
            if (this.profileList.func_230958_g_() != null) {
                ProfileManager.getInstance().removeProfile(((ProfileEntry)this.profileList.func_230958_g_()).getProfile().getUUID());
                int index = this.profileList.func_231039_at__().indexOf(this.profileList.func_230958_g_());
                this.profileList.func_231039_at__().remove(this.profileList.func_230958_g_());
                if (index < this.profileList.func_231039_at__().size()) {
                    this.profileList.setSelected((ProfileEntry)((Object)((Object)this.profileList.func_231039_at__().get(index))));
                } else if (index - 1 < this.profileList.func_231039_at__().size() && index - 1 >= 0) {
                    this.profileList.setSelected((ProfileEntry)((Object)((Object)this.profileList.func_231039_at__().get(index - 1))));
                }
            }
        });
        this.removeAccountButton.field_230693_o_ = false;
        this.addButton(this.field_230708_k_ / 2 + 45 + 2, this.field_230709_l_ - 2 - 20, 90, "Back", p_onPress_1_ -> ProfileSelectionScreen.setScreen((Screen)new MainMenuScreen()));
        this.loginButton = this.addButton(this.field_230708_k_ / 2 - 137, this.field_230709_l_ - 4 - 40, 137, "Login", p_onPress_1_ -> this.onLoginButton());
        this.loginOfflineButton = this.addButton(this.field_230708_k_ / 2 + 1, this.field_230709_l_ - 4 - 40, 137, "Login Offline", p_onPress_1_ -> {
            if (this.profileList.func_230958_g_() != null) {
                try {
                    LoginUtil.loginOffline(((ProfileEntry)this.profileList.func_230958_g_()).getProfile().getName());
                    ProfileSelectionScreen.setScreen((Screen)new MultiplayerScreen((Screen)new MainMenuScreen()));
                }
                catch (LoginUtil.WrongMinecraftVersionException e) {
                    ProfileSelectionScreen.setScreen(new ErrorScreen(((ProfileEntry)this.profileList.func_230958_g_()).getProfile() instanceof MicrosoftProfile, e));
                    e.printStackTrace();
                }
            }
        });
        this.loginButton.field_230693_o_ = false;
        this.loginOfflineButton.field_230693_o_ = false;
        this.func_230481_d_((IGuiEventListener)this.profileList);
        if (this.initialEntry != null) {
            if (this.profileList.func_231039_at__().contains((Object)this.initialEntry)) {
                this.profileList.setSelected(this.initialEntry);
            }
            this.initialEntry = null;
        }
    }

    public void onLoginButton(ProfileEntry selected) {
        if (selected == null || selected.getProfile() == null) {
            return;
        }
        if (selected.getProfile() instanceof OfflineProfile) {
            try {
                selected.getProfile().login();
                Minecraft.func_71410_x().func_147108_a((Screen)new MultiplayerScreen((Screen)new MainMenuScreen()));
                return;
            }
            catch (Exception e) {
                ProfileSelectionScreen.setScreen(new ErrorScreen(selected.getProfile() instanceof MicrosoftProfile, e));
                e.printStackTrace();
                return;
            }
        }
        Thread thread = new Thread(() -> {
            try {
                AtomicBoolean isCancelled = new AtomicBoolean();
                LoginLoadingScreen loginLoadingScreen = new LoginLoadingScreen(() -> {
                    ProfileSelectionScreen.setScreen(new ProfileSelectionScreen(selected));
                    isCancelled.set(true);
                }, selected.getProfile() instanceof MicrosoftProfile);
                if (selected.getProfile() instanceof MicrosoftProfile) {
                    loginLoadingScreen.updateText("Logging into Microsoft.");
                } else {
                    loginLoadingScreen.updateText("Logging into Minecraft.");
                }
                ProfileSelectionScreen.setScreen(loginLoadingScreen);
                boolean isSuccessful = selected.getProfile().login();
                if (isCancelled.get()) {
                    return;
                }
                if (!isSuccessful && selected.getProfile() instanceof MicrosoftProfile) {
                    this.onMicrosoftType(selected);
                    return;
                }
                if (!isSuccessful && Minecraft.func_71410_x().field_71462_r instanceof ProfileSelectionScreen) {
                    ProfileSelectionScreen.setScreen(new ErrorScreen(selected.getProfile() instanceof MicrosoftProfile, "Login Failed"));
                    return;
                }
                try {
                    ProfileManager.getInstance().getProfile(selected.getProfile().getUUID()).setName(Minecraft.func_71410_x().func_110432_I().func_111285_a());
                    ProfileManager.getInstance().save();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                ProfileSelectionScreen.setScreen((Screen)new MultiplayerScreen((Screen)new MainMenuScreen()));
            }
            catch (UserMigratedException e) {
                ErrorScreen errorScreen = new ErrorScreen(selected.getProfile() instanceof MicrosoftProfile, "This account has migrated to Microsoft. Please create a new profile with your Microsoft account.");
                ProfileSelectionScreen.setScreen(errorScreen);
                e.printStackTrace();
            }
            catch (InvalidCredentialsException e) {
                if (e.getMessage() == null || e.getMessage().equals(e.getCause().toString())) {
                    ErrorScreen errorScreen = new ErrorScreen(selected.getProfile() instanceof MicrosoftProfile, e);
                    ProfileSelectionScreen.setScreen(errorScreen);
                } else {
                    ErrorScreen errorScreen = new ErrorScreen(((ProfileEntry)this.profileList.func_230958_g_()).getProfile() instanceof MicrosoftProfile, e.getMessage() + ". Please delete the profile and create a new one.");
                    errorScreen.setInfo();
                    ProfileSelectionScreen.setScreen(errorScreen);
                }
                e.printStackTrace();
            }
            catch (MicrosoftLogin.BaseMicrosoftLoginException e) {
                ProfileSelectionScreen.setScreen(ErrorScreen.microsoftExceptionScreen(e));
                e.printStackTrace();
                return;
            }
            catch (Exception e) {
                ProfileSelectionScreen.setScreen(new ErrorScreen(((ProfileEntry)this.profileList.func_230958_g_()).getProfile() instanceof MicrosoftProfile, e));
                e.printStackTrace();
            }
        }, "LoginThread");
        thread.setDaemon(true);
        thread.start();
    }

    private void onMicrosoftType(@Nullable ProfileEntry entry) {
        MicrosoftLogin login = new MicrosoftLogin();
        LoginLoadingScreen loadingScreen = new LoginLoadingScreen(login::cancelLogin, true);
        login.setUpdateStatusConsumer(loadingScreen::updateText);
        Thread thread = new Thread(() -> {
            MicrosoftProfile profile;
            try {
                profile = login.login();
            }
            catch (MicrosoftLogin.BaseMicrosoftLoginException e) {
                ProfileSelectionScreen.setScreen(ErrorScreen.microsoftExceptionScreen(e));
                e.printStackTrace();
                LogManager.getLogger().error(login.getErroredResponses());
                return;
            }
            catch (Exception e) {
                ProfileSelectionScreen.setScreen(new ErrorScreen(true, e));
                e.printStackTrace();
                LogManager.getLogger().error(login.getErroredResponses());
                return;
            }
            if (profile != null) {
                ProfileManager.getInstance().addProfile(profile);
                ProfileEntry newProfile = new ProfileEntry(this.profileList, profile);
                this.onLoginButton(newProfile);
            }
        }, "Oauth microsoft");
        ProfileSelectionScreen.setScreen(loadingScreen);
        thread.setDaemon(true);
        thread.start();
    }

    private Button addButton(int x, int y, int width, String text, Button.IPressable onPress) {
        return (Button)this.func_230480_a_((Widget)new Button(x, y, width, 20, (ITextComponent)new StringTextComponent(text), onPress));
    }

    public boolean func_231044_a_(double p_231044_1_, double p_231044_3_, int p_231044_5_) {
        return super.func_231044_a_(p_231044_1_, p_231044_3_, p_231044_5_);
    }

    @Override
    public void func_231023_e_() {
        super.func_231023_e_();
        if (this.profileList.func_230958_g_() == null) {
            this.removeAccountButton.field_230693_o_ = false;
            this.loginButton.field_230693_o_ = false;
            this.loginOfflineButton.field_230693_o_ = false;
            return;
        }
        this.removeAccountButton.field_230693_o_ = true;
        this.loginButton.field_230693_o_ = true;
        this.loginOfflineButton.field_230693_o_ = true;
        if (((ProfileEntry)this.profileList.func_230958_g_()).isOffline()) {
            this.loginButton.field_230693_o_ = false;
        }
    }

    public void func_230430_a_(MatrixStack stack, int mouseX, int mouseY, float delta) {
        this.func_230446_a_(stack);
        int size = 60;
        int x = 40;
        int y = this.field_230709_l_ / 2 + size;
        this.profileList.func_230430_a_(stack, mouseX, mouseY, delta);
        this.renderPlayer(stack, mouseX, mouseY, delta);
        Minecraft.func_71410_x().field_71466_p.func_238405_a_(stack, "Status: " + (LoginUtil.isOnline() ? "Online" : "Offline"), 12.0f, 12.0f, LoginUtil.isOnline() ? 0x55FF55 : 0xFF5555);
        ProfileSelectionScreen.func_238471_a_((MatrixStack)stack, (FontRenderer)this.field_230712_o_, (String)("Current Profile: " + Minecraft.func_71410_x().func_110432_I().func_111285_a()), (int)(this.field_230708_k_ / 2), (int)12, (int)0xFFFFFF);
        super.func_230430_a_(stack, mouseX, mouseY, delta);
    }

    private void renderPlayer(MatrixStack stack, int mouseX, int mouseY, float delta) {
        int size = 60;
        int x = 40;
        int y = this.field_230709_l_ / 2 + size;
        float rotX = -mouseX + x;
        float rotY = (float)(-mouseY + y - size * 2) + (float)size / 2.0f;
        RenderSystem.pushMatrix();
        RenderSystem.translatef((float)x, (float)y, (float)1050.0f);
        RenderSystem.scalef((float)1.0f, (float)1.0f, (float)-1.0f);
        FakePlayer fakePlayer = FakePlayer.getInstance();
        float f = (float)Math.atan(rotX / 40.0f);
        float f1 = (float)Math.atan(rotY / 40.0f);
        fakePlayer.field_70761_aq = 180.0f + f * 20.0f;
        fakePlayer.field_70177_z = 180.0f + f * 40.0f;
        fakePlayer.field_70125_A = -f1 * 20.0f;
        fakePlayer.field_70759_as = fakePlayer.field_70177_z;
        fakePlayer.field_70758_at = fakePlayer.field_70177_z;
        MatrixStack playerStack = new MatrixStack();
        playerStack.func_227861_a_(0.0, 0.0, 1000.0);
        playerStack.func_227862_a_((float)size, (float)size, (float)size);
        Quaternion quaternion = Vector3f.field_229183_f_.func_229187_a_(180.0f);
        Quaternion quaternion1 = Vector3f.field_229179_b_.func_229187_a_((float)Math.atan(rotX / 40.0f));
        quaternion.func_195890_a(quaternion1);
        playerStack.func_227863_a_(quaternion);
        playerStack.func_227862_a_(0.9375f, 0.9375f, 0.9375f);
        IRenderTypeBuffer.Impl multiBufferSource = Minecraft.func_71410_x().func_228019_au_().func_228487_b_();
        RenderSystem.runAsFancy(() -> this.renderEntity(playerStack, multiBufferSource));
        multiBufferSource.func_228461_a_();
        RenderSystem.popMatrix();
    }

    private void renderEntity(MatrixStack stack, IRenderTypeBuffer.Impl multiBufferSource) {
        this.renderModel(stack, multiBufferSource);
    }

    private void renderModel(MatrixStack stack, IRenderTypeBuffer.Impl multiBufferSource) {
        stack.func_227860_a_();
        stack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f - MathHelper.func_219799_g((float)1.0f, (float)FakePlayer.getInstance().field_70760_ar, (float)FakePlayer.getInstance().field_70761_aq)));
        stack.func_227862_a_(-1.0f, -1.0f, 1.0f);
        stack.func_227861_a_(0.0, -1.501, 0.0);
        boolean slim = false;
        PlayerModel<AbstractClientPlayerEntity> model = FakePlayer.getInstance().func_175154_l().equals("slim") ? PlayerRenderers.slimModel : PlayerRenderers.playerModel;
        model.func_212843_a_((LivingEntity)FakePlayer.getInstance(), 0.0f, 0.0f, 1.0f);
        float rotation = MathHelper.func_219805_h((float)1.0f, (float)FakePlayer.getInstance().field_70758_at, (float)FakePlayer.getInstance().field_70759_as) - MathHelper.func_219799_g((float)1.0f, (float)FakePlayer.getInstance().field_70760_ar, (float)FakePlayer.getInstance().field_70761_aq);
        model.func_225597_a_((LivingEntity)FakePlayer.getInstance(), 0.0f, 0.0f, 0.0f, rotation, MathHelper.func_219799_g((float)1.0f, (float)FakePlayer.getInstance().field_70127_C, (float)FakePlayer.getInstance().field_70125_A));
        RenderType renderType = model.func_228282_a_(FakePlayer.getInstance().func_110306_p());
        IVertexBuilder vertexConsumer = multiBufferSource.getBuffer(renderType);
        int overlayCoords = OverlayTexture.func_229201_a_((int)OverlayTexture.func_229199_a_((float)0.0f), (int)OverlayTexture.func_229202_a_((boolean)false));
        model.func_178719_a(true);
        model.field_217114_e = false;
        model.func_225598_a_(stack, vertexConsumer, 0xF000F0, overlayCoords, 1.0f, 1.0f, 1.0f, 1.0f);
        FakePlayer fakePlayer = FakePlayer.getInstance();
        if (fakePlayer.func_152122_n() && fakePlayer.func_175148_a(PlayerModelPart.CAPE) && fakePlayer.func_110303_q() != null) {
            stack.func_227860_a_();
            stack.func_227861_a_(0.0, 0.0, 0.225);
            stack.func_227863_a_(Vector3f.field_229182_e_.func_229187_a_(5.0f));
            stack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(5.0f));
            IVertexBuilder vertexConsumer1 = multiBufferSource.getBuffer(RenderType.func_228634_a_((ResourceLocation)fakePlayer.func_110303_q()));
            model.func_228289_b_(stack, vertexConsumer1, 0xF000F0, OverlayTexture.field_229196_a_);
            stack.func_227865_b_();
        }
        stack.func_227865_b_();
        Minecraft.func_71410_x().func_228019_au_().func_228487_b_().func_228461_a_();
    }
}

