/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.tcg.tileentity;

import com.pixelmonmod.tcg.init.registry.TileEntityRegistration;
import com.pixelmonmod.tcg.tileentity.BattleOwnedTileEntityController;
import com.pixelmonmod.tcg.tileentity.OwnedTileEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.math.BlockPos;

public class BattleSpectatorOwnedTileEntity
extends OwnedTileEntity {
    private static final String CONTROLLER_KEY = "Controller";
    private static final String X_KEY = "X";
    private static final String Y_KEY = "Y";
    private static final String Z_KEY = "Z";
    private static final String PLAYER_INDEX_KEY = "PlayerIndex";
    private BlockPos controllerPosition;
    private int playerIndex;

    public BattleSpectatorOwnedTileEntity() {
        super((TileEntityType)TileEntityRegistration.BATTLE_SPECTATOR.get());
    }

    @Override
    public void deserializeNBT(CompoundNBT nbt) {
        super.deserializeNBT(nbt);
        int x = 0;
        int y = 0;
        int z = 0;
        if (nbt.func_74764_b(CONTROLLER_KEY)) {
            CompoundNBT controllerNBT = nbt.func_74775_l(CONTROLLER_KEY);
            if (controllerNBT.func_74764_b(X_KEY)) {
                x = controllerNBT.func_74762_e(X_KEY);
            }
            if (controllerNBT.func_74764_b(Y_KEY)) {
                y = controllerNBT.func_74762_e(Y_KEY);
            }
            if (controllerNBT.func_74764_b(Z_KEY)) {
                z = controllerNBT.func_74762_e(Z_KEY);
            }
        }
        this.controllerPosition = new BlockPos(x, y, z);
        if (nbt.func_74764_b(PLAYER_INDEX_KEY)) {
            this.playerIndex = nbt.func_74762_e(PLAYER_INDEX_KEY);
        }
    }

    @Override
    public CompoundNBT serializeNBT() {
        CompoundNBT nbt = super.serializeNBT();
        if (this.controllerPosition != null) {
            CompoundNBT controllerNBT = new CompoundNBT();
            controllerNBT.func_74768_a(X_KEY, this.controllerPosition.func_177958_n());
            controllerNBT.func_74768_a(Y_KEY, this.controllerPosition.func_177956_o());
            controllerNBT.func_74768_a(Z_KEY, this.controllerPosition.func_177952_p());
            nbt.func_218657_a(CONTROLLER_KEY, (INBT)controllerNBT);
        }
        nbt.func_74768_a(PLAYER_INDEX_KEY, this.playerIndex);
        return nbt;
    }

    public BattleOwnedTileEntityController getBattleController() {
        if (this.controllerPosition == null) {
            return null;
        }
        TileEntity te = this.field_145850_b.func_175625_s(this.controllerPosition);
        if (te instanceof BattleOwnedTileEntityController) {
            return (BattleOwnedTileEntityController)te;
        }
        return null;
    }

    public BlockPos getControllerPosition() {
        return this.controllerPosition;
    }

    public void setControllerPosition(BlockPos controllerPosition) {
        this.controllerPosition = controllerPosition;
    }

    public int getPlayerIndex() {
        return this.playerIndex;
    }

    public void setPlayerIndex(int playerIndex) {
        this.playerIndex = playerIndex;
    }
}

