/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.tcg.network.packets.battles;

import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import com.pixelmonmod.tcg.client.gui.duel.TCGScreen;
import com.pixelmonmod.tcg.duel.state.TrainerCardState;
import com.pixelmonmod.tcg.network.ByteBufTCG;
import com.pixelmonmod.tcg.network.data.AbstractTCGPacket;
import com.pixelmonmod.tcg.network.data.PacketDirection;
import com.pixelmonmod.tcg.network.packets.enums.BoardLocation;
import net.minecraft.client.Minecraft;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;

@PacketInfo(value={NetworkDirection.PLAY_TO_CLIENT})
public class TrainerPlayedPacket
extends AbstractTCGPacket {
    private String playerName;
    private TrainerCardState trainer;

    public TrainerPlayedPacket() {
        super(PacketDirection.PLAY_CLIENT);
    }

    public TrainerPlayedPacket(String playerName, TrainerCardState trainer) {
        this();
        this.playerName = playerName;
        this.trainer = trainer;
    }

    @Override
    public void encode(PacketBuffer buffer) {
        buffer.func_180714_a(this.playerName);
        ByteBufTCG.writeCard(buffer, this.trainer.getData());
    }

    @Override
    public void decode(PacketBuffer buffer) {
        this.playerName = buffer.func_218666_n();
        this.trainer = new TrainerCardState(ByteBufTCG.readCard(buffer));
    }

    @Override
    protected void handlePacket(NetworkEvent.Context context) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71441_e != null && mc.field_71462_r instanceof TCGScreen) {
            TCGScreen gui = (TCGScreen)mc.field_71462_r;
            gui.getInspectingCard().set(this.trainer, false, BoardLocation.Trainer, 0, true, String.format("%s just played", this.playerName));
        }
    }
}

