/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.tcg.commands;

import com.pixelmonmod.api.helpers.ColorHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.NumberHelper;
import com.pixelmonmod.tcg.api.accessors.CardBacks;
import com.pixelmonmod.tcg.api.accessors.CardSets;
import com.pixelmonmod.tcg.api.accessors.Cards;
import com.pixelmonmod.tcg.api.accessors.Coins;
import com.pixelmonmod.tcg.api.accessors.ThemeDecks;
import com.pixelmonmod.tcg.api.card.ImmutableCard;
import com.pixelmonmod.tcg.api.card.ThemeDeck;
import com.pixelmonmod.tcg.api.card.personalization.CardBack;
import com.pixelmonmod.tcg.api.card.personalization.Coin;
import com.pixelmonmod.tcg.api.card.set.CardSet;
import com.pixelmonmod.tcg.block.EssenceJarBlock;
import com.pixelmonmod.tcg.commands.SubcommandBase;
import java.awt.Color;
import java.util.Arrays;
import java.util.HashSet;
import net.minecraft.command.CommandException;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

public class TCGGiveCommand
extends SubcommandBase {
    public static final HashSet<String> GIVE_COMMANDS = new HashSet<String>(Arrays.asList("card", "deck", "pack", "essence", "cardback", "coin", "jar"));

    @Override
    String getHelp(CommandSource sender) {
        return "/tcg give card <player> <card_id>: give a card to a player\n/tcg give deck <player> <deck_id>: give a deck to a player\n/tcg give pack <player> <set_id>: give a booster pack to a player\n/tcg give cardback <player> <cardback_id>: gives a card back to a player\n/tcg give coin <player> <coin_id>: gives a coin to a player\n/tcg give jar <player> [percent_full] [color] [color_name]";
    }

    @Override
    String getPermissionNode() {
        return "tcg.give";
    }

    @Override
    int getPermissionLevel() {
        return 4;
    }

    @Override
    protected boolean execute(CommandSource sender, String[] args) throws CommandException {
        if (args.length > 1) {
            ServerPlayerEntity receiver = null;
            if (GIVE_COMMANDS.contains(args[1])) {
                if (args.length > 2) {
                    receiver = ServerLifecycleHooks.getCurrentServer().func_184103_al().func_152612_a(args[2]);
                } else {
                    return false;
                }
            }
            if (receiver == null) {
                SubcommandBase.sendMessage(sender, TextFormatting.RED, "Cannot find player " + args[2]);
                return true;
            }
            if (args[1].equalsIgnoreCase("jar")) {
                Color color = new Color(DyeColor.BLACK.getColorValue());
                String colorName = DyeColor.BLACK.func_176762_d();
                double jarPercentFull = 0.0;
                if (args.length > 3) {
                    jarPercentFull = NumberHelper.parseDouble(args[3]).orElse(0.0);
                    jarPercentFull /= 100.0;
                }
                if (args.length > 4) {
                    color = ColorHelper.getParsedColor(args[4]).orElse(null);
                    if (color == null) {
                        receiver.func_145747_a((ITextComponent)new TranslationTextComponent("tcg.essence.color.invalid"), Util.field_240973_b_);
                        return true;
                    }
                    colorName = ColorHelper.getParsedColorName(args[4]).orElse(new TranslationTextComponent("tcg.essence.color.unknown").getString());
                }
                if (args.length > 5) {
                    colorName = args[5];
                }
                receiver.func_145747_a((ITextComponent)new TranslationTextComponent("tcg.essence.given", new Object[]{colorName}), Util.field_240973_b_);
                receiver.func_191521_c(EssenceJarBlock.createJarItem(jarPercentFull, color, colorName));
                return true;
            }
            if (args[1].equalsIgnoreCase("card")) {
                if (args.length > 3) {
                    ImmutableCard card;
                    boolean isHolo = false;
                    if (args.length > 4) {
                        isHolo = args[4].equalsIgnoreCase("H");
                    }
                    if ((card = Cards.fromCode(args[3])) == null) {
                        SubcommandBase.sendMessage(sender, TextFormatting.RED, "Cannot find card with ID " + args[3]);
                        return true;
                    }
                    if (!receiver.func_191521_c(card.getItemStack(1))) {
                        receiver.func_71019_a(card.getItemStack(1), true);
                    }
                    receiver.func_145747_a((ITextComponent)new TranslationTextComponent(card.getName().toLowerCase()).func_240702_b_(" card is added to your inventory!"), Util.field_240973_b_);
                    return true;
                }
                return false;
            }
            if (args[1].equalsIgnoreCase("pack")) {
                if (args.length > 3) {
                    CardSet set = CardSets.get(args[3]);
                    if (set == null) {
                        SubcommandBase.sendMessage(sender, TextFormatting.RED, "Cannot find set with ID " + args[3]);
                        return true;
                    }
                    if (!receiver.func_191521_c(set.getItemStack(1))) {
                        receiver.func_71019_a(set.getItemStack(1), true);
                    }
                    SubcommandBase.sendMessage(receiver, TextFormatting.GREEN, "Pack of " + new TranslationTextComponent(set.getUnlocalizedName().toLowerCase()) + " is added to your inventory!");
                    return true;
                }
                return false;
            }
            if (args[1].equalsIgnoreCase("deck")) {
                if (args.length > 3) {
                    ThemeDeck deck = ThemeDecks.get(args[3]);
                    if (deck == null) {
                        SubcommandBase.sendMessage(sender, TextFormatting.RED, "Cannot find deck with ID " + args[3]);
                        return true;
                    }
                    if (!receiver.func_191521_c(deck.getItemStack())) {
                        receiver.func_71019_a(deck.getItemStack(), true);
                    }
                    receiver.func_145747_a((ITextComponent)deck.getLocalizedName().func_230532_e_().func_240699_a_(TextFormatting.BOLD).func_230529_a_((ITextComponent)new StringTextComponent(" deck is added to your inventory!").func_240699_a_(TextFormatting.RESET)), Util.field_240973_b_);
                    return true;
                }
                return false;
            }
            if (args[1].equalsIgnoreCase("cardback")) {
                if (args.length > 3) {
                    CardBack cb = CardBacks.get(args[3]);
                    if (cb == null) {
                        SubcommandBase.sendMessage(sender, TextFormatting.RED, "Cannot find cardback with ID " + args[3]);
                        return true;
                    }
                    if (!receiver.func_191521_c(cb.getItemStack())) {
                        receiver.func_71019_a(cb.getItemStack(), true);
                    }
                    receiver.func_145747_a((ITextComponent)new StringTextComponent(TextFormatting.BOLD + cb.getName() + TextFormatting.RESET + " cardback is added to your inventory!"), Util.field_240973_b_);
                    return true;
                }
                return false;
            }
            if (args[1].equalsIgnoreCase("coin")) {
                if (args.length > 3) {
                    Coin coin = Coins.get(args[3]);
                    if (coin == null) {
                        SubcommandBase.sendMessage(sender, TextFormatting.RED, "Cannot find coin with ID " + args[3]);
                        return true;
                    }
                    if (!receiver.func_191521_c(coin.getItemStack())) {
                        receiver.func_71019_a(coin.getItemStack(), true);
                    }
                    receiver.func_145747_a((ITextComponent)new StringTextComponent(TextFormatting.BOLD + coin.getName() + TextFormatting.RESET + " coin is added to your inventory!"), Util.field_240973_b_);
                    return true;
                }
                return false;
            }
            return false;
        }
        return false;
    }
}

