/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.world.generation.features;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.serialization.Codec;
import com.pixelmonmod.pixelmon.api.config.BetterSpawnerConfig;
import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.world.generation.PixelmonFeatures;
import java.util.Arrays;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.BaseTreeFeatureConfig;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;

public class BerryTreesFeature
extends Feature<NoFeatureConfig> {
    private static final Map<Biome, BerryTreeGroup> VALID_TREES = Maps.newConcurrentMap();

    public BerryTreesFeature(Codec<NoFeatureConfig> p_i231953_1_) {
        super(p_i231953_1_);
    }

    public boolean place(ISeedReader world, ChunkGenerator generator, Random random, BlockPos pos, NoFeatureConfig config) {
        BerryTreeGroup trees;
        if (!PixelmonConfigProxy.getDimensions().isWildBerryTrees()) {
            return false;
        }
        Biome biome = generator.func_202090_b().func_225526_b_(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        if (!VALID_TREES.containsKey(biome)) {
            BerryTreesFeature.lazyLoadTreesForBiome(biome);
        }
        if ((trees = VALID_TREES.get(biome)) == null || trees.isEmpty()) {
            return false;
        }
        for (int i = 0; i < trees.rollsPerChunk; ++i) {
            ConfiguredFeature feature;
            if (!(random.nextDouble() <= trees.chancePerRoll) || (feature = (ConfiguredFeature)RandomHelper.getRandomElementFromCollection(trees.trees)) == null) continue;
            feature.func_242765_a(world, generator, random, pos.func_177982_a(random.nextInt(15), 0, random.nextInt(15)));
        }
        return true;
    }

    private static void lazyLoadTreesForBiome(Biome biome) {
        BerryTreeGroup trees = new BerryTreeGroup();
        if (BetterSpawnerConfig.inBiomeCategory("taigas", biome)) {
            trees.addRollsPerChunk(1).addChancePerRoll(0.1).addTrees(PixelmonFeatures.CHESTO_TREE, PixelmonFeatures.WIKI_TREE, PixelmonFeatures.BLUK_TREE, PixelmonFeatures.TAMATO_TREE, PixelmonFeatures.BELUE_TREE, PixelmonFeatures.CHILAN_TREE, PixelmonFeatures.GANLON_TREE);
        }
        if (BetterSpawnerConfig.inBiomeCategory("plains", biome)) {
            trees.modifyChancePerRoll(0.25).addTrees(PixelmonFeatures.RAWST_TREE, PixelmonFeatures.LUM_TREE, PixelmonFeatures.QUALOT_TREE, PixelmonFeatures.CORNN_TREE, PixelmonFeatures.WATMEL_TREE, PixelmonFeatures.CHOPLE_TREE, PixelmonFeatures.COLBUR_TREE, PixelmonFeatures.ENIGMA_TREE, PixelmonFeatures.PUMKIN_TREE, PixelmonFeatures.GINEMA_TREE, PixelmonFeatures.TOUGA_TREE);
        }
        if (BetterSpawnerConfig.inBiomeCategory("beaches", biome)) {
            trees.modifyChancePerRoll(0.25).addTrees(PixelmonFeatures.MAGO_TREE, PixelmonFeatures.NANAB_TREE, PixelmonFeatures.KELPSY_TREE, PixelmonFeatures.PAMTRE_TREE, PixelmonFeatures.SALAC_TREE, PixelmonFeatures.STARF_TREE, PixelmonFeatures.JABOCA_TREE);
        }
        if (BetterSpawnerConfig.inBiomeCategory("lakes", biome)) {
            trees.addRollsPerChunk(1).modifyChancePerRoll(0.5).addTrees(PixelmonFeatures.PERSIM_TREE, PixelmonFeatures.MAGO_TREE, PixelmonFeatures.IAPAPA_TREE, PixelmonFeatures.HONDEW_TREE, PixelmonFeatures.GREPA_TREE, PixelmonFeatures.COLBUR_TREE, PixelmonFeatures.ROWAP_TREE);
        }
        if (BetterSpawnerConfig.inBiomeCategory("rivers", biome)) {
            trees.addRollsPerChunk(1).modifyChancePerRoll(0.5).addTrees(PixelmonFeatures.PERSIM_TREE, PixelmonFeatures.LUM_TREE, PixelmonFeatures.MAGO_TREE, PixelmonFeatures.POMEG_TREE, PixelmonFeatures.HONDEW_TREE, PixelmonFeatures.GREPA_TREE, PixelmonFeatures.COLBUR_TREE, PixelmonFeatures.KUO_TREE);
        }
        if (BetterSpawnerConfig.inBiomeCategory("jungles", biome)) {
            trees.addRollsPerChunk(2).setChancePerRoll(0.35).addTrees(PixelmonFeatures.ASPEAR_TREE, PixelmonFeatures.ORAN_TREE, PixelmonFeatures.SITRUS_TREE, PixelmonFeatures.FIGY_TREE, PixelmonFeatures.MAGO_TREE, PixelmonFeatures.AGUAV_TREE, PixelmonFeatures.NANAB_TREE, PixelmonFeatures.PINAP_TREE, PixelmonFeatures.MAGOST_TREE, PixelmonFeatures.RABUTA_TREE, PixelmonFeatures.NOMEL_TREE, PixelmonFeatures.OCCA_TREE, PixelmonFeatures.PASSHO_TREE, PixelmonFeatures.WACAN_TREE, PixelmonFeatures.SHUCA_TREE, PixelmonFeatures.COBA_TREE, PixelmonFeatures.PAYAPA_TREE);
        }
        if (BetterSpawnerConfig.inBiomeCategory("forests", biome)) {
            trees.addRollsPerChunk(2).setChancePerRoll(0.35).addTrees(PixelmonFeatures.WEPEAR_TREE, PixelmonFeatures.CHERI_TREE, PixelmonFeatures.LUM_TREE);
        }
        if (BetterSpawnerConfig.inBiomeCategory("roofed", biome)) {
            trees.addRollsPerChunk(1).modifyChancePerRoll(1.15).addTrees(PixelmonFeatures.WEPEAR_TREE);
        }
        if (BetterSpawnerConfig.inBiomeCategory("all forests", biome)) {
            trees.modifyChancePerRoll(1.1).addTrees(PixelmonFeatures.LEPPA_TREE, PixelmonFeatures.ORAN_TREE, PixelmonFeatures.SITRUS_TREE, PixelmonFeatures.GREPA_TREE, PixelmonFeatures.CHOPLE_TREE, PixelmonFeatures.DRASH_TREE, PixelmonFeatures.EGGANT_TREE, PixelmonFeatures.STRIB_TREE, PixelmonFeatures.GINEMA_TREE, PixelmonFeatures.TOUGA_TREE, PixelmonFeatures.NINIKU_TREE, PixelmonFeatures.TOPO_TREE);
        }
        if (BetterSpawnerConfig.inBiomeCategory("savannas", biome)) {
            trees.addRollsPerChunk(-1).modifyChancePerRoll(0.5).addTrees(PixelmonFeatures.CHERI_TREE, PixelmonFeatures.AGUAV_TREE, PixelmonFeatures.HONDEW_TREE, PixelmonFeatures.CORNN_TREE, PixelmonFeatures.SPELON_TREE, PixelmonFeatures.WATMEL_TREE, PixelmonFeatures.CHOPLE_TREE, PixelmonFeatures.CHARTI_TREE, PixelmonFeatures.PUMKIN_TREE, PixelmonFeatures.YAGO_TREE);
        }
        if (BetterSpawnerConfig.inBiomeCategory("mesas", biome)) {
            trees.addRollsPerChunk(-2).modifyChancePerRoll(0.25).addTrees(PixelmonFeatures.POMEG_TREE, PixelmonFeatures.YACHE_TREE, PixelmonFeatures.CHOPLE_TREE, PixelmonFeatures.PUMKIN_TREE);
        }
        if (BetterSpawnerConfig.inBiomeCategory("flowery", biome)) {
            trees.addRollsPerChunk(1).modifyChancePerRoll(1.5).addTrees(PixelmonFeatures.DURIN_TREE, PixelmonFeatures.CHARTI_TREE, PixelmonFeatures.ENIGMA_TREE, PixelmonFeatures.ORAN_TREE, PixelmonFeatures.SITRUS_TREE, PixelmonFeatures.KASIB_TREE, PixelmonFeatures.HABAN_TREE, PixelmonFeatures.BABIRI_TREE, PixelmonFeatures.LIECHI_TREE, PixelmonFeatures.SALAC_TREE, PixelmonFeatures.PETAYA_TREE, PixelmonFeatures.LANSAT_TREE, PixelmonFeatures.MICLE_TREE, PixelmonFeatures.NUTPEA_TREE, PixelmonFeatures.TANGA_TREE);
        }
        if (BetterSpawnerConfig.inBiomeCategory("swamps", biome)) {
            trees.addRollsPerChunk(1).modifyChancePerRoll(1.2).addTrees(PixelmonFeatures.IAPAPA_TREE, PixelmonFeatures.PINAP_TREE, PixelmonFeatures.PAMTRE_TREE, PixelmonFeatures.PASSHO_TREE, PixelmonFeatures.RINDO_TREE, PixelmonFeatures.HABAN_TREE, PixelmonFeatures.COLBUR_TREE, PixelmonFeatures.CUSTAP_TREE, PixelmonFeatures.ROWAP_TREE);
        }
        if (BetterSpawnerConfig.inBiomeCategory("mountainous forests", biome)) {
            trees.modifyChancePerRoll(0.6).addTrees(PixelmonFeatures.PECHA_TREE, PixelmonFeatures.WIKI_TREE, PixelmonFeatures.RAZZ_TREE, PixelmonFeatures.BLUK_TREE, PixelmonFeatures.POMEG_TREE, PixelmonFeatures.TAMATO_TREE, PixelmonFeatures.KEBIA_TREE, PixelmonFeatures.COBA_TREE, PixelmonFeatures.GANLON_TREE, PixelmonFeatures.APICOT_TREE, PixelmonFeatures.STRIB_TREE);
        }
        if (BetterSpawnerConfig.inBiomeCategory("freezing forests", biome)) {
            trees.addRollsPerChunk(-1).modifyChancePerRoll(0.25).addTrees(PixelmonFeatures.BELUE_TREE, PixelmonFeatures.ORAN_TREE, PixelmonFeatures.SITRUS_TREE, PixelmonFeatures.LEPPA_TREE);
        }
        if (BetterSpawnerConfig.inBiomeCategory("redwoods", biome)) {
            trees.addRollsPerChunk(2).modifyChancePerRoll(1.3).addTrees(PixelmonFeatures.CHESTO_TREE, PixelmonFeatures.WIKI_TREE, PixelmonFeatures.BLUK_TREE, PixelmonFeatures.CHILAN_TREE);
        }
        if (BetterSpawnerConfig.inBiomeCategory("magical", biome)) {
            trees.addRollsPerChunk(3).modifyChancePerRoll(1.1).addTrees(PixelmonFeatures.ENIGMA_TREE, PixelmonFeatures.MICLE_TREE, PixelmonFeatures.LEPPA_TREE, PixelmonFeatures.ORAN_TREE, PixelmonFeatures.SITRUS_TREE);
        }
        if (BetterSpawnerConfig.inBiomeCategory("evil", biome)) {
            trees.addRollsPerChunk(-1).modifyChancePerRoll(0.9).addTrees(PixelmonFeatures.ENIGMA_TREE, PixelmonFeatures.MICLE_TREE, PixelmonFeatures.LEPPA_TREE, PixelmonFeatures.ORAN_TREE, PixelmonFeatures.SITRUS_TREE);
        }
        if (BetterSpawnerConfig.inBiomeCategory("birches", biome)) {
            trees.addRollsPerChunk(1).addTrees(PixelmonFeatures.WEPEAR_TREE, PixelmonFeatures.NOMEL_TREE, PixelmonFeatures.KEBIA_TREE);
        }
        VALID_TREES.put(biome, trees);
    }

    private static class BerryTreeGroup {
        private int rollsPerChunk = 1;
        private double chancePerRoll = 0.05;
        private final Set<ConfiguredFeature<BaseTreeFeatureConfig, ?>> trees = Sets.newHashSet();

        private BerryTreeGroup() {
        }

        @SafeVarargs
        public final BerryTreeGroup addTrees(ConfiguredFeature<BaseTreeFeatureConfig, ?> ... trees) {
            this.trees.addAll(Arrays.asList(trees));
            return this;
        }

        public BerryTreeGroup setRollsPerChunk(int rollsPerChunk) {
            this.rollsPerChunk = rollsPerChunk;
            return this;
        }

        public BerryTreeGroup addRollsPerChunk(int rollsPerChunk) {
            this.rollsPerChunk += rollsPerChunk;
            if (this.rollsPerChunk <= 0) {
                this.rollsPerChunk = 1;
            }
            return this;
        }

        public BerryTreeGroup setChancePerRoll(double chancePerRoll) {
            this.chancePerRoll = chancePerRoll;
            return this;
        }

        public BerryTreeGroup addChancePerRoll(double chancePerRoll) {
            this.chancePerRoll += chancePerRoll;
            return this;
        }

        public BerryTreeGroup modifyChancePerRoll(double modification) {
            this.chancePerRoll *= modification;
            return this;
        }

        public boolean isEmpty() {
            return this.trees.isEmpty();
        }
    }
}

