/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.quests.objectives.objectives.player;

import com.pixelmonmod.pixelmon.api.util.helpers.ResourceLocationHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.TextHelper;
import com.pixelmonmod.pixelmon.quests.QuestProgress;
import com.pixelmonmod.pixelmon.quests.editor.QuestElement;
import com.pixelmonmod.pixelmon.quests.editor.QuestElementType;
import com.pixelmonmod.pixelmon.quests.editor.args.ArgumentType;
import com.pixelmonmod.pixelmon.quests.editor.args.QuestElementArgument;
import com.pixelmonmod.pixelmon.quests.objectives.IObjective;
import com.pixelmonmod.pixelmon.quests.objectives.Objective;
import com.pixelmonmod.pixelmon.quests.quest.ArgsIn;
import com.pixelmonmod.pixelmon.quests.quest.Argument;
import com.pixelmonmod.pixelmon.quests.quest.Arguments;
import com.pixelmonmod.pixelmon.quests.quest.Context;
import com.pixelmonmod.pixelmon.quests.quest.Quest;
import com.pixelmonmod.pixelmon.quests.quest.Stage;
import com.pixelmonmod.pixelmon.storage.playerData.QuestData;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.JsonToNBT;
import net.minecraftforge.registries.ForgeRegistries;

public class ItemObjective
implements IObjective {
    private final String identifier;
    private final boolean itemList;
    private final boolean seekMatch;

    public ItemObjective(String identifier) {
        this(identifier, false, true);
    }

    public ItemObjective(String identifier, boolean itemList, boolean seekMatch) {
        this.identifier = identifier;
        this.itemList = itemList;
        this.seekMatch = seekMatch;
    }

    @Override
    public int quantity(Stage stage, QuestData data, QuestProgress progress, Objective objective, Arguments arguments) {
        return arguments.quantity(1, progress);
    }

    @Override
    public String identifier() {
        return this.identifier;
    }

    @Override
    public QuestElement getStructure() {
        return new QuestElement(QuestElementType.OBJECTIVE, this.identifier(), new QuestElementArgument("item", false, false, ArgumentType.ITEM, new String[0]), new QuestElementArgument("count", true, false, ArgumentType.WHOLE_NUMBER, new String[0]), new QuestElementArgument("damage", true, false, ArgumentType.WHOLE_NUMBER, new String[0]), new QuestElementArgument("display_name", true, false, ArgumentType.TEXT, new String[0]), new QuestElementArgument("nbt", true, false, ArgumentType.TEXT, new String[0]));
    }

    @Override
    public Arguments parse(Quest quest, Stage stage, ArgsIn args) {
        return Arguments.create(Argument.from(args.get(0), s -> (Item)ForgeRegistries.ITEMS.getValue(ResourceLocationHelper.of(s)), null), Argument.from(args.get(1), Integer::parseInt, -1), Argument.from(args.get(2), Integer::parseInt, -1), Argument.from(args.get(3), TextHelper::format, ""), Argument.from(args.get(4), s -> {
            try {
                return JsonToNBT.func_180713_a((String)s);
            }
            catch (Exception e) {
                return new CompoundNBT();
            }
        }, new CompoundNBT()));
    }

    @Override
    public boolean test(Stage stage, QuestData data, QuestProgress progress, Objective objective, Arguments arguments, Context context) {
        if (this.itemList) {
            Item item = (Item)arguments.value(0, progress);
            Integer count = (Integer)arguments.value(1, progress);
            Integer damage = (Integer)arguments.value(2, progress);
            String name = (String)arguments.value(3, progress);
            CompoundNBT nbt = (CompoundNBT)arguments.value(4, progress);
            List items = (List)context.get(0);
            for (ItemStack stack : items) {
                if (stack.func_190926_b() || !ItemObjective.compare(stack, item, count, damage, name, nbt)) continue;
                return this.seekMatch;
            }
            return !this.seekMatch;
        }
        return ItemObjective.compare((ItemStack)context.get(0), (Item)arguments.value(0, progress), 1, (Integer)arguments.value(2, progress), (String)arguments.value(3, progress), (CompoundNBT)arguments.value(4, progress));
    }

    public static boolean compare(ItemStack stack, Item item, int count, int damage, String name, CompoundNBT nbt) {
        if (item != null && stack.func_77973_b() != item) {
            return false;
        }
        if (count > 0 && count < stack.func_190916_E()) {
            return false;
        }
        if (damage >= 0 && damage != stack.func_77952_i()) {
            return false;
        }
        if (!name.isEmpty() && !stack.func_200301_q().getString().equalsIgnoreCase(name)) {
            return false;
        }
        if (!nbt.isEmpty()) {
            if (stack.func_77942_o()) {
                CompoundNBT stackNbt = stack.func_77978_p();
                for (String key : nbt.func_150296_c()) {
                    INBT base;
                    if (stackNbt.func_150297_b(key, (int)(base = nbt.func_74781_a(key)).func_74732_a())) {
                        INBT stackBase = stackNbt.func_74781_a(key);
                        if (stackBase.equals(base)) continue;
                        return false;
                    }
                    return false;
                }
            } else {
                return false;
            }
        }
        return true;
    }
}

