/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.quests.client.editor;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.pixelmonmod.pixelmon.client.gui.Resources;
import com.pixelmonmod.pixelmon.client.gui.ScreenHelper;
import com.pixelmonmod.pixelmon.quests.client.editor.QuestEditorScreen;
import com.pixelmonmod.pixelmon.quests.client.editor.QuestEditorState;
import com.pixelmonmod.pixelmon.quests.client.editor.QuestOverviewScreen;
import com.pixelmonmod.pixelmon.quests.client.editor.ui.ListQuestLang;
import com.pixelmonmod.pixelmon.quests.client.editor.ui.SimpleButton;
import com.pixelmonmod.pixelmon.quests.client.editor.ui.TextField;
import com.pixelmonmod.pixelmon.quests.quest.Quest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.util.text.StringTextComponent;

public class QuestStringsScreen
extends Screen {
    private List<SimpleButton> buttons = new ArrayList<SimpleButton>();
    private ListQuestLang list;
    private TextField field;
    private String selection = null;
    private boolean reload = false;
    int prevWidth = -1;
    int prevHeight = -1;

    protected QuestStringsScreen() {
        super(StringTextComponent.field_240750_d_);
    }

    public void func_231160_c_() {
        int xOffset = 20;
        int yOffset = 20;
        int dispWidth = xOffset + 230;
        int dispHeight = yOffset + 180;
        int gap = 3;
        int x = this.field_230708_k_ / 2 - 125;
        int y = this.field_230709_l_ / 2 - 100;
        float titleBorder = 5.5f;
        int listW = 150;
        this.list = new ListQuestLang(this.field_230706_i_.field_71466_p, x + dispWidth / 2 - listW / 2 - 4, y + 15, listW, 9);
        this.list.setFocused(true);
        ArrayList<String> keys = new ArrayList<String>(QuestEditorState.get().getSelectedQuest().getUnlocalizedStringMap().keySet());
        Collections.sort(keys);
        for (String key : keys) {
            this.list.addLine(key);
        }
        this.field = new TextField(this.field_230706_i_.field_71466_p, x, y + dispHeight - 25, dispWidth - 6, 9, -6908266, -7895161);
        this.field.setMaxStringLength(Integer.MAX_VALUE);
        this.field.setTextColor(-1);
        if (this.selection != null) {
            this.field.setText(QuestEditorState.get().getSelectedQuest().getUnlocalizedStringMap().get(this.selection));
        }
        this.addButtons();
    }

    public void addButtons() {
        this.buttons.clear();
        int x = this.field_230708_k_ / 2 - 125;
        int y = this.field_230709_l_ / 2 - 100;
        this.buttons.add(new SimpleButton(0, x + 4, y + 6, 12, Resources.back, 2, 2, -12407307));
    }

    public void func_230430_a_(MatrixStack matrix, int mouseX, int mouseY, float f) {
        int qlh;
        if (!QuestEditorState.get().hasQuestSelected()) {
            return;
        }
        Quest quest = QuestEditorState.get().getSelectedQuest();
        RenderSystem.enableBlend();
        RenderSystem.enableAlphaTest();
        RenderSystem.blendFunc((int)770, (int)771);
        super.func_230430_a_(matrix, mouseX, mouseY, f);
        int xOffset = 20;
        int yOffset = 20;
        int dispWidth = xOffset + 230;
        int dispHeight = yOffset + 180;
        this.field_230706_i_.func_110434_K().func_110577_a(Resources.backgroundTexture);
        int gap = 3;
        int x = this.field_230708_k_ / 2 - 125;
        int y = this.field_230709_l_ / 2 - 100;
        int div = 2 * gap;
        int border = 25;
        int lowerBorder = dispHeight - border - div;
        this.list.height = qlh = 132;
        this.list.displayLines = (int)(9.0f * ((float)qlh / (float)(lowerBorder - border - 12)));
        QuestStringsScreen.func_238463_a_((MatrixStack)matrix, (int)(x - gap), (int)y, (float)0.0f, (float)0.0f, (int)dispWidth, (int)dispHeight, (int)dispWidth, (int)dispHeight);
        RenderSystem.enableBlend();
        RenderSystem.enableAlphaTest();
        RenderSystem.blendFunc((int)770, (int)771);
        RenderSystem.disableBlend();
        RenderSystem.disableAlphaTest();
        for (SimpleButton button : this.buttons) {
            button.draw(matrix);
        }
        this.list.drawBackground(matrix);
        this.list.drawText(matrix);
        this.field.renderWidget(matrix, mouseX, mouseY, this.field_230706_i_.func_184121_ak());
        ScreenHelper.drawCenteredString(matrix, this.selection == null ? "None Selected" : QuestStringsScreen.prettifyLangKey(this.selection), (float)x + (float)dispWidth / 2.0f, (float)(y + dispHeight) - 37.5f, 0xFFFFFF);
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int mouseButton) {
        String clickedOn;
        int xOffset = 20;
        int yOffset = 20;
        int dispWidth = xOffset + 230;
        int dispHeight = yOffset + 180;
        int x = this.field_230708_k_ / 2 - 125;
        int y = this.field_230709_l_ / 2 - 100;
        int id = -1;
        for (SimpleButton button : this.buttons) {
            if (!button.isEnabled() || !button.isWithin(mouseX, mouseY)) continue;
            id = button.id;
            break;
        }
        if (id != -1) {
            this.field_230706_i_.func_147108_a((Screen)new QuestOverviewScreen());
        }
        if ((clickedOn = this.list.mouseClicked(mouseX, mouseY, 0, this.list.yPos + 8)) != null) {
            int lineindex = this.list.lines.indexOf(clickedOn);
            this.list.select(lineindex);
            if (lineindex >= 0 && lineindex < this.list.lines.size()) {
                this.selection = this.list.lines.get(lineindex);
                this.field.setText(QuestEditorState.get().getSelectedQuest().getUnlocalizedStringMap().get(this.selection));
            } else {
                this.selection = null;
            }
        }
        this.field.mouseClicked(mouseX, mouseY, mouseButton);
        return true;
    }

    public boolean func_231046_a_(int c, int i, int modifier) {
        super.func_231046_a_(c, i, modifier);
        if (this.field.isFocused() && this.field.charTyped(Character.forDigit(c, modifier), i) && this.selection != null) {
            QuestEditorState.get().getSelectedQuest().putUnlocalizedString(this.selection, this.field.getText());
        }
        return true;
    }

    public boolean func_231043_a_(double mouseX, double mouseY, double delta) {
        if (delta == 120.0) {
            if (this.list.isFocused) {
                this.list.scrollDown();
            }
        } else if (delta == -120.0 && this.list.isFocused) {
            this.list.scrollUp();
        }
        return true;
    }

    public void func_231023_e_() {
        if (!QuestEditorState.get().hasQuestSelected()) {
            this.field_230706_i_.func_147108_a((Screen)new QuestEditorScreen());
        }
        if (this.prevWidth != -1 && this.prevHeight != -1 && (this.field_230708_k_ != this.prevWidth || this.field_230709_l_ != this.prevHeight)) {
            this.func_231160_c_();
        }
        if (QuestEditorState.get().isDirty() && this.reload) {
            this.reload = false;
        }
        this.prevWidth = this.field_230708_k_;
        this.prevHeight = this.field_230709_l_;
    }

    public static String prettifyLangKey(String line) {
        boolean changed = false;
        try {
            if (line.startsWith("desc-")) {
                String stage = line.replace("desc-", "");
                line = stage.equalsIgnoreCase("X") ? "Quest Complete Description" : "Stage " + stage + " Description";
                changed = true;
            } else if (line.equalsIgnoreCase("name")) {
                line = "Quest Name";
                changed = true;
            } else if (line.startsWith("stage-")) {
                String[] split = line.split("-");
                line = "Stage " + split[1] + " Objective " + (Integer.parseInt(split[2]) + 1);
                changed = true;
            } else if (line.matches("[A-z]+[0-9]+-[A-z]+[0-9]+-[A-z]+[0-9]+")) {
                String[] split = line.split("-");
                line = "Stage " + split[0].substring(1) + " Objective " + (Integer.parseInt(split[1].substring(1)) + 1) + " Element " + (Integer.parseInt(split[2].substring(1)) + 1);
                changed = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!changed) {
            line = "String Key " + line;
        }
        return line;
    }
}

