/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.items.heldItems;

import com.pixelmonmod.pixelmon.api.battles.Terrain;
import com.pixelmonmod.pixelmon.api.pokemon.stats.BattleStatsType;
import com.pixelmonmod.pixelmon.battles.controller.BattleController;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.enums.heldItems.EnumHeldItems;
import com.pixelmonmod.pixelmon.items.HeldItem;
import net.minecraft.item.Item;

public class TerrainSeedItem
extends HeldItem {
    public final Terrain terrain;
    public final BattleStatsType type;

    public TerrainSeedItem(Terrain terrain, BattleStatsType type) {
        super(EnumHeldItems.terrainSeed, new Item.Properties());
        this.terrain = terrain;
        this.type = type;
    }

    @Override
    public void onTerrainSwitch(BattleController bc, PixelmonWrapper user, com.pixelmonmod.pixelmon.battles.status.Terrain terrain) {
        if (terrain != null && terrain.getTerrainType() == this.terrain && user.getBattleStats().modifyStat(1, this.type)) {
            user.consumeItem();
        }
    }

    @Override
    public void applySwitchInEffect(PixelmonWrapper newPokemon) {
        com.pixelmonmod.pixelmon.battles.status.Terrain terrain = newPokemon.bc.globalStatusController.getTerrain();
        if (TerrainSeedItem.canUseItem(newPokemon) && terrain.getTerrainType() == this.terrain && newPokemon.getBattleStats().modifyStat(1, this.type)) {
            newPokemon.consumeItem();
        }
    }
}

