/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.items.heldItems;

import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.egg.BreedingLogicProxy;
import com.pixelmonmod.pixelmon.api.pokemon.stats.BattleStatsType;
import com.pixelmonmod.pixelmon.api.pokemon.stats.Moveset;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.attacks.ImmutableAttack;
import com.pixelmonmod.pixelmon.battles.controller.BattleStage;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.status.CopiedTargetedBoosts;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import com.pixelmonmod.pixelmon.enums.heldItems.EnumHeldItems;
import com.pixelmonmod.pixelmon.items.HeldItem;
import java.util.List;
import java.util.Set;
import net.minecraft.item.Item;

public class MirrorHerbItem
extends HeldItem {
    public MirrorHerbItem() {
        super(EnumHeldItems.mirrorHerb, new Item.Properties());
    }

    @Override
    public void onStatIncrease(PixelmonWrapper pw, PixelmonWrapper affected, int amount, BattleStatsType stat) {
        if (pw.bc.getStage() == BattleStage.DOACTION && pw.isOpponent(affected)) {
            CopiedTargetedBoosts boost = (CopiedTargetedBoosts)pw.getStatus(StatusType.StoredBoostsTargeted);
            if (boost == null) {
                boost = new CopiedTargetedBoosts(affected);
                pw.addStatus(boost, pw);
            }
            if (boost.targets(affected)) {
                boost.addBoost(amount, stat);
            }
        }
    }

    @Override
    public void onStatModified(PixelmonWrapper holder, PixelmonWrapper affected) {
        CopiedTargetedBoosts storedBoosts = (CopiedTargetedBoosts)holder.getStatus(StatusType.StoredBoostsTargeted);
        if (storedBoosts != null && storedBoosts.targets(affected) && !affected.eatingBerry) {
            holder.consumeItem();
            BattleStatsType[] stats = storedBoosts.types.toArray(new BattleStatsType[0]);
            int[] boosts = storedBoosts.counts;
            holder.removeStatus(storedBoosts);
            holder.getBattleStats().modifyStat(boosts, stats);
        }
    }

    @Override
    public void applyEffectInDaycare(Pokemon pokemon, Pokemon partner) {
        Moveset ownerMoveset;
        int openCount;
        if (pokemon != null && partner != null && (openCount = 4 - (ownerMoveset = pokemon.getMoveset()).size()) > 0) {
            Set<ImmutableAttack> allEggMoves = pokemon.getForm().getMoves().getEggMoves();
            List<ImmutableAttack> partnerEggMoves = BreedingLogicProxy.getEggMoves(pokemon.getForm(), partner, allEggMoves);
            int moveIndex = 0;
            block0: for (int movesetIndex = 0; movesetIndex < 4; ++movesetIndex) {
                if (ownerMoveset.get(movesetIndex) != null) continue;
                while (moveIndex < partnerEggMoves.size()) {
                    Attack newAttack = partnerEggMoves.get(moveIndex).ofMutable();
                    if (!ownerMoveset.contains(newAttack)) {
                        ownerMoveset.set(movesetIndex, newAttack);
                        continue block0;
                    }
                    ++moveIndex;
                }
            }
        }
    }
}

