/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities.pixelmon.moveSkills;

import com.pixelmonmod.pixelmon.api.attackAnimations.VariableParticleEffect;
import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.moveskills.MoveSkill;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.util.Scheduling;
import com.pixelmonmod.pixelmon.api.util.helpers.ResourceLocationHelper;
import com.pixelmonmod.pixelmon.battles.attacks.animations.AttackAnimationData;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.GameType;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class Ignite {
    public static MoveSkill createMoveSkill() {
        MoveSkill moveSkill = new MoveSkill("ignite").setName("pixelmon.moveskill.ignite").describe("pixelmon.moveskill.ignite.description1", "pixelmon.moveskill.ignite.description2").setIcon(ResourceLocationHelper.of("pixelmon", "textures/gui/overlay/externalmoves/fire.png")).setUsePP(true).setAnyMoves("Ember", "Fire Blast", "Flamethrower", "Incinerate", "Blast Burn", "Fire Spin", "Flame Burst", "Flame Wheel", "Heat Wave", "Inferno", "Sacred Fire", "Will-O-Wisp").setDefaultCooldownTicks(800).setRange(10);
        return moveSkill.setBehaviourBlockTarget((pixelmon, tup) -> {
            BlockPos lit;
            int posZ;
            int z;
            int posX;
            int x;
            if (!PixelmonConfigProxy.getExternalMoves().isAllowDestructiveExternalMoves()) {
                return -1;
            }
            if (((ServerPlayerEntity)pixelmon.getOwner()).field_71134_c.func_73081_b() == GameType.ADVENTURE) {
                return moveSkill.cooldownTicks;
            }
            ServerPlayerEntity player = (ServerPlayerEntity)pixelmon.getOwner();
            Pokemon pokemon = pixelmon.getPokemon();
            int width = 1;
            int length = 1;
            boolean cross = false;
            if (pokemon.getMoveset().hasAttack(AttackRegistry.FIRE_BLAST)) {
                cross = true;
                width = 3;
                length = 3;
            } else if (pokemon.getMoveset().hasAttack(AttackRegistry.INFERNO, AttackRegistry.SACRED_FIRE, AttackRegistry.INCINERATE)) {
                width = 3;
                length = 3;
            } else {
                length = 3;
            }
            BlockPos pos = (BlockPos)tup.func_76341_a();
            int initPosX = pos.func_177958_n();
            int initPosY = pos.func_177956_o();
            int initPosZ = pos.func_177952_p();
            ArrayList<Vector3d> targets = new ArrayList<Vector3d>();
            if (!cross) {
                for (x = 0; x < width; ++x) {
                    posX = x + initPosX;
                    for (z = 0; z < length; ++z) {
                        posZ = z + initPosZ;
                        lit = Ignite.placeFire(pixelmon.field_70170_p, posX, initPosY, posZ, player);
                        if (lit == null) continue;
                        targets.add(new Vector3d((double)((float)lit.func_177958_n() + 0.5f), (double)lit.func_177956_o(), (double)((float)lit.func_177952_p() + 0.5f)));
                    }
                }
            } else {
                for (x = -1; x < 2; ++x) {
                    posX = x + initPosX;
                    for (z = -1; z < 2; ++z) {
                        posZ = z + initPosZ;
                        if (x != z && x != -z || (lit = Ignite.placeFire(pixelmon.field_70170_p, posX, initPosY, posZ, player)) == null) continue;
                        targets.add(new Vector3d((double)((float)lit.func_177958_n() + 0.5f), (double)lit.func_177956_o(), (double)((float)lit.func_177952_p() + 0.5f)));
                    }
                }
            }
            pixelmon.func_70671_ap().func_75650_a((double)pos.func_177958_n() + 0.5, (double)(pos.func_177956_o() + 1), (double)pos.func_177952_p() + 0.5, 360.0f, 360.0f);
            VariableParticleEffect effect = new VariableParticleEffect(pixelmon.field_70170_p, AttackAnimationData.beam().setScale(0.25f).setPower(30)).setAttackBase(AttackRegistry.getAttackBaseFromEnglishName("Flamethrower").get()).setStartPosition((LivingEntity)pixelmon);
            for (Vector3d target : targets) {
                effect.setEndPosition(target).showAllWithin(20);
            }
            return moveSkill.cooldownTicks;
        });
    }

    private static BlockPos placeFire(World world, int x, int y, int z, ServerPlayerEntity player) {
        int origy = y;
        while (world.func_180495_p(new BlockPos(x, y, z)).func_177230_c() != Blocks.field_150350_a && y < origy + 3) {
            ++y;
        }
        BlockPos pos = new BlockPos(x, y, z);
        BlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (block == Blocks.field_150350_a && block.canHarvestBlock(state, (IBlockReader)world, pos, (PlayerEntity)player)) {
            Scheduling.schedule(10, () -> {
                if (!world.func_73046_m().func_175579_a((ServerWorld)world, pos, (PlayerEntity)player)) {
                    world.func_175656_a(pos, Blocks.field_150480_ab.func_176223_P());
                }
            }, false);
            return pos;
        }
        return null;
    }
}

