/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities.pixelmon;

import com.pixelmonmod.api.pokemon.PokemonSpecification;
import com.pixelmonmod.api.pokemon.requirement.impl.FormRequirement;
import com.pixelmonmod.pixelmon.api.pokemon.Element;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.ability.Ability;
import com.pixelmonmod.pixelmon.api.pokemon.boss.BossTier;
import com.pixelmonmod.pixelmon.api.pokemon.boss.BossTierRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.species.Species;
import com.pixelmonmod.pixelmon.api.pokemon.species.Stats;
import com.pixelmonmod.pixelmon.api.pokemon.species.parameters.flying.FlyingParameters;
import com.pixelmonmod.pixelmon.api.pokemon.species.parameters.swimming.SwimmingParameters;
import com.pixelmonmod.pixelmon.api.pokemon.stats.BattleStatsType;
import com.pixelmonmod.pixelmon.api.pokemon.stats.ExtraStats;
import com.pixelmonmod.pixelmon.api.pokemon.stats.PokemonLevel;
import com.pixelmonmod.pixelmon.api.pokemon.stats.Pokerus;
import com.pixelmonmod.pixelmon.api.pokemon.stats.extraStats.ShearableStats;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.storage.PartyStorage;
import com.pixelmonmod.pixelmon.api.storage.PokemonStorage;
import com.pixelmonmod.pixelmon.comm.EnumUpdateType;
import com.pixelmonmod.pixelmon.entities.SpawnLocationType;
import com.pixelmonmod.pixelmon.entities.pixelmon.AbstractBaseEntity;
import com.pixelmonmod.pixelmon.entities.pixelmon.AbstractClientEntity;
import com.pixelmonmod.pixelmon.entities.pixelmon.tickHandlers.CastformTickHandler;
import com.pixelmonmod.pixelmon.entities.pixelmon.tickHandlers.ShearableTickHandler;
import com.pixelmonmod.pixelmon.entities.pixelmon.tickHandlers.TickHandlerBase;
import com.pixelmonmod.pixelmon.storage.extras.PixelExtrasStorage;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.world.World;

public abstract class AbstractHasStatsEntity
extends AbstractClientEntity {
    private TickHandlerBase tickHandler;
    int friendshipTicker = 0;

    public AbstractHasStatsEntity(EntityType<? extends AbstractHasStatsEntity> type, World par1World) {
        super((EntityType<? extends AbstractClientEntity>)type, par1World);
        this.updateSize();
    }

    public PokemonLevel getLvl() {
        return this.getPokemon().getPokemonLevelContainer();
    }

    float getMoveSpeed() {
        return 0.3f + (1.0f - (200.0f - (float)this.pokemon.getStat(BattleStatsType.SPEED)) / 200.0f) * 0.3f;
    }

    @Override
    public void setBossTier(BossTier tier) {
        if (tier == null) {
            tier = BossTierRegistry.NOT_BOSS;
        }
        if (tier == null) {
            return;
        }
        super.setBossTier(tier);
        if (this.getBossTier().isBoss()) {
            if (this.getBossTier().isMega()) {
                Stats form;
                if (this.getForm().hasMegaForm() && !Objects.equals(this.getSpecies(), PixelmonSpecies.NECROZMA.getValueUnsafe())) {
                    this.setForm(this.getForm().getRandomMegaForm());
                }
                if ((form = this.getSpecies().getForm("primal")) != null) {
                    this.setForm(form);
                }
            }
            if (!tier.getAlwaysPalette().isEmpty()) {
                this.getPokemon().setPalette(tier.getAlwaysPalette());
            } else {
                this.getPokemon().setPalette("none");
            }
        }
    }

    @Override
    public void evolve(PokemonSpecification evolveTo) {
        Stats oldBaseStats = this.getForm();
        Species previous = this.getSpecies();
        Ability ability = this.pokemon.getAbility();
        super.evolve(evolveTo);
        float oldHp = this.pokemon.getMaxHealth();
        float oldHealth = this.func_110143_aJ();
        String s = evolveTo.getValue(FormRequirement.class).orElse(this.getSpecies().getDefaultForm().getDefaultBaseForm());
        this.setForm(s);
        this.getPokemon().evolve(evolveTo);
        this.pokemon.resetAbility();
        this.updateStats();
        float newHealth = this.pokemon.getMaxHealth();
        if (oldHp != 0.0f) {
            newHealth = oldHealth / oldHp * (float)this.pokemon.getMaxHealth();
        }
        this.func_70606_j((int)Math.ceil(newHealth));
        if (this.getOwner() != null) {
            this.update(EnumUpdateType.Name, EnumUpdateType.Stats);
        }
    }

    public void func_70606_j(float par1) {
        super.func_70606_j(par1);
        this.updateHealth();
    }

    public void updateHealth() {
        if (this.func_110143_aJ() > this.func_110138_aP()) {
            super.func_70606_j(this.func_110138_aP());
        }
        if (this.func_110143_aJ() < 0.0f) {
            super.func_70606_j(0.0f);
        }
        if (this.pokemon != null && this.getOwner() != null && !this.field_70170_p.field_72995_K) {
            this.update(EnumUpdateType.HP, EnumUpdateType.Stats);
        }
    }

    public void updateStats() {
        this.pokemon.getStats().setLevelStats(this.pokemon.getNature(), this.pokemon.getForm(), this.pokemon.getPokemonLevel());
        AbstractBaseEntity.SYNC_MAX_HP.set((Entity)this, (Object)this.pokemon.getMaxHealth());
        this.func_110148_a(Attributes.field_233818_a_).func_111128_a((double)this.pokemon.getMaxHealth());
        this.updateHealth();
    }

    public Optional<Pokerus> getPokerus() {
        return Optional.ofNullable(this.pokemon.getPokerus());
    }

    @Override
    public Stats getForm() {
        return this.pokemon == null ? PixelmonSpecies.BULBASAUR.getValueUnsafe().getDefaultForm() : this.pokemon.getForm();
    }

    public void setForm(String form) {
        this.getPokemon().setForm(form);
    }

    public void setForm(Stats form) {
        this.getPokemon().setForm(form);
    }

    public int getNumForms() {
        return this.getSpecies().getForms().size();
    }

    public String getFormIncludeTransformed() {
        if (this.transformed != null) {
            return this.transformed.getForm().getName();
        }
        return this.pokemon.getForm().getName();
    }

    public int getPartyPosition() {
        PokemonStorage storage = this.getStorage();
        if (!(storage instanceof PartyStorage)) {
            return -1;
        }
        return storage.getPosition((Pokemon)this.pokemon).order;
    }

    public SpawnLocationType getDefaultSpawnLocation() {
        if (this.getForm() != null && this.getForm().getSpawn().getSpawnLocations() != null && this.getForm().getSpawn().getSpawnLocations().length > 0) {
            return this.getForm().getSpawn().getSpawnLocations()[0];
        }
        return SpawnLocationType.LAND;
    }

    public FlyingParameters getFlyingParameters() {
        return this.getForm().getMovement().getFlyingParameters();
    }

    public SwimmingParameters getSwimmingParameters() {
        return this.getForm().getMovement().getSwimmingParameters();
    }

    public boolean func_70648_aU() {
        return this.getSpawnLocation() == SpawnLocationType.WATER || this.getForm().getTypes().contains(Element.WATER);
    }

    @Override
    public void func_70071_h_() {
        if (this.getOwner() != null && !this.field_70170_p.field_72995_K && ++this.friendshipTicker % 800 == 0) {
            this.friendshipTicker = 0;
            int amount = this.pokemon.getFriendship() < 200 ? 2 : 1;
            this.pokemon.increaseFriendship(amount);
            PixelExtrasStorage.getData(this.func_184780_dh()).checkPokemon(this.pokemon);
        }
        if (this.hasOwner() && this.getOwner() == null && !this.field_70170_p.field_72995_K) {
            this.func_241204_bJ_();
        }
        if (this.getSpecies().is(PixelmonSpecies.CASTFORM) && !(this.tickHandler instanceof CastformTickHandler)) {
            this.tickHandler = new CastformTickHandler(this);
        } else if (ExtraStats.getExtraStats(this.getSpecies()) instanceof ShearableStats && !(this.tickHandler instanceof ShearableTickHandler)) {
            this.tickHandler = new ShearableTickHandler(this);
        } else if (!(this.tickHandler instanceof ShearableTickHandler) && !(this.tickHandler instanceof CastformTickHandler) || this.getSpecies().is(PixelmonSpecies.FLAAFFY)) {
            this.tickHandler = null;
        }
        if (this.tickHandler != null && this.tickHandler.tick(this.field_70170_p)) {
            this.tickHandler = null;
        }
        super.func_70071_h_();
    }
}

