/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities.npcs;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.events.NPCChatEvent;
import com.pixelmonmod.pixelmon.api.events.npc.NPCEvent;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.registries.PixelmonItems;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.comm.packetHandlers.OpenScreenPacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.npc.SetNPCDataPacket;
import com.pixelmonmod.pixelmon.entities.SpawnLocationType;
import com.pixelmonmod.pixelmon.entities.npcs.NPCChatting;
import com.pixelmonmod.pixelmon.enums.EnumGuiScreen;
import com.pixelmonmod.pixelmon.enums.EnumNPCType;
import com.pixelmonmod.pixelmon.init.registry.EntityRegistration;
import com.pixelmonmod.pixelmon.items.FishingRodItem;
import java.util.ArrayList;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ai.goal.GoalSelector;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.world.World;
import net.minecraftforge.eventbus.api.Event;

public class NPCFisherman
extends NPCChatting {
    public NPCFisherman(EntityType<NPCFisherman> type, World world) {
        super((EntityType<? extends NPCChatting>)type, world);
    }

    public NPCFisherman(World world) {
        this((EntityType<NPCFisherman>)((EntityType)EntityRegistration.NPC_FISHERMAN.get()), world);
        this.npcLocation = SpawnLocationType.LAND_VILLAGER;
    }

    @Override
    public String getDisplayText() {
        return I18n.func_135052_a((String)"pixelmon.npc.fishermanname", (Object[])new Object[0]);
    }

    @Override
    public String getTexture() {
        return "pixelmon:textures/steve/oldfisherman.png";
    }

    @Override
    public boolean interactWithNPC(PlayerEntity player, Hand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        if (player instanceof ServerPlayerEntity) {
            ServerPlayerEntity playerMP = (ServerPlayerEntity)player;
            if (Pixelmon.EVENT_BUS.post((Event)new NPCEvent.Interact(this, EnumNPCType.OldFisherman, (PlayerEntity)playerMP))) {
                return false;
            }
            String loc = playerMP.getLanguage();
            ArrayList<String> chat = new ArrayList<String>();
            if (!itemstack.func_190926_b() && itemstack.func_77973_b() instanceof FishingRodItem) {
                chat.add("gui.oldfisherman.assess");
                if (!itemstack.func_77942_o()) {
                    itemstack.func_77982_d(new CompoundNBT());
                }
                if (itemstack.func_77973_b() != PixelmonItems.oas_rod) {
                    if (!itemstack.func_77978_p().func_74764_b("rodQuality")) {
                        int quality = this.getRodQuality();
                        itemstack.func_77978_p().func_74768_a("rodQuality", quality);
                        chat.add("gui.oldfisherman.rod.quality" + quality);
                    } else {
                        chat.add("gui.oldfisherman.alreadychecked");
                    }
                } else {
                    chat.add("gui.oldfisherman.rod.oas");
                }
            } else {
                boolean hasLog = false;
                for (ItemStack stack1 : playerMP.field_71071_by.field_70462_a) {
                    if (stack1.func_77973_b() != PixelmonItems.fishing_log) continue;
                    hasLog = true;
                    break;
                }
                if (playerMP.field_71071_by.field_184439_c.get(0) != null && ((ItemStack)playerMP.field_71071_by.field_184439_c.get(0)).func_77973_b() == PixelmonItems.fishing_log) {
                    hasLog = true;
                }
                ItemStack log = new ItemStack((IItemProvider)PixelmonItems.fishing_log);
                for (Pokemon pokemon : StorageProxy.getParty(playerMP).getAll()) {
                    if (!hasLog && pokemon != null && pokemon.getSpecies().is(PixelmonSpecies.MAGIKARP) && pokemon.getPalette() != pokemon.getSpecies().getFirstPaletteProperties()) {
                        playerMP.func_191521_c(log);
                        chat.add("gui.oldfisherman.givekarplog");
                        break;
                    }
                    if (!hasLog && pokemon != null && pokemon.getSpecies().is(PixelmonSpecies.SHELLOS) && pokemon.getPalette() != pokemon.getSpecies().getFirstPaletteProperties()) {
                        playerMP.func_191521_c(log);
                        chat.add("gui.oldfisherman.giveshelloslog");
                        break;
                    }
                    if (hasLog || pokemon == null || !pokemon.getSpecies().is(PixelmonSpecies.CLOBBOPUS) || pokemon.getPalette() == pokemon.getSpecies().getFirstPaletteProperties()) continue;
                    playerMP.func_191521_c(log);
                    chat.add("gui.oldfisherman.givecloblog");
                    break;
                }
                if (chat.isEmpty()) {
                    chat.add("gui.oldfisherman.general");
                    chat.add("gui.oldfisherman.general2");
                }
            }
            NPCChatEvent event = new NPCChatEvent(this, player, chat);
            if (Pixelmon.EVENT_BUS.post((Event)event)) {
                return false;
            }
            NetworkHelper.sendPacket(new SetNPCDataPacket(this.getName(loc), event.getChat()), (ServerPlayerEntity)player);
            OpenScreenPacket.open(player, EnumGuiScreen.NPCChat, this.getNPCID());
        } else {
            this.field_70714_bg.func_220888_c().forEach(arg_0 -> ((GoalSelector)this.field_70714_bg).func_85156_a(arg_0));
        }
        return true;
    }

    @Override
    public String getName(String langCode) {
        return "Old Fisherman";
    }

    public int getRodQuality() {
        double percent = RandomHelper.getRandom().nextDouble();
        if (percent <= 0.3856) {
            return 0;
        }
        if (percent <= 0.5785) {
            return 1;
        }
        if (percent <= 0.7079) {
            return 2;
        }
        if (percent <= 0.8044) {
            return 3;
        }
        if (percent <= 0.8815) {
            return 4;
        }
        if (percent <= 0.9449) {
            return 5;
        }
        return 6;
    }

    @Override
    public void func_70024_g(double par1, double par3, double par5) {
    }

    @Override
    public void func_70037_a(CompoundNBT nbt) {
        super.func_70037_a(nbt);
        this.initDefaultAI();
    }
}

