/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.command.impl.wiki;

import com.pixelmonmod.pixelmon.api.command.PixelmonCommandUtils;
import com.pixelmonmod.pixelmon.api.command.WikiCommandStrategy;
import com.pixelmonmod.pixelmon.api.command.WikiCommandStrategyLoader;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.ability.Ability;
import com.pixelmonmod.pixelmon.api.pokemon.stats.BattleStatsType;
import com.pixelmonmod.pixelmon.api.util.helpers.NumberHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.PokemonHelper;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.command.CommandSource;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;

public class MainStrategy
extends WikiCommandStrategy {
    public MainStrategy() {
        super("main");
    }

    @Override
    public void execute(CommandSource sender, Pokemon pokemon, String[] args) {
        sender.func_197030_a((ITextComponent)PixelmonCommandUtils.format("pixelmon.command.wiki.header", PokemonHelper.getFullName(pokemon).func_240701_a_(new TextFormatting[]{TextFormatting.YELLOW, TextFormatting.BOLD})), false);
        sender.func_197030_a((ITextComponent)this.wikiPage(pokemon), false);
        sender.func_197030_a((ITextComponent)this.type(pokemon), false);
        sender.func_197030_a((ITextComponent)this.abilities(pokemon), false);
        sender.func_197030_a((ITextComponent)this.catchRate(pokemon), false);
        sender.func_197030_a((ITextComponent)this.baseStats(pokemon), false);
        sender.func_197030_a((ITextComponent)this.genderRatio(pokemon), false);
        sender.func_197030_a(StringTextComponent.field_240750_d_, false);
        sender.func_197030_a((ITextComponent)this.getBannerStrategies(sender, pokemon, args), false);
    }

    private IFormattableTextComponent getBannerStrategies(CommandSource sender, Pokemon pokemon, String[] args) {
        StringTextComponent banners = new StringTextComponent("");
        boolean isFirst = true;
        for (WikiCommandStrategy strategy : WikiCommandStrategyLoader.getStrategiesPrioritized()) {
            Optional<ITextComponent> text;
            if (strategy == this || !(text = strategy.getBanner(sender, pokemon, args)).isPresent()) continue;
            if (!isFirst) {
                banners = banners.func_230529_a_((ITextComponent)new StringTextComponent(" "));
            }
            banners = banners.func_230529_a_(text.get());
            isFirst = false;
        }
        return banners;
    }

    private IFormattableTextComponent type(Pokemon pokemon) {
        String types = pokemon.getForm().getTypes().stream().map(it -> it.getTranslatedName().getString()).collect(Collectors.joining(", "));
        return PixelmonCommandUtils.format("pixelmon.command.wiki.type", types);
    }

    private IFormattableTextComponent wikiPage(Pokemon pokemon) {
        String wikiUrl = "https://pixelmonmod.com/wiki/index.php?title=" + pokemon.getSpecies().getName();
        return PixelmonCommandUtils.format("pixelmon.command.wiki.web", new Object[0]).func_230529_a_((ITextComponent)PixelmonCommandUtils.format("pixelmon.command.wiki.web.wiki", new Object[0]).func_240700_a_(s -> s.func_240716_a_(new HoverEvent(HoverEvent.Action.field_230550_a_, (Object)new TranslationTextComponent("pixelmon.command.wiki.banner.hover"))).func_240715_a_(new ClickEvent(ClickEvent.Action.OPEN_URL, wikiUrl))));
    }

    private IFormattableTextComponent abilities(Pokemon pokemon) {
        StringTextComponent abilities = new StringTextComponent("");
        Ability[] regular = pokemon.getForm().getAbilities().getAbilities();
        for (int i = 0; i < regular.length; ++i) {
            boolean isLast;
            abilities.func_230529_a_((ITextComponent)regular[i].getTranslatedName());
            boolean bl = isLast = i == regular.length - 1;
            if (isLast) continue;
            abilities.func_230529_a_((ITextComponent)new StringTextComponent(", "));
        }
        Ability[] has = pokemon.getForm().getAbilities().getHiddenAbilities();
        for (int i = 0; i < has.length; ++i) {
            boolean isLast;
            if (i == 0) {
                abilities.func_230529_a_((ITextComponent)new StringTextComponent(", "));
            }
            abilities.func_230529_a_((ITextComponent)has[i].getTranslatedName()).func_230529_a_((ITextComponent)new TranslationTextComponent("pixelmon.command.wiki.ha"));
            boolean bl = isLast = i == has.length - 1;
            if (isLast) continue;
            abilities.func_230529_a_((ITextComponent)new StringTextComponent(", "));
        }
        return PixelmonCommandUtils.format("pixelmon.command.wiki.abilities", abilities);
    }

    private IFormattableTextComponent catchRate(Pokemon pokemon) {
        return PixelmonCommandUtils.format("pixelmon.command.wiki.catchrate", pokemon.getForm().getCatchRate());
    }

    private IFormattableTextComponent baseStats(Pokemon pokemon) {
        return PixelmonCommandUtils.format("pixelmon.command.wiki.basestats", pokemon.getForm().getBattleStats().getStat(BattleStatsType.HP), pokemon.getForm().getBattleStats().getStat(BattleStatsType.ATTACK), pokemon.getForm().getBattleStats().getStat(BattleStatsType.DEFENSE), pokemon.getForm().getBattleStats().getStat(BattleStatsType.SPECIAL_ATTACK), pokemon.getForm().getBattleStats().getStat(BattleStatsType.SPECIAL_DEFENSE), pokemon.getForm().getBattleStats().getStat(BattleStatsType.SPEED));
    }

    private IFormattableTextComponent genderRatio(Pokemon pokemon) {
        if (pokemon.getForm().isGenderless()) {
            return PixelmonCommandUtils.format("pixelmon.command.wiki.genderless", new Object[0]);
        }
        String malePercentage = NumberHelper.formatPercentage(pokemon.getForm().getMalePercentage());
        String femalePercentage = NumberHelper.formatPercentage(100.0f - pokemon.getForm().getMalePercentage());
        return PixelmonCommandUtils.format("pixelmon.command.wiki.genderratio", malePercentage, femalePercentage);
    }
}

