/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.command.impl;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.pixelmonmod.pixelmon.api.command.PixelmonCommandUtils;
import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.battles.BattleRegistry;
import com.pixelmonmod.pixelmon.comm.packetHandlers.chooseMoveset.ChooseMovesetPacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.chooseMoveset.ChoosingMovesetData;
import com.pixelmonmod.pixelmon.command.PixelCommand;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.command.CommandException;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;

public class SetPartyCommand
extends PixelCommand {
    public SetPartyCommand(CommandDispatcher<CommandSource> dispatcher) {
        super(dispatcher, "setparty", "/setparty <lvl>", 2);
    }

    @Override
    public void execute(CommandSource sender, String[] args) throws CommandException {
        if (args.length == 1 || args.length == 2) {
            int level = PixelmonCommandUtils.requireInt(args[0], 1, PixelmonConfigProxy.getGeneral().getMaxLevel(), "parsing.int.invalid", new Object[0]);
            ServerPlayerEntity player = PixelmonCommandUtils.requireEntityPlayer(sender);
            if (BattleRegistry.getBattle((PlayerEntity)player) != null) {
                PixelmonCommandUtils.endCommand("pixelmon.command.general.inbattle", new Object[0]);
            }
            PlayerPartyStorage party = StorageProxy.getParty(player);
            List<Pokemon> team = party.getTeam();
            team.forEach(p -> p.setLevel(level));
            if (args.length == 2 && args[1].equals("moves")) {
                ChoosingMovesetData data = new ChoosingMovesetData(player, team);
                data.next();
                if (!data.pokemonList.isEmpty()) {
                    ChooseMovesetPacket.choosingMoveset.put(player.func_110124_au(), data);
                }
            }
        } else {
            sender.func_197030_a((ITextComponent)PixelmonCommandUtils.format(TextFormatting.RED, "pixelmon.command.general.invalid", new Object[0]), false);
            PixelmonCommandUtils.endCommand(this.getUsage(sender), new Object[0]);
        }
    }

    @Override
    public List<String> getTabCompletions(MinecraftServer server, CommandSource sender, String[] args, BlockPos pos) throws CommandSyntaxException {
        if (args.length == 1) {
            return IntStream.range(1, PixelmonConfigProxy.getGeneral().getMaxLevel()).mapToObj(String::valueOf).collect(Collectors.toList());
        }
        return super.getTabCompletions(server, sender, args, pos);
    }
}

