/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.command.impl;

import com.google.common.collect.Lists;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.pixelmonmod.pixelmon.api.command.PixelmonCommandUtils;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.battles.BattleRegistry;
import com.pixelmonmod.pixelmon.command.PixelCommand;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.command.CommandException;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;

public class PokeRetrieveCommand
extends PixelCommand {
    private static final List<String> ALIASES = Lists.newArrayList((Object[])new String[]{"pretrieve"});

    public PokeRetrieveCommand(CommandDispatcher<CommandSource> dispatcher) {
        super(dispatcher, "pokeretrieve", "/pokeretrieve [player]", 2);
    }

    @Override
    public List<String> getAliases() {
        return ALIASES;
    }

    @Override
    public void execute(CommandSource sender, String[] args) throws CommandException, CommandSyntaxException {
        if ((args = PixelmonCommandUtils.setupCommandTargets(this, sender, args, 0)).length < 1) {
            sender.func_197030_a((ITextComponent)PixelmonCommandUtils.format(TextFormatting.RED, "pixelmon.command.general.invalid", new Object[0]), false);
            PixelmonCommandUtils.endCommand(this.getUsage(sender), new Object[0]);
        }
        ServerPlayerEntity target = PixelmonCommandUtils.requireEntityPlayer(args[0]);
        PlayerPartyStorage storage = PixelmonCommandUtils.require(PixelmonCommandUtils.getPlayerStorage(target), "pixelmon.command.general.invalidplayer", new Object[0]);
        if (BattleRegistry.getBattle((PlayerEntity)target) != null) {
            PixelmonCommandUtils.endCommand("pixelmon.command.pokeretrieve.inbattle", target.func_145748_c_().getString());
        }
        storage.retrieveAll("Command");
        sender.func_197030_a((ITextComponent)PixelmonCommandUtils.format(TextFormatting.GREEN, "pixelmon.command.pokeretrieve.successPlayer", target.func_145748_c_().getString()), false);
    }

    @Override
    public List<String> getTabCompletions(MinecraftServer server, CommandSource sender, String[] args, BlockPos pos) throws CommandSyntaxException {
        if (this.hasPermissionOtherTarget(sender) && args.length == 1) {
            ArrayList<String> suggestions = new ArrayList<String>(PixelmonCommandUtils.tabCompleteUsernames());
            suggestions.add("All");
            return suggestions;
        }
        return super.getTabCompletions(server, sender, args, pos);
    }
}

