/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.command.impl;

import com.google.common.collect.Lists;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.pixelmonmod.pixelmon.api.command.PixelmonCommandUtils;
import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.stats.EVStore;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.command.PixelCommand;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.command.CommandException;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;

public class PokeResetCommand
extends PixelCommand {
    private static final List<String> ALIASES = Lists.newArrayList((Object[])new String[]{"preset"});

    public PokeResetCommand(CommandDispatcher<CommandSource> dispatcher) {
        super(dispatcher, "pokereset", "/pokereset [player] <slot> [lvl]", 2);
    }

    @Override
    public List<String> getAliases() {
        return ALIASES;
    }

    @Override
    public void execute(CommandSource sender, String[] args) throws CommandException {
        if ((args = this.setupTargetOrSourceAsTarget(sender, args, 0)).length < 2 || args.length > 3) {
            sender.func_197030_a((ITextComponent)PixelmonCommandUtils.format(TextFormatting.RED, "pixelmon.command.general.invalid", new Object[0]), false);
            PixelmonCommandUtils.endCommand(this.getUsage(sender), new Object[0]);
        }
        ServerPlayerEntity target = PixelmonCommandUtils.requireEntityPlayer(args[0]);
        PlayerPartyStorage storage = PixelmonCommandUtils.require(PixelmonCommandUtils.getPlayerStorage(target), "pixelmon.command.general.invalidplayer", new Object[0]);
        int slot = PixelmonCommandUtils.requireInt(args[1], 1, 6, "pixelmon.command.invalidslot", args[1]);
        Pokemon pokemon = PixelmonCommandUtils.require(storage.get(slot - 1), "pixelmon.command.partyslot.nothing", target.func_200200_C_().getString());
        int level = 5;
        if (args.length == 3) {
            level = PixelmonCommandUtils.requireInt(args[2], 1, PixelmonConfigProxy.getGeneral().getMaxLevel(), "pixelmon.command.pokereset.maxLvl", PixelmonConfigProxy.getGeneral().getMaxLevel());
        }
        pokemon.setLevel(level);
        pokemon.setExperience(0);
        pokemon.getStats().setEVs(new EVStore());
        pokemon.getStats().getIVs().setHyperTrained(null, false);
        sender.func_197030_a((ITextComponent)PixelmonCommandUtils.format(TextFormatting.GREEN, "pixelmon.command.pokereset.success", target.func_145748_c_().getString(), pokemon.getLocalizedName()), false);
    }

    @Override
    public List<String> getTabCompletions(MinecraftServer server, CommandSource sender, String[] args, BlockPos pos) throws CommandSyntaxException {
        boolean hasPermissionOtherTarget = this.hasPermissionOtherTarget(sender);
        switch (args.length) {
            case 1: {
                if (hasPermissionOtherTarget) {
                    return PixelmonCommandUtils.tabCompleteUsernames();
                }
                return PixelmonCommandUtils.PARTY_SLOTS;
            }
            case 2: {
                if (hasPermissionOtherTarget) {
                    return PixelmonCommandUtils.PARTY_SLOTS;
                }
                return IntStream.range(1, PixelmonConfigProxy.getGeneral().getMaxLevel()).mapToObj(String::valueOf).collect(Collectors.toList());
            }
            case 3: {
                if (!hasPermissionOtherTarget) break;
                return IntStream.range(1, PixelmonConfigProxy.getGeneral().getMaxLevel()).mapToObj(String::valueOf).collect(Collectors.toList());
            }
        }
        return super.getTabCompletions(server, sender, args, pos);
    }
}

