/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.trainerCard;

import com.pixelmonmod.pixelmon.api.economy.BankAccountProxy;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import com.pixelmonmod.pixelmon.comm.packetHandlers.trainerCard.TrainerCardPacket;
import java.util.UUID;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;

@PacketInfo(value={NetworkDirection.PLAY_TO_SERVER})
public class RequestTrainerCardPacket
extends AbstractPixelmonPacket {
    private UUID playerId;

    public RequestTrainerCardPacket() {
        super(PacketDirection.PLAY_SERVER, true);
    }

    public RequestTrainerCardPacket(UUID playerId) {
        super(PacketDirection.PLAY_SERVER, true);
        this.playerId = playerId;
    }

    @Override
    public void encode(PacketBuffer buf) {
        buf.writeLong(this.playerId.getMostSignificantBits());
        buf.writeLong(this.playerId.getLeastSignificantBits());
    }

    @Override
    public void decode(PacketBuffer buf) {
        this.playerId = buf.func_179253_g();
    }

    @Override
    protected void handlePacket(NetworkEvent.Context context) {
        ServerPlayerEntity player = context.getSender().func_184102_h().func_184103_al().func_177451_a(this.playerId);
        if (player != null) {
            PlayerPartyStorage party = StorageProxy.getParty(player);
            this.reply(context, new TrainerCardPacket(player.func_110124_au(), party.trainerCardColor, BankAccountProxy.getBankAccount(player).get().getBalance(), party.playerPokedex.countCaught(), StorageProxy.getParty(player).getAll()));
        }
    }
}

