/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.pokemoneditor;

import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.comm.ChatHandler;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import com.pixelmonmod.pixelmon.comm.packetHandlers.OpenScreenPacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.pokemoneditor.SetEditedPlayerPacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.pokemoneditor.SetEditingPlayerPacket;
import com.pixelmonmod.pixelmon.enums.EnumGuiScreen;
import com.pixelmonmod.pixelmon.items.PokemonEditorItem;
import java.util.UUID;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;

@PacketInfo(value={NetworkDirection.PLAY_TO_SERVER})
public class RespondPokemonEditorAllowed
extends AbstractPixelmonPacket {
    private UUID editingPlayer;
    private boolean allowPokemonEditors;

    public RespondPokemonEditorAllowed() {
        super(PacketDirection.PLAY_SERVER, true);
    }

    public RespondPokemonEditorAllowed(UUID editingPlayer, boolean allowPokemonEditors) {
        super(PacketDirection.PLAY_SERVER, true);
        this.editingPlayer = editingPlayer;
        this.allowPokemonEditors = allowPokemonEditors;
    }

    @Override
    public void encode(PacketBuffer buf) {
        buf.func_179252_a(this.editingPlayer);
        buf.writeBoolean(this.allowPokemonEditors);
    }

    @Override
    public void decode(PacketBuffer buf) {
        this.editingPlayer = buf.func_179253_g();
        this.allowPokemonEditors = buf.readBoolean();
    }

    @Override
    protected void handlePacket(NetworkEvent.Context context) {
        MinecraftServer server = context.getSender().func_184102_h();
        ServerPlayerEntity editingPlayer = server.func_184103_al().func_177451_a(this.editingPlayer);
        ServerPlayerEntity editedPlayer = context.getSender();
        if (editingPlayer != null) {
            if (!PokemonEditorItem.checkPermission(editingPlayer)) {
                return;
            }
            if (this.allowPokemonEditors) {
                PlayerPartyStorage party = StorageProxy.getParty(editedPlayer);
                party.retrieveAll("PokemonEditor");
                NetworkHelper.sendPacket(new SetEditingPlayerPacket(editingPlayer.func_110124_au(), editingPlayer.func_145748_c_().getString()), editedPlayer);
                OpenScreenPacket.open((PlayerEntity)editedPlayer, EnumGuiScreen.EditedPlayer, new int[0]);
                NetworkHelper.sendPacket(new SetEditedPlayerPacket(editedPlayer.func_110124_au(), editedPlayer.func_145748_c_().getString(), party.getAll()), editingPlayer);
                OpenScreenPacket.open((PlayerEntity)editingPlayer, EnumGuiScreen.PokemonEditor, new int[0]);
            } else {
                ChatHandler.sendChat((Entity)editingPlayer, I18n.func_135052_a((String)"gui.pokemoneditor.notallowedplayer", (Object[])new Object[]{editedPlayer.func_145748_c_().getString()}), new Object[0]);
            }
        }
    }
}

