/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.clientStorage;

import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.api.util.helpers.ResourceLocationHelper;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import com.pixelmonmod.pixelmon.items.LureItem;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.registries.ForgeRegistries;

@PacketInfo(value={NetworkDirection.PLAY_TO_SERVER})
public class ChangeLurePacket
extends AbstractPixelmonPacket {
    public Change change;
    public ResourceLocation item;
    public int damage;

    public ChangeLurePacket() {
        super(PacketDirection.PLAY_SERVER, true);
    }

    public ChangeLurePacket(Change change) {
        super(PacketDirection.PLAY_SERVER, true);
        this.change = change;
    }

    public ChangeLurePacket(Change change, Item item, int damage) {
        super(PacketDirection.PLAY_SERVER, true);
        this.change = change;
        this.item = item.getRegistryName();
        this.damage = damage;
    }

    @Override
    public void decode(PacketBuffer buf) {
        this.change = Change.values()[buf.readByte()];
        if (buf.readBoolean()) {
            this.item = ResourceLocationHelper.of(buf.func_218666_n());
            this.damage = buf.readInt();
        }
    }

    @Override
    public void encode(PacketBuffer buf) {
        buf.writeByte(this.change.ordinal());
        buf.writeBoolean(this.item != null);
        if (this.item != null) {
            buf.func_180714_a(this.item.toString());
            buf.writeInt(this.damage);
        }
    }

    @Override
    protected void handlePacket(NetworkEvent.Context context) {
        ServerPlayerEntity player = context.getSender();
        if (player.field_71070_bA == null) {
            return;
        }
        PlayerPartyStorage party = StorageProxy.getParty(player);
        Runnable sync = () -> {
            party.setLureStack(party.getLureStack());
            player.func_71113_k();
        };
        ItemStack held = player.field_71071_by.func_70445_o();
        if (player.func_184812_l_()) {
            if (this.item == null) {
                held = ItemStack.field_190927_a;
            } else {
                Item item = (Item)ForgeRegistries.ITEMS.getValue(this.item);
                if (!(item instanceof LureItem)) {
                    return;
                }
                held = new ItemStack((IItemProvider)item);
                held.func_196085_b(this.damage);
            }
        }
        if (this.change == Change.PUT) {
            if (party.getLure() != null || held.func_190926_b() || !(held.func_77973_b() instanceof LureItem)) {
                sync.run();
                return;
            }
            if (!player.func_184812_l_()) {
                player.field_71071_by.func_70437_b(ItemStack.field_190927_a);
            }
            party.setLureStack(held);
        } else if (this.change == Change.SWAP) {
            if (party.getLure() == null || held.func_190926_b() || !(held.func_77973_b() instanceof LureItem)) {
                sync.run();
                return;
            }
            if (!player.func_184812_l_()) {
                player.field_71071_by.func_70437_b(party.getLureStack());
            }
            party.setLureStack(held);
        } else if (this.change == Change.TAKE) {
            if (party.getLure() == null || !held.func_190926_b()) {
                sync.run();
                return;
            }
            ItemStack lureStack = party.getLureStack();
            party.setLureStack(null);
            if (!player.func_184812_l_()) {
                player.field_71071_by.func_70437_b(lureStack);
            }
        }
    }

    public static enum Change {
        SWAP,
        PUT,
        TAKE;

    }
}

