/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.battles;

import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.stats.links.DelegateLink;
import com.pixelmonmod.pixelmon.api.registries.PixelmonItems;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import com.pixelmonmod.pixelmon.items.EtherItem;
import com.pixelmonmod.pixelmon.items.heldItems.BerryLeppaItem;
import java.util.UUID;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;

@PacketInfo(value={NetworkDirection.PLAY_TO_SERVER})
public class UseEtherPacket
extends AbstractPixelmonPacket {
    private int moveIndex;
    private UUID pokemonUUID;

    public UseEtherPacket() {
        super(PacketDirection.PLAY_SERVER, true);
    }

    public UseEtherPacket(int moveIndex, UUID pokemonUUID) {
        super(PacketDirection.PLAY_SERVER, true);
        this.moveIndex = moveIndex;
        this.pokemonUUID = pokemonUUID;
    }

    @Override
    public void encode(PacketBuffer buf) {
        buf.writeInt(this.moveIndex);
        buf.func_179252_a(this.pokemonUUID);
    }

    @Override
    public void decode(PacketBuffer buf) {
        this.moveIndex = buf.readInt();
        this.pokemonUUID = buf.func_179253_g();
    }

    @Override
    protected void handlePacket(NetworkEvent.Context context) {
        EtherItem ether;
        ServerPlayerEntity player = context.getSender();
        ItemStack itemStack = player.func_184614_ca();
        if (itemStack == null) {
            return;
        }
        Item item = itemStack.func_77973_b();
        PlayerPartyStorage party = StorageProxy.getParty(player);
        Pokemon pokemon = party.find(this.pokemonUUID);
        if (pokemon == null) {
            return;
        }
        Attack attack = pokemon.getMoveset().get(this.moveIndex);
        if (attack == null) {
            return;
        }
        if (item instanceof EtherItem) {
            ether = (EtherItem)item;
        } else if (item instanceof BerryLeppaItem) {
            ether = PixelmonItems.ether;
        } else {
            return;
        }
        if (ether.useEther(new DelegateLink(pokemon), this.moveIndex) && !player.func_184812_l_()) {
            itemStack.func_190918_g(1);
        }
    }
}

