/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.battles;

import com.pixelmonmod.pixelmon.battles.BattleRegistry;
import com.pixelmonmod.pixelmon.battles.controller.BattleController;
import com.pixelmonmod.pixelmon.battles.controller.participants.BattleParticipant;
import com.pixelmonmod.pixelmon.battles.controller.participants.PlayerParticipant;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import java.util.UUID;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;

@PacketInfo(value={NetworkDirection.PLAY_TO_SERVER})
public class FleePacket
extends AbstractPixelmonPacket {
    private UUID fleeingPokemonUUID;

    public FleePacket() {
        super(PacketDirection.PLAY_SERVER, true);
    }

    public FleePacket(UUID fleeingPokemonUUID) {
        super(PacketDirection.PLAY_SERVER, true);
        this.fleeingPokemonUUID = fleeingPokemonUUID;
    }

    @Override
    public void decode(PacketBuffer buffer) {
        this.fleeingPokemonUUID = buffer.func_179253_g();
    }

    @Override
    public void encode(PacketBuffer buffer) {
        buffer.func_179252_a(this.fleeingPokemonUUID);
    }

    @Override
    protected void handlePacket(NetworkEvent.Context context) {
        ServerPlayerEntity player = context.getSender();
        BattleController battleController = BattleRegistry.getBattle((PlayerEntity)player);
        if (battleController == null) {
            return;
        }
        for (BattleParticipant participant : battleController.participants) {
            if (!(participant instanceof PlayerParticipant) || ((PlayerParticipant)participant).player != player) continue;
            battleController.setFlee(this.fleeingPokemonUUID);
        }
    }
}

