/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm;

import com.google.common.collect.Lists;
import com.pixelmonmod.pixelmon.blocks.machines.PokemonRarity;
import com.pixelmonmod.pixelmon.blocks.tileentity.PixelmonSpawnerTileEntity;
import java.util.List;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class PixelmonSpawnerData {
    int x;
    int y;
    int z;
    CompoundNBT nbt;
    List<PokemonRarity> rarities = Lists.newArrayList();

    public PixelmonSpawnerData(BlockPos pos, CompoundNBT nbt, List<PokemonRarity> rarities) {
        this.x = pos.func_177958_n();
        this.y = pos.func_177956_o();
        this.z = pos.func_177952_p();
        this.nbt = nbt;
        this.rarities = rarities;
    }

    public PixelmonSpawnerData() {
    }

    public void writePacketData(PacketBuffer data) {
        data.writeInt(this.x);
        data.writeInt(this.y);
        data.writeInt(this.z);
        data.func_150786_a(this.nbt);
        data.writeInt(this.rarities.size());
        for (PokemonRarity rarity : this.rarities) {
            rarity.writeToBuffer(data);
        }
    }

    public void readPacketData(PacketBuffer data) {
        this.x = data.readInt();
        this.y = data.readInt();
        this.z = data.readInt();
        this.nbt = data.func_150793_b();
        int size = data.readInt();
        for (int i = 0; i < size; ++i) {
            this.rarities.add(PokemonRarity.readFromBuffer(data));
        }
    }

    public void updateTileEntity(World world) {
        BlockPos pos;
        TileEntity tileEntity;
        if (world != null && (tileEntity = world.func_175625_s(pos = new BlockPos(this.x, this.y, this.z))) instanceof PixelmonSpawnerTileEntity) {
            PixelmonSpawnerTileEntity t = (PixelmonSpawnerTileEntity)tileEntity;
            t.func_230337_a_(world.func_180495_p(pos), this.nbt);
            t.pokemonList = this.rarities;
            t.finishEdit();
        }
    }
}

