/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.render.tileEntities;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.pixelmonmod.pixelmon.blocks.enums.GymSignType;
import com.pixelmonmod.pixelmon.blocks.tileentity.GymSignTileEntity;
import com.pixelmonmod.pixelmon.client.render.tileEntities.TileEntityRenderer;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.vector.Vector3f;

public class RenderTileEntityGymSign
extends TileEntityRenderer<GymSignTileEntity> {
    public static final Vector3f ITEM_SCALE = new Vector3f(0.5f, 0.5f, 0.5f);
    public static final Vector3f FLOOR_POSITION_OFFSET = new Vector3f(0.0f, -0.5f, 0.2f);
    public static final Vector3f WALL_POSITION_OFFSET = new Vector3f(0.0f, -0.5f, 0.4f);
    public static final Vector3f HANGING_POSITION_OFFSET = new Vector3f(0.0f, -0.43f, 0.08f);
    public static final int FLOOR_ITEM_ROTATION = 23;
    public static final int FLIPPED_SPRITE_ROTATION = 180;

    public RenderTileEntityGymSign(TileEntityRendererDispatcher dispatcher) {
        super(dispatcher);
        this.disableCulling = true;
    }

    @Override
    public void render(GymSignTileEntity gymSign, BlockState state, double x, double y, double z, float partialTicks, MatrixStack matrix, IRenderTypeBuffer buffer, int combinedLight, int combinedOverlay) {
        ItemStack itemstack = gymSign.getItemInSign();
        if (itemstack == null || itemstack.func_190926_b()) {
            return;
        }
        if (gymSign.getGymSignType() == GymSignType.WALL) {
            this.renderItemAtLocation(matrix, buffer, combinedLight, WALL_POSITION_OFFSET, ITEM_SCALE, true, false, -1, itemstack);
            return;
        }
        if (gymSign.getGymSignType() == GymSignType.FLOOR) {
            this.renderItemAtLocation(matrix, buffer, combinedLight, new Vector3f(FLOOR_POSITION_OFFSET.func_195899_a(), FLOOR_POSITION_OFFSET.func_195900_b(), FLOOR_POSITION_OFFSET.func_195902_c() + 0.03f), ITEM_SCALE, true, true, 23, itemstack);
            this.renderItemAtLocation(matrix, buffer, combinedLight, new Vector3f(FLOOR_POSITION_OFFSET.func_195899_a(), FLOOR_POSITION_OFFSET.func_195900_b(), -FLOOR_POSITION_OFFSET.func_195902_c()), ITEM_SCALE, true, false, 23, itemstack);
            return;
        }
        if (gymSign.getGymSignType() == GymSignType.HANGING) {
            this.renderItemAtLocation(matrix, buffer, combinedLight, HANGING_POSITION_OFFSET, ITEM_SCALE, true, true, -1, itemstack);
            this.renderItemAtLocation(matrix, buffer, combinedLight, new Vector3f(HANGING_POSITION_OFFSET.func_195899_a(), HANGING_POSITION_OFFSET.func_195900_b(), -HANGING_POSITION_OFFSET.func_195902_c()), ITEM_SCALE, true, false, -1, itemstack);
        }
    }

    private void renderItemAtLocation(MatrixStack matrix, IRenderTypeBuffer buffer, int combinedLight, Vector3f position, Vector3f scale, boolean flipSprite, boolean rotateSprite, int rotation, ItemStack itemstack) {
        Minecraft mc = Minecraft.func_71410_x();
        matrix.func_227860_a_();
        matrix.func_227861_a_((double)position.func_195899_a(), (double)position.func_195900_b(), (double)position.func_195902_c());
        if (flipSprite) {
            matrix.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(180.0f));
        }
        if (rotateSprite) {
            matrix.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f));
        }
        if (rotation != -1) {
            matrix.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_((float)rotation));
        }
        matrix.func_227862_a_(scale.func_195899_a(), scale.func_195900_b(), scale.func_195902_c());
        mc.func_175599_af().func_229110_a_(itemstack, ItemCameraTransforms.TransformType.FIXED, combinedLight, OverlayTexture.field_229196_a_, matrix, buffer);
        matrix.func_227865_b_();
    }
}

