/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.render.entity.renderers;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.pixelmonmod.pixelmon.api.util.helpers.QuaternionHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.ResourceLocationHelper;
import com.pixelmonmod.pixelmon.battles.raids.RaidData;
import com.pixelmonmod.pixelmon.client.models.blocks.GenericSmdModel;
import com.pixelmonmod.pixelmon.client.render.GenericModelHolder;
import com.pixelmonmod.pixelmon.client.render.PixelmonRendering;
import com.pixelmonmod.pixelmon.client.render.entity.renderers.PixelmonRenderer;
import com.pixelmonmod.pixelmon.entities.DenEntity;
import java.awt.Color;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderState;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.LivingRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Matrix4f;

public class DenRenderer
extends EntityRenderer<DenEntity> {
    private static final GenericModelHolder<GenericSmdModel> model = new GenericModelHolder("blocks/den/raid_den.pqc");
    private static final ResourceLocation texture = ResourceLocationHelper.of("pixelmon", "textures/block/den/raid_den.png");

    public DenRenderer(EntityRendererManager renderManagerIn) {
        super(renderManagerIn);
    }

    public ResourceLocation getTextureLocation(DenEntity entity) {
        return texture;
    }

    public void render(DenEntity entity, float entityYaw, float partialTicks, MatrixStack matrix, IRenderTypeBuffer buffer, int packedLight) {
        int packedOverlay = LivingRenderer.func_229117_c_((LivingEntity)entity, (float)0.0f);
        IVertexBuilder vertices = buffer.getBuffer(PixelmonRendering.getSMDRenderType(texture));
        matrix.func_227860_a_();
        float scale = 0.6f;
        matrix.func_227862_a_(scale, scale, scale);
        matrix.func_227863_a_(QuaternionHelper.fromEuler(90.0f, 1.0f, 0.0f, 0.0f));
        if (!entity.isBaseHidden()) {
            ((GenericSmdModel)((Object)model.getModel())).getModel().animate();
            model.render(matrix, vertices, packedLight, packedOverlay);
        }
        matrix.func_227865_b_();
        matrix.func_227860_a_();
        this.renderMultipass(matrix, buffer, entity, 0.0, 0.0, 0.0, entityYaw, partialTicks, packedLight);
        matrix.func_227865_b_();
    }

    public void renderMultipass(MatrixStack matrix, IRenderTypeBuffer buffer, DenEntity entity, double x, double y, double z, float entityYaw, float partialTicks, int packedLight) {
        Optional<RaidData> optional = entity.getData();
        boolean decoration = entity.isDecoration();
        boolean raid = optional.isPresent();
        boolean animate = entity.isAnimating();
        int beams = entity.getBeams();
        boolean beamOn = entity.isBeamOn();
        boolean beamTaper = entity.isBeamTaper();
        float beamLength = entity.getBeamLength();
        float beamWidth = entity.getBeamWidth();
        if (raid || decoration) {
            ++entity.ticker;
            float f = ((float)entity.ticker + partialTicks) / 8.0f;
            Entity view = Minecraft.func_71410_x().func_175606_aa();
            if (view == null) {
                view = Minecraft.func_71410_x().field_71439_g;
            }
            float tx = (float)(view.field_70169_q + (view.func_226277_ct_() - view.field_70169_q) * (double)partialTicks);
            float tz = (float)(view.field_70166_s + (view.func_226281_cx_() - view.field_70166_s) * (double)partialTicks);
            float angle = (float)(Math.atan2(entity.func_226281_cx_() - (double)tz, entity.func_226277_ct_() - (double)tx) * 180.0 / Math.PI) + 90.0f;
            float dist = entity.func_70032_d(view) - 20.0f;
            float alpha = Math.min(1.0f, 1.0f - dist / 30.0f);
            matrix.func_227860_a_();
            matrix.func_227861_a_(x, y, z);
            matrix.func_227863_a_(QuaternionHelper.fromEuler(-angle + 45.0f, 0.0f, 1.0f, 0.0f));
            if (raid || beamOn) {
                double rXa = beamWidth <= 0.0f ? -0.3 : (double)(-beamWidth);
                double rXb = beamWidth <= 0.0f ? 0.3 : (double)(-beamWidth);
                double rY = beamLength;
                double rZa = beamWidth <= 0.0f ? -0.3 : (double)(-beamWidth);
                double rZb = beamWidth <= 0.0f ? 0.3 : (double)beamWidth;
                double[] rots = new double[]{Math.sin((double)f * 0.13) * 50.0, Math.sin((double)(-f) * 0.07) * 65.0, Math.cos((double)f * 0.1) * 55.0, Math.sin((double)(-f) * 0.14) * 50.0, Math.sin((double)f * 0.11) * 75.0, Math.cos((double)(-f) * 0.04) * 70.0};
                float[] sizes = new float[]{1.0f, 0.75f, 0.55f, 0.4f, 0.2f, 0.1f};
                Color color = entity.getColorRGBA();
                for (int i = 0; i < Math.min(5, raid ? optional.get().getStars() + 1 : beams); ++i) {
                    float size = sizes[i];
                    matrix.func_227860_a_();
                    if (animate) {
                        size = (float)((double)size + Math.abs(rots[i]) * 0.002);
                    } else {
                        matrix.func_227863_a_(QuaternionHelper.fromEuler(45.0f, 0.0f, 1.0f, 0.0f));
                    }
                    matrix.func_227861_a_((double)i * -0.01, 0.0, 0.0);
                    Matrix4f mat = matrix.func_227866_c_().func_227870_a_();
                    IVertexBuilder bufferbuilder = buffer.getBuffer(beamTaper ? PixelmonRendering.getTriangleRenderType(RenderState.ShadeModelState.field_228520_l_, PixelmonRendering.GLOW_TRANSPARENCY, RenderType.field_228532_x_, RenderType.field_228517_i_, RenderType.field_228491_A_, RenderType.field_228529_u_, RenderType.field_228530_v_) : PixelmonRendering.getQuadRenderType(new RenderState.TextureState(PixelmonRendering.EMPTY_TEX, false, false), RenderState.ShadeModelState.field_228520_l_, PixelmonRendering.GLOW_TRANSPARENCY, RenderType.field_228532_x_, RenderType.field_228517_i_, RenderType.field_228491_A_, RenderType.field_228529_u_, RenderType.field_228530_v_));
                    bufferbuilder.func_227888_a_(mat, (float)(rXa * (double)size), 0.05f, (float)(rZa * (double)size)).func_225586_a_(color.getRed(), color.getGreen(), color.getBlue(), 255).func_181675_d();
                    bufferbuilder.func_227888_a_(mat, (float)(rXb * (double)size), 0.05f, (float)(rZb * (double)size)).func_225586_a_(color.getRed(), color.getGreen(), color.getBlue(), 255).func_181675_d();
                    if (beamTaper) {
                        bufferbuilder.func_227888_a_(mat, (float)((rXb + rXa) / 2.0 * (double)size), (float)(rY * 2.0), (float)((rZb + rZa) / 2.0 * (double)size)).func_225586_a_(color.getRed(), color.getGreen(), color.getBlue(), 0).func_181675_d();
                    } else {
                        bufferbuilder.func_227888_a_(mat, (float)(rXb * (double)size), (float)(rY * 2.0), (float)(rZb * (double)size)).func_225586_a_(color.getRed(), color.getGreen(), color.getBlue(), 255).func_181675_d();
                        bufferbuilder.func_227888_a_(mat, (float)(rXa * (double)size), (float)(rY * 2.0), (float)(rZa * (double)size)).func_225586_a_(color.getRed(), color.getGreen(), color.getBlue(), 255).func_181675_d();
                    }
                    matrix.func_227865_b_();
                }
            }
            if (alpha > 0.0f) {
                entity.getDisplay().ifPresent(display -> {
                    matrix.func_227860_a_();
                    matrix.func_227861_a_(-1.25, 1.5, 1.25);
                    matrix.func_227862_a_(1.5f, 1.5f, 1.5f);
                    matrix.func_227863_a_(QuaternionHelper.fromEuler(f / 2.0f, 0.0f, 1.0f, 0.0f));
                    EntityRendererManager renderManager = Minecraft.func_71410_x().func_175598_ae();
                    display.setRenderColor(0.0f, 0.0f, 0.0f, alpha);
                    EntityRenderer entityClassRenderObject = renderManager.func_78713_a((Entity)display);
                    PixelmonRenderer rp = (PixelmonRenderer)entityClassRenderObject;
                    rp.render(display, 0.0f, partialTicks, matrix, buffer, packedLight);
                    matrix.func_227865_b_();
                });
            }
            matrix.func_227865_b_();
        }
    }
}

