/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.music;

import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.client.music.PixelmonMusic;
import com.pixelmonmod.pixelmon.client.music.VoidMusicTicker;
import com.pixelmonmod.pixelmon.init.registry.SoundRegistration;
import com.pixelmonmod.pixelmon.sounds.BattleMusicType;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.ISoundEventAccessor;
import net.minecraft.client.audio.LocatableSound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.audio.Sound;
import net.minecraft.client.audio.SoundEventAccessor;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;

public class BattleMusic {
    private static LocatableSound song;

    public static void startBattleMusic(BattleMusicType type, int index, long playtime, boolean repeat) {
        if (playtime == -1L) {
            BattleMusic.endBattleMusic();
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        VoidMusicTicker.replaceMusicTicker();
        if (BattleMusic.isPlaying()) {
            mc.func_147118_V().func_147683_b((ISound)song);
            song = null;
        }
        SoundEvent soundEvent = (SoundEvent)SoundRegistration.BATTLE_MUSIC.get((Object)type).get();
        FixedTrackSound record = new FixedTrackSound(soundEvent, index, SoundCategory.MUSIC, PixelmonConfigProxy.getBattle().getBattleMusicVolume(), 1.0f, repeat, 0, ISound.AttenuationType.NONE, 0.0f, 0.0f, 0.0f);
        song = record;
        PixelmonMusic.fadeSoundToStart((ISound)record, 2000L);
    }

    public static void endBattleMusic() {
        Minecraft mc = Minecraft.func_71410_x();
        if (BattleMusic.isPlaying()) {
            PixelmonMusic.fadeSoundToStop((ISound)song, 2000L, VoidMusicTicker::restoreMusicTicker);
        } else if (mc.func_181535_r() instanceof VoidMusicTicker) {
            VoidMusicTicker.restoreMusicTicker();
        }
        song = null;
    }

    public static boolean isPlaying() {
        return song != null && PixelmonMusic.getSoundHandler().func_215294_c((ISound)song);
    }

    public static class FixedTrackSound
    extends SimpleSound {
        int index;

        public FixedTrackSound(SoundEvent soundIn, int index, SoundCategory categoryIn, float volumeIn, float pitchIn, boolean repeatIn, int repeatDelayIn, ISound.AttenuationType attenuationTypeIn, float xIn, float yIn, float zIn) {
            super(soundIn.func_187503_a(), categoryIn, volumeIn, pitchIn, repeatIn, repeatDelayIn, attenuationTypeIn, (double)xIn, (double)yIn, (double)zIn, false);
            this.index = index;
        }

        public SoundEventAccessor func_184366_a(SoundHandler handler) {
            List accessorList;
            SoundEventAccessor accessor = super.func_184366_a(handler);
            if (this.index >= 0 && (accessorList = (List)ObfuscationReflectionHelper.getPrivateValue(SoundEventAccessor.class, (Object)accessor, (String)"field_188716_a")).size() > this.index) {
                this.field_184367_a = (Sound)((ISoundEventAccessor)accessorList.get(this.index)).func_148720_g();
            }
            return accessor;
        }

        public ISound.AttenuationType func_147656_j() {
            return super.func_147656_j();
        }
    }
}

