/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.gui.pokemoneditor;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.item.pokeball.PokeBall;
import com.pixelmonmod.pixelmon.api.pokemon.item.pokeball.PokeBallRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.species.Species;
import com.pixelmonmod.pixelmon.api.pokemon.stats.extraStats.LakeTrioStats;
import com.pixelmonmod.pixelmon.api.pokemon.stats.extraStats.MeltanStats;
import com.pixelmonmod.pixelmon.api.pokemon.stats.extraStats.MewStats;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.storage.PokemonStorage;
import com.pixelmonmod.pixelmon.api.storage.StoragePosition;
import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.client.ServerStorageDisplay;
import com.pixelmonmod.pixelmon.client.gui.pokemoneditor.IndividualEditorBaseScreen;
import com.pixelmonmod.pixelmon.client.gui.pokemoneditor.PokemonEditorPartyScreen;
import com.pixelmonmod.pixelmon.client.gui.widgets.TabCompleteTranslateableTextField;
import com.pixelmonmod.pixelmon.comm.packetHandlers.pokemoneditor.ChangePokemonPacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.pokemoneditor.DeletePokemonPacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.pokemoneditor.UpdatePlayerPokemonPacket;
import java.util.List;
import java.util.Locale;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Tuple;
import net.minecraft.util.text.ITextComponent;

public class PokemonEditorIndividualScreen
extends IndividualEditorBaseScreen {
    private TabCompleteTranslateableTextField<PokeBall> pokeBallText;
    private TextFieldWidget cloneText;
    private TextFieldWidget lakeText;
    private TextFieldWidget smeltText;
    private ItemStack pokeBall;

    PokemonEditorIndividualScreen(Pokemon p, ITextComponent titleText) {
        super(p, titleText);
    }

    @Override
    public void func_231160_c_() {
        this.field_230706_i_.field_195559_v.func_197967_a(true);
        this.textFields.clear();
        this.cloneText = null;
        this.lakeText = null;
        this.smeltText = null;
        super.func_231160_c_();
        this.pokeBallText = new TabCompleteTranslateableTextField<PokeBall>(16, this.field_230706_i_.field_71466_p, this.field_230708_k_ / 2 - 120, this.field_230709_l_ / 2 + 72, 90, 17).setCompletions(PokeBallRegistry.getAll());
        this.pokeBall = this.p.getBall().getBallItem();
        this.pokeBallText.setValue(this.p.getBall());
        this.pokeBallText.func_212954_a(s -> {
            PokeBall ball = PokeBallRegistry.getPokeBall(s.toLowerCase(Locale.ROOT).replace(" ", "_").replace("\u00e9", "e")).orElse((PokeBall)null);
            if (ball == null || this.pokeBallText.getTranslatableValue().is(ball)) {
                return;
            }
            this.pokeBallText.setValue(ball);
            this.updatePokeBall();
        });
        this.field_230705_e_.add(this.pokeBallText);
        int formOffset = 20;
        if (this.p.getSpecies().is(PixelmonSpecies.MEW)) {
            this.cloneText = this.createExtraTextField();
            this.cloneText.field_230691_m_ += formOffset;
            this.cloneText.func_146180_a(Integer.toString(((MewStats)this.p.getExtraStats()).numCloned));
            this.textFields.add(this.cloneText);
            this.field_230705_e_.add(this.cloneText);
        } else if (this.p.getSpecies().is(PixelmonSpecies.AZELF) || this.p.getSpecies().is(PixelmonSpecies.MESPRIT) || this.p.getSpecies().is(PixelmonSpecies.UXIE)) {
            this.lakeText = this.createExtraTextField();
            this.lakeText.field_230691_m_ += formOffset;
            this.lakeText.func_146180_a(Integer.toString(((LakeTrioStats)this.p.getExtraStats()).numEnchanted));
            this.textFields.add(this.lakeText);
            this.field_230705_e_.add(this.lakeText);
        } else if (this.p.getSpecies().is(PixelmonSpecies.MELTAN)) {
            this.smeltText = this.createExtraTextField();
            this.smeltText.field_230691_m_ += formOffset;
            this.smeltText.func_146180_a(Integer.toString(((MeltanStats)this.p.getExtraStats()).nuggetsFed));
            this.textFields.add(this.smeltText);
            this.field_230705_e_.add(this.smeltText);
        }
    }

    @Override
    public void setPokemon(Pokemon pokemon) {
        super.setPokemon(pokemon);
        if (!pokemon.getSpecies().is(PixelmonSpecies.MEW)) {
            this.cloneText = null;
        }
        if (!pokemon.getSpecies().is(PixelmonSpecies.MESPRIT, PixelmonSpecies.AZELF, PixelmonSpecies.UXIE)) {
            this.lakeText = null;
        }
        if (!pokemon.getSpecies().is(PixelmonSpecies.MELTAN)) {
            this.smeltText = null;
        }
    }

    @Override
    protected void drawBackgroundUnderMenus(MatrixStack matrix, float partialTicks, int mouseX, int mouseY) {
        super.drawBackgroundUnderMenus(matrix, partialTicks, mouseX, mouseY);
        if (this.pokeBallText != null) {
            this.field_230706_i_.field_71466_p.func_238421_b_(matrix, I18n.func_135052_a((String)"gui.pokemoneditor.pokeball", (Object[])new Object[0]), (float)this.field_230708_k_ / 2.0f - 180.0f, (float)this.field_230709_l_ / 2.0f + 75.0f, 0);
            this.field_230707_j_.func_180450_b(this.pokeBall, this.field_230708_k_ / 2 - 28, this.field_230709_l_ / 2 + 72);
        }
        this.drawExtraText(matrix, mouseX, mouseY, partialTicks, this.cloneText, "gui.pokemoneditor.clones");
        this.drawExtraText(matrix, mouseX, mouseY, partialTicks, this.lakeText, "gui.pokemoneditor.lake_enchants");
        this.drawExtraText(matrix, mouseX, mouseY, partialTicks, this.smeltText, "gui.pokemoneditor.smelts");
    }

    private void updatePokeBall() {
        this.pokeBall = this.pokeBallText.getTranslatableValue().getBallItem();
        this.p.setBall(this.pokeBallText.getTranslatableValue());
    }

    @Override
    public boolean mouseClickedUnderMenus(double x, double y, int mouseButton) {
        for (TextFieldWidget textField : new TextFieldWidget[]{this.pokeBallText, this.cloneText, this.lakeText}) {
            if (textField == null) continue;
            textField.func_231044_a_(x, y, mouseButton);
        }
        return super.mouseClickedUnderMenus(x, y, mouseButton);
    }

    @Override
    protected void changePokemon(Species newPokemon) {
        NetworkHelper.sendToServer(new ChangePokemonPacket(this.p.getUUID(), newPokemon));
    }

    @Override
    protected void deletePokemon() {
        NetworkHelper.sendToServer(new DeletePokemonPacket(this.p.getUUID()));
        this.field_230706_i_.func_147108_a((Screen)new PokemonEditorPartyScreen());
    }

    @Override
    protected void saveAndClose() {
        NetworkHelper.sendToServer(new UpdatePlayerPokemonPacket(this.p));
        this.field_230706_i_.func_147108_a((Screen)new PokemonEditorPartyScreen());
    }

    @Override
    public List<Pokemon> getPokemonList() {
        return ServerStorageDisplay.editedPokemon;
    }

    @Override
    protected boolean checkFields() {
        boolean valid = super.checkFields();
        if (this.cloneText != null) {
            try {
                int numClones = Integer.parseInt(this.cloneText.func_146179_b());
                if (numClones < 0) {
                    this.cloneText.func_146180_a("0");
                    valid = false;
                } else if (numClones > 3) {
                    this.cloneText.func_146180_a(Integer.toString(3));
                    valid = false;
                } else {
                    ((MewStats)this.p.getExtraStats()).numCloned = numClones;
                }
            }
            catch (NumberFormatException e) {
                this.cloneText.func_146180_a("");
                valid = false;
            }
        }
        if (this.lakeText != null) {
            try {
                int enchants = Integer.parseInt(this.lakeText.func_146179_b());
                if (enchants < 0) {
                    this.lakeText.func_146180_a("0");
                    valid = false;
                } else if (enchants > PixelmonConfigProxy.getGeneral().getLakeTrioMaxEnchants()) {
                    this.lakeText.func_146180_a(Integer.toString(PixelmonConfigProxy.getGeneral().getLakeTrioMaxEnchants()));
                    valid = false;
                } else {
                    ((LakeTrioStats)this.p.getExtraStats()).numEnchanted = enchants;
                }
            }
            catch (NumberFormatException e) {
                this.lakeText.func_146180_a("");
                valid = false;
            }
        }
        if (this.smeltText != null) {
            try {
                int smelts = Integer.parseInt(this.smeltText.func_146179_b());
                if (smelts < 0) {
                    this.smeltText.func_146180_a("0");
                    valid = false;
                } else {
                    ((MeltanStats)this.p.getExtraStats()).nuggetsFed = smelts;
                }
            }
            catch (NumberFormatException e) {
                this.smeltText.func_146180_a("");
                valid = false;
            }
        }
        return valid;
    }

    @Override
    public Pokemon[] getPokemon() {
        return new Pokemon[]{this.p};
    }

    @Override
    public void setPokemon(Pokemon ... pokemon) {
        if (pokemon.length < 1) {
            return;
        }
        Tuple<PokemonStorage, StoragePosition> storageAndPosition = this.p.getStorageAndPosition();
        this.p = pokemon[0];
        this.p.setStorage((PokemonStorage)storageAndPosition.func_76341_a(), (StoragePosition)storageAndPosition.func_76340_b());
        NetworkHelper.sendToServer(new UpdatePlayerPokemonPacket(this.p, ((StoragePosition)storageAndPosition.func_76340_b()).order));
    }
}

