/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.gui.pokechecker;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.SharedConstants;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class TextFieldTransparent
extends AbstractGui {
    private final FontRenderer fontRenderer;
    private final int xPos;
    private final int yPos;
    private final int width;
    private final int height;
    private String text = "";
    private int maxStringLength = 40;
    private int cursorCounter;
    private boolean enableBackgroundDrawing = true;
    private boolean canLoseFocus = true;
    private boolean isFocused = false;
    private boolean isEnabled = true;
    private int field_73816_n = 0;
    private int cursorPosition = 0;
    private int selectionEnd = 0;
    private int enabledColor = 0xE0E0E0;
    private int disabledColor = 0x707070;
    private boolean visible = true;

    public TextFieldTransparent(FontRenderer par1FontRenderer, int par2, int par3, int par4, int par5) {
        this.fontRenderer = par1FontRenderer;
        this.xPos = par2;
        this.yPos = par3;
        this.width = par4;
        this.height = par5;
    }

    public void updateCursorCounter() {
        ++this.cursorCounter;
    }

    public void setText(String par1Str) {
        this.text = par1Str.length() > this.maxStringLength ? par1Str.substring(0, this.maxStringLength) : par1Str;
        this.setCursorPositionEnd();
    }

    public String getText() {
        return this.text;
    }

    public String getSelectedtext() {
        int var1 = this.cursorPosition < this.selectionEnd ? this.cursorPosition : this.selectionEnd;
        int var2 = this.cursorPosition < this.selectionEnd ? this.selectionEnd : this.cursorPosition;
        return this.text.substring(var1, var2);
    }

    public void writeText(String par1Str) {
        int var8;
        String var2 = "";
        String var3 = SharedConstants.func_71565_a((String)par1Str);
        int var4 = this.cursorPosition < this.selectionEnd ? this.cursorPosition : this.selectionEnd;
        int var5 = this.cursorPosition < this.selectionEnd ? this.selectionEnd : this.cursorPosition;
        int var6 = this.maxStringLength - this.text.length() - (var4 - this.selectionEnd);
        if (!this.text.isEmpty()) {
            var2 = var2 + this.text.substring(0, var4);
        }
        if (var6 < var3.length()) {
            var2 = var2 + var3.substring(0, var6);
            var8 = var6;
        } else {
            var2 = var2 + var3;
            var8 = var3.length();
        }
        if (!this.text.isEmpty() && var5 < this.text.length()) {
            var2 = var2 + this.text.substring(var5);
        }
        this.text = var2;
        this.moveCursorBy(var4 - this.selectionEnd + var8);
    }

    public void deleteWords(int par1) {
        if (!this.text.isEmpty()) {
            if (this.selectionEnd != this.cursorPosition) {
                this.writeText("");
            } else {
                this.deleteFromCursor(this.getNthWordFromCursor(par1) - this.cursorPosition);
            }
        }
    }

    public void deleteFromCursor(int par1) {
        if (!this.text.isEmpty()) {
            if (this.selectionEnd != this.cursorPosition) {
                this.writeText("");
            } else {
                boolean var2 = par1 < 0;
                int var3 = var2 ? this.cursorPosition + par1 : this.cursorPosition;
                int var4 = var2 ? this.cursorPosition : this.cursorPosition + par1;
                String var5 = "";
                if (var3 >= 0) {
                    var5 = this.text.substring(0, var3);
                }
                if (var4 < this.text.length()) {
                    var5 = var5 + this.text.substring(var4);
                }
                this.text = var5;
                if (var2) {
                    this.moveCursorBy(par1);
                }
            }
        }
    }

    public int getNthWordFromCursor(int par1) {
        return this.getNthWordFromPos(par1, this.getCursorPosition());
    }

    public int getNthWordFromPos(int par1, int par2) {
        return this.func_73798_a(par1, this.getCursorPosition(), true);
    }

    public int func_73798_a(int par1, int par2, boolean par3) {
        int var4 = par2;
        boolean var5 = par1 < 0;
        int var6 = Math.abs(par1);
        for (int var7 = 0; var7 < var6; ++var7) {
            if (var5) {
                while (par3 && var4 > 0 && this.text.charAt(var4 - 1) == ' ') {
                    --var4;
                }
                while (var4 > 0 && this.text.charAt(var4 - 1) != ' ') {
                    --var4;
                }
                continue;
            }
            int var8 = this.text.length();
            if ((var4 = this.text.indexOf(32, var4)) == -1) {
                var4 = var8;
                continue;
            }
            while (par3 && var4 < var8 && this.text.charAt(var4) == ' ') {
                ++var4;
            }
        }
        return var4;
    }

    public void moveCursorBy(int par1) {
        this.setCursorPosition(this.selectionEnd + par1);
    }

    public void setCursorPosition(int par1) {
        this.cursorPosition = par1;
        int var2 = this.text.length();
        if (this.cursorPosition < 0) {
            this.cursorPosition = 0;
        }
        if (this.cursorPosition > var2) {
            this.cursorPosition = var2;
        }
        this.setSelectionPos(this.cursorPosition);
    }

    public void setCursorPositionZero() {
        this.setCursorPosition(0);
    }

    public void setCursorPositionEnd() {
        this.setCursorPosition(this.text.length());
    }

    public boolean charTyped(char par1, int par2) {
        if (this.isEnabled && this.isFocused) {
            Minecraft mc = Minecraft.func_71410_x();
            switch (par1) {
                case '\u0001': {
                    this.setCursorPositionEnd();
                    this.setSelectionPos(0);
                    return true;
                }
                case '\u0003': {
                    mc.field_195559_v.func_197960_a(this.getSelectedtext());
                    return true;
                }
                case '\u0016': {
                    this.writeText(mc.field_195559_v.func_197965_a());
                    return true;
                }
                case '\u0018': {
                    mc.field_195559_v.func_197960_a(this.getSelectedtext());
                    this.writeText("");
                    return true;
                }
            }
            switch (par2) {
                case 14: {
                    if (Screen.func_231172_r_()) {
                        this.deleteWords(-1);
                    } else {
                        this.deleteFromCursor(-1);
                    }
                    return true;
                }
                case 199: {
                    if (Screen.func_231173_s_()) {
                        this.setSelectionPos(0);
                    } else {
                        this.setCursorPositionZero();
                    }
                    return true;
                }
                case 203: {
                    if (Screen.func_231173_s_()) {
                        if (Screen.func_231172_r_()) {
                            this.setSelectionPos(this.getNthWordFromPos(-1, this.getSelectionEnd()));
                        } else {
                            this.setSelectionPos(this.getSelectionEnd() - 1);
                        }
                    } else if (Screen.func_231172_r_()) {
                        this.setCursorPosition(this.getNthWordFromCursor(-1));
                    } else {
                        this.moveCursorBy(-1);
                    }
                    return true;
                }
                case 205: {
                    if (Screen.func_231173_s_()) {
                        if (Screen.func_231172_r_()) {
                            this.setSelectionPos(this.getNthWordFromPos(1, this.getSelectionEnd()));
                        } else {
                            this.setSelectionPos(this.getSelectionEnd() + 1);
                        }
                    } else if (Screen.func_231172_r_()) {
                        this.setCursorPosition(this.getNthWordFromCursor(1));
                    } else {
                        this.moveCursorBy(1);
                    }
                    return true;
                }
                case 207: {
                    if (Screen.func_231173_s_()) {
                        this.setSelectionPos(this.text.length());
                    } else {
                        this.setCursorPositionEnd();
                    }
                    return true;
                }
                case 211: {
                    if (Screen.func_231172_r_()) {
                        this.deleteWords(1);
                    } else {
                        this.deleteFromCursor(1);
                    }
                    return true;
                }
            }
            if (SharedConstants.func_71566_a((char)par1)) {
                this.writeText(Character.toString(par1));
                return true;
            }
            return false;
        }
        return false;
    }

    public void keyPressed(int keyCode) {
        if (keyCode == 259 && !this.text.isEmpty()) {
            this.deleteFromCursor(-1);
        }
        if (keyCode == 261 && !this.text.isEmpty()) {
            this.deleteFromCursor(1);
        }
        if (keyCode == 263) {
            this.setCursorPosition(this.getCursorPosition() - 1);
        }
        if (keyCode == 262) {
            this.setCursorPosition(this.getCursorPosition() + 1);
        }
    }

    public void mouseClicked(double par1, double par2, int par3) {
        boolean var4;
        boolean bl = var4 = par1 >= (double)this.xPos && par1 < (double)(this.xPos + this.width) && par2 >= (double)this.yPos && par2 < (double)(this.yPos + this.height);
        if (this.canLoseFocus) {
            this.setFocused(this.isEnabled && var4);
        }
        if (this.isFocused && par3 == 0) {
            double var5 = par1 - (double)this.xPos;
            if (this.enableBackgroundDrawing) {
                var5 -= 4.0;
            }
            String var6 = this.fontRenderer.func_238412_a_(this.text.substring(this.field_73816_n), this.getWidth());
            this.setCursorPosition(this.fontRenderer.func_238412_a_(var6, (int)var5).length() + this.field_73816_n);
        }
    }

    public void renderWidget(MatrixStack matrix, int mouseX, int mouseY, float partialTicks) {
        if (this.getVisible()) {
            int var1 = this.isEnabled ? this.enabledColor : this.disabledColor;
            int var2 = this.cursorPosition - this.field_73816_n;
            int var3 = this.selectionEnd - this.field_73816_n;
            String var4 = this.fontRenderer.func_238412_a_(this.text.substring(this.field_73816_n), this.getWidth());
            boolean var5 = var2 >= 0 && var2 <= var4.length();
            boolean var6 = this.isFocused && this.cursorCounter / 6 % 2 == 0 && var5;
            int var7 = this.enableBackgroundDrawing ? this.xPos + 4 : this.xPos;
            int var8 = this.enableBackgroundDrawing ? this.yPos + (this.height - 8) / 2 : this.yPos;
            int var9 = var7;
            if (var3 > var4.length()) {
                var3 = var4.length();
            }
            if (!var4.isEmpty()) {
                String var10 = var5 ? var4.substring(0, var2) : var4;
                var9 = this.fontRenderer.func_238405_a_(matrix, var10, (float)var7, (float)var8, var1);
            }
            boolean var13 = this.cursorPosition < this.text.length() || this.text.length() >= this.getMaxStringLength();
            int var11 = var9;
            if (!var5) {
                var11 = var2 > 0 ? var7 + this.width : var7;
            } else if (var13) {
                var11 = var9 - 1;
                --var9;
            }
            if (!var4.isEmpty() && var5 && var2 < var4.length()) {
                this.fontRenderer.func_238405_a_(matrix, var4.substring(var2), (float)var9, (float)var8, var1);
            }
            if (var6) {
                if (var13) {
                    this.fontRenderer.getClass();
                    AbstractGui.func_238467_a_((MatrixStack)matrix, (int)var11, (int)(var8 - 1), (int)(var11 + 1), (int)(var8 + 1 + 9), (int)-3092272);
                } else {
                    this.fontRenderer.func_238405_a_(matrix, "_", (float)var11, (float)var8, var1);
                }
            }
            if (var3 != var2) {
                int var12 = var7 + this.fontRenderer.func_78256_a(var4.substring(0, var3));
                this.fontRenderer.getClass();
                this.drawCursorVertical(var11, var8 - 1, var12 - 1, var8 + 1 + 9);
            }
        }
    }

    private void drawCursorVertical(int par1, int par2, int par3, int par4) {
        int var5;
        if (par1 < par3) {
            var5 = par1;
            par1 = par3;
            par3 = var5;
        }
        if (par2 < par4) {
            var5 = par2;
            par2 = par4;
            par4 = var5;
        }
        Tessellator tessellator = Tessellator.func_178181_a();
        RenderSystem.disableTexture();
        RenderSystem.enableColorLogicOp();
        RenderSystem.logicOp((GlStateManager.LogicOp)GlStateManager.LogicOp.OR_REVERSE);
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        buffer.func_225582_a_((double)par1, (double)par4, 0.0).func_227885_a_(0.0f, 0.0f, 1.0f, 1.0f).func_181675_d();
        buffer.func_225582_a_((double)par3, (double)par4, 0.0).func_227885_a_(0.0f, 0.0f, 1.0f, 1.0f).func_181675_d();
        buffer.func_225582_a_((double)par3, (double)par2, 0.0).func_227885_a_(0.0f, 0.0f, 1.0f, 1.0f).func_181675_d();
        buffer.func_225582_a_((double)par1, (double)par2, 0.0).func_227885_a_(0.0f, 0.0f, 1.0f, 1.0f).func_181675_d();
        tessellator.func_78381_a();
        RenderSystem.disableColorLogicOp();
        RenderSystem.enableTexture();
    }

    public void setMaxStringLength(int par1) {
        this.maxStringLength = par1;
        if (this.text.length() > par1) {
            this.text = this.text.substring(0, par1);
        }
    }

    public int getMaxStringLength() {
        return this.maxStringLength;
    }

    public int getCursorPosition() {
        return this.cursorPosition;
    }

    public boolean getEnableBackgroundDrawing() {
        return this.enableBackgroundDrawing;
    }

    public void setEnableBackgroundDrawing(boolean par1) {
        this.enableBackgroundDrawing = par1;
    }

    public void setTextColor(int par1) {
        this.enabledColor = par1;
    }

    public void func_82266_h(int par1) {
        this.disabledColor = par1;
    }

    public void setFocused(boolean par1) {
        if (par1 && !this.isFocused) {
            this.cursorCounter = 0;
        }
        this.isFocused = par1;
    }

    public boolean isFocused() {
        return this.isFocused;
    }

    public void func_82265_c(boolean par1) {
        this.isEnabled = par1;
    }

    public int getSelectionEnd() {
        return this.selectionEnd;
    }

    public int getWidth() {
        return this.getEnableBackgroundDrawing() ? this.width - 8 : this.width;
    }

    public void setSelectionPos(int par1) {
        int var2 = this.text.length();
        if (par1 > var2) {
            par1 = var2;
        }
        if (par1 < 0) {
            par1 = 0;
        }
        this.selectionEnd = par1;
        if (this.fontRenderer != null) {
            if (this.field_73816_n > var2) {
                this.field_73816_n = var2;
            }
            int var3 = this.getWidth();
            String var4 = this.fontRenderer.func_238412_a_(this.text.substring(this.field_73816_n), var3);
            int var5 = var4.length() + this.field_73816_n;
            if (par1 == this.field_73816_n) {
                this.field_73816_n -= this.fontRenderer.func_238412_a_(this.text, var3).length();
            }
            if (par1 > var5) {
                this.field_73816_n += par1 - var5;
            } else if (par1 <= this.field_73816_n) {
                this.field_73816_n -= this.field_73816_n - par1;
            }
            if (this.field_73816_n < 0) {
                this.field_73816_n = 0;
            }
            if (this.field_73816_n > var2) {
                this.field_73816_n = var2;
            }
        }
    }

    public void setCanLoseFocus(boolean par1) {
        this.canLoseFocus = par1;
    }

    public boolean getVisible() {
        return this.visible;
    }

    public void setVisible(boolean par1) {
        this.visible = par1;
    }
}

