/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.gui.npcEditor;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.battles.BattleAIMode;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.boss.BossTier;
import com.pixelmonmod.pixelmon.api.pokemon.boss.BossTierRegistry;
import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.client.gui.Resources;
import com.pixelmonmod.pixelmon.client.gui.ScreenHelper;
import com.pixelmonmod.pixelmon.client.gui.npcEditor.BattleRulesNPCEditorScreen;
import com.pixelmonmod.pixelmon.client.gui.npcEditor.TextureEditorNPC;
import com.pixelmonmod.pixelmon.client.gui.npcEditor.TrainerEditorMoreScreen;
import com.pixelmonmod.pixelmon.client.gui.npcEditor.TrainerEditorPartyScreen;
import com.pixelmonmod.pixelmon.client.gui.widgets.DropDown;
import com.pixelmonmod.pixelmon.client.gui.widgets.DropDownScreen;
import com.pixelmonmod.pixelmon.client.gui.widgets.IndexedButton;
import com.pixelmonmod.pixelmon.comm.SetTrainerData;
import com.pixelmonmod.pixelmon.comm.packetHandlers.npc.DeleteTrainerPacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.npc.EnumNPCServerPacketType;
import com.pixelmonmod.pixelmon.comm.packetHandlers.npc.NPCServerPacket;
import com.pixelmonmod.pixelmon.entities.npcs.NPCEntity;
import com.pixelmonmod.pixelmon.entities.npcs.NPCTrainer;
import com.pixelmonmod.pixelmon.entities.npcs.registry.BaseTrainer;
import com.pixelmonmod.pixelmon.enums.EnumEncounterMode;
import com.pixelmonmod.pixelmon.enums.EnumMegaItemsUnlocked;
import com.pixelmonmod.pixelmon.enums.EnumOldGenMode;
import com.pixelmonmod.pixelmon.enums.EnumTrainerAI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class TrainerEditorScreen
extends DropDownScreen {
    public static ArrayList<Pokemon> pokemonList = new ArrayList();
    public static int currentTrainerID;
    public static SetTrainerData trainerData;
    NPCTrainer trainer;
    TextFieldWidget nameBox;
    private TextureEditorNPC textureEditor;
    String oldName = "";
    private static final int BUTTON_ID_RULES = 11;
    private static final int DROP_DOWN_HEIGHT_OFFSET = 23;
    private static final int BACKGROUND_SCREEN_WIDTH = 400;
    private static final int BACKGROUND_SCREEN_HEIGHT = 240;
    private static float leftEdgeBackgroundScreen;
    private static float rightEdgeBackgroundScreen;
    private static float topEdgeBackgroundScreen;
    private static float bottomEdgeBackgroundScreen;
    private static int xCenterBackgroundScreen;
    private static int yCenterBackgroundScreen;
    private static final int LONGEST_BUTTON = 100;
    private static final int LONG_BUTTON = 80;
    private static final int SHORT_BUTTON = 30;
    private static final int BUTTON_HEIGHT = 20;
    private static final int PADDING_5 = 5;
    private static final int PADDING_10 = 10;
    BaseTrainer model;

    public TrainerEditorScreen(int trainerId) {
        super(StringTextComponent.field_240750_d_);
        this.field_230706_i_.field_195559_v.func_197967_a(true);
        Optional<NPCTrainer> entityNPCOptional = NPCEntity.locateNPCClient((World)Minecraft.func_71410_x().field_71441_e, trainerId, NPCTrainer.class);
        if (!entityNPCOptional.isPresent()) {
            ScreenHelper.closeScreen();
            return;
        }
        this.trainer = entityNPCOptional.get();
        currentTrainerID = trainerId;
    }

    @Override
    public void func_231160_c_() {
        super.func_231160_c_();
        if (this.trainer == null) {
            ScreenHelper.closeScreen();
            return;
        }
        leftEdgeBackgroundScreen = (float)this.field_230708_k_ / 2.0f - 200.0f;
        rightEdgeBackgroundScreen = (float)this.field_230708_k_ / 2.0f + 200.0f;
        topEdgeBackgroundScreen = (float)this.field_230709_l_ / 2.0f - 120.0f;
        bottomEdgeBackgroundScreen = (float)this.field_230709_l_ / 2.0f + 120.0f;
        xCenterBackgroundScreen = this.field_230708_k_ / 2;
        yCenterBackgroundScreen = this.field_230709_l_ / 2;
        this.func_230480_a_((Widget)new IndexedButton(1, (int)(rightEdgeBackgroundScreen - 40.0f), (int)(bottomEdgeBackgroundScreen - 30.0f), 30, 20, (ITextComponent)new TranslationTextComponent("gui.guiItemDrops.ok"), this::actionPerformed));
        this.textureEditor = new TextureEditorNPC(this, this.trainer, (int)leftEdgeBackgroundScreen + 10 + 100 + 10 + 30 + 5, (int)(topEdgeBackgroundScreen + 10.0f), 130);
        this.func_230480_a_((Widget)new IndexedButton(3, xCenterBackgroundScreen - 78, (int)(bottomEdgeBackgroundScreen - 30.0f), 100, 20, (ITextComponent)new TranslationTextComponent("gui.trainereditor.edit"), this::actionPerformed));
        int dropDownLeft = xCenterBackgroundScreen + 35;
        int dropDownHeightStart = yCenterBackgroundScreen - 33;
        int dropDownWidth = 100;
        int dropDownHeight = 100;
        this.addDropDown(new DropDown<BossTier>(BossTierRegistry.getBossTiers(), this.trainer.getBossTier(), dropDownLeft, dropDownHeightStart, dropDownWidth, dropDownHeight).setGetOptionString(bossTier -> {
            String name = bossTier.getName();
            return I18n.func_188566_a((String)name) ? I18n.func_135052_a((String)name, (Object[])new Object[0]) : name;
        }).setOnSelected(this::selectBossMode));
        this.addDropDown(new DropDown<EnumTrainerAI>(Arrays.asList(EnumTrainerAI.values()), this.trainer.getAIMode(), dropDownLeft, dropDownHeightStart + 22, dropDownWidth, dropDownHeight).setGetOptionString(EnumTrainerAI::getLocalizedName).setOnSelected(aiMode -> this.trainer.setAIMode((EnumTrainerAI)((Object)aiMode))));
        int battleAITop = dropDownHeightStart + 44;
        this.addDropDown(new DropDown<BattleAIMode>(Arrays.asList(BattleAIMode.values()), this.trainer.getBattleAIMode(), dropDownLeft, battleAITop, dropDownWidth, dropDownHeight).setGetOptionString(BattleAIMode::getLocalizedName).setOnSelected(this::selectBattleAIMode).setInactiveTop(battleAITop));
        int encounterModeTop = dropDownHeightStart + 66;
        this.addDropDown(new DropDown<EnumEncounterMode>(Arrays.asList(EnumEncounterMode.values()), this.trainer.getEncounterMode(), dropDownLeft, encounterModeTop, dropDownWidth, dropDownHeight).setGetOptionString(EnumEncounterMode::getLocalizedName).setOnSelected(this::selectEncounterMode).setInactiveTop(encounterModeTop));
        int oldGenModeTop = dropDownHeightStart + 88;
        this.addDropDown(new DropDown<EnumOldGenMode>(Arrays.asList(EnumOldGenMode.values()), this.trainer.getOldGen(), dropDownLeft, oldGenModeTop, dropDownWidth, dropDownHeight).setGetOptionString(EnumOldGenMode::getLocalizedName).setOnSelected(this::selectOldGenMode).setInactiveTop(oldGenModeTop));
        int megaItemModeTop = dropDownHeightStart + 110;
        this.addDropDown(new DropDown<EnumMegaItemsUnlocked>(Arrays.asList(EnumMegaItemsUnlocked.values()), this.trainer.getMegaItem(), dropDownLeft, megaItemModeTop, dropDownWidth, dropDownHeight).setGetOptionString(EnumMegaItemsUnlocked::getLocalizedName).setOnSelected(this::selectMegaItemMode).setInactiveTop(megaItemModeTop));
        int engageDistanceTop = dropDownHeightStart + 132;
        this.addDropDown(new DropDown<int>((List<int>)IntStream.range(1, 21).boxed().collect(Collectors.toList()), this.trainer.getEngageDistance() - 1, dropDownLeft, engageDistanceTop, dropDownWidth, dropDownHeight).setGetOptionString(Object::toString).setOnSelected(this::selectEngageDistance).setInactiveTop(engageDistanceTop));
        this.func_230480_a_((Widget)new IndexedButton(11, xCenterBackgroundScreen - 78, yCenterBackgroundScreen - 20, 100, 20, (ITextComponent)new TranslationTextComponent("gui.battlerules.title"), this::actionPerformed));
        this.func_230480_a_((Widget)new IndexedButton(7, (int)(leftEdgeBackgroundScreen + 10.0f), (int)(bottomEdgeBackgroundScreen - 30.0f), 100, 20, (ITextComponent)new TranslationTextComponent("gui.trainereditor.more"), this::actionPerformed));
        this.func_230480_a_((Widget)new IndexedButton(8, (int)(rightEdgeBackgroundScreen - 90.0f), (int)(topEdgeBackgroundScreen + 10.0f), 80, 20, (ITextComponent)new TranslationTextComponent("gui.trainereditor.delete"), this::actionPerformed));
        this.nameBox = new TextFieldWidget(this.field_230706_i_.field_71466_p, (int)(leftEdgeBackgroundScreen + 10.0f), (int)(topEdgeBackgroundScreen + 10.0f), 100, 20, StringTextComponent.field_240750_d_);
        this.field_230705_e_.add(this.nameBox);
        if (trainerData != null) {
            this.nameBox.func_146180_a(TrainerEditorScreen.trainerData.name);
            this.oldName = TrainerEditorScreen.trainerData.name;
        }
    }

    private void selectBossMode(BossTier bossTier) {
        this.trainer.setBossTier(bossTier);
        NetworkHelper.sendToServer(new NPCServerPacket(currentTrainerID, bossTier));
    }

    private void selectBattleAIMode(BattleAIMode battleAI) {
        this.trainer.setBattleAIMode(battleAI);
        NetworkHelper.sendToServer(new NPCServerPacket(currentTrainerID, battleAI));
    }

    private void selectEncounterMode(EnumEncounterMode encounterMode) {
        this.trainer.setEncounterMode(encounterMode);
        NetworkHelper.sendToServer(new NPCServerPacket(currentTrainerID, encounterMode));
    }

    private void selectOldGenMode(EnumOldGenMode oldGenMode) {
        this.trainer.setOldGenMode(oldGenMode);
        NetworkHelper.sendToServer(new NPCServerPacket(currentTrainerID, oldGenMode));
    }

    private void selectMegaItemMode(EnumMegaItemsUnlocked megaItem) {
        this.trainer.setMegaItem(megaItem);
        NetworkHelper.sendToServer(new NPCServerPacket(currentTrainerID, megaItem));
    }

    private void selectEngageDistance(int distance) {
        this.trainer.setEngageDistance(distance);
        Pixelmon.network.sendToServer(new NPCServerPacket(currentTrainerID, distance, EnumNPCServerPacketType.EngageDistance));
    }

    @Override
    protected void drawBackgroundUnderMenus(MatrixStack matrix, float partialTicks, int mouseX, int mouseY) {
        if (this.trainer == null) {
            ScreenHelper.closeScreen();
            return;
        }
        if (trainerData != null && !TrainerEditorScreen.trainerData.name.equals(this.oldName)) {
            this.oldName = TrainerEditorScreen.trainerData.name;
            this.nameBox.func_146180_a(TrainerEditorScreen.trainerData.name);
        }
        ScreenHelper.drawImageQuad(Resources.cwPanel, matrix, leftEdgeBackgroundScreen, topEdgeBackgroundScreen, 400.0f, 240.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.75f, 0.0f);
        RenderHelper.func_74518_a();
        ScreenHelper.drawEntity(matrix, (LivingEntity)this.trainer, xCenterBackgroundScreen - 140, yCenterBackgroundScreen + 60, 60.0f, 0.0f, 0.0f);
        int dropDownLabelX = xCenterBackgroundScreen + 88;
        int dropDownHeightStart = yCenterBackgroundScreen - 42;
        ScreenHelper.drawCenteredString(matrix, I18n.func_135052_a((String)"gui.trainereditor.bosstype", (Object[])new Object[0]), (float)dropDownLabelX, (float)dropDownHeightStart, 0);
        ScreenHelper.drawCenteredString(matrix, I18n.func_135052_a((String)"gui.trainereditor.aimode", (Object[])new Object[0]), (float)dropDownLabelX, (float)(dropDownHeightStart + 22), 0);
        ScreenHelper.drawCenteredString(matrix, I18n.func_135052_a((String)"gui.trainereditor.battleaimode", (Object[])new Object[0]), (float)dropDownLabelX, (float)(dropDownHeightStart + 44), 0);
        ScreenHelper.drawCenteredString(matrix, I18n.func_135052_a((String)"gui.trainereditor.encountermode", (Object[])new Object[0]), (float)dropDownLabelX, (float)(dropDownHeightStart + 66), 0);
        ScreenHelper.drawCenteredString(matrix, I18n.func_135052_a((String)"gui.trainereditor.oldgen", (Object[])new Object[0]), (float)dropDownLabelX, (float)(dropDownHeightStart + 88), 0);
        ScreenHelper.drawCenteredString(matrix, I18n.func_135052_a((String)"gui.trainereditor.megaitem", (Object[])new Object[0]), (float)dropDownLabelX, (float)(dropDownHeightStart + 110), 0);
        ScreenHelper.drawCenteredString(matrix, I18n.func_135052_a((String)"gui.trainereditor.engagedistance", (Object[])new Object[0]), (float)dropDownLabelX, (float)(dropDownHeightStart + 132), 0);
        this.field_230706_i_.field_71466_p.func_238421_b_(matrix, I18n.func_135052_a((String)"gui.trainereditor", (Object[])new Object[0]), leftEdgeBackgroundScreen + 10.0f + 100.0f + 10.0f, topEdgeBackgroundScreen + 10.0f + 3.0f, 0);
        this.field_230706_i_.field_71466_p.func_238421_b_(matrix, I18n.func_135052_a((String)"gui.trainereditor.model", (Object[])new Object[0]), leftEdgeBackgroundScreen + 10.0f + 100.0f + 10.0f, topEdgeBackgroundScreen + 10.0f + 10.0f + 8.0f, 0);
        this.textureEditor.drawCustomTextBox(matrix, mouseX, mouseY, partialTicks);
        this.drawPokemonList(matrix);
    }

    private void drawPokemonList(MatrixStack matrix) {
        int ySize = 68;
        int yPartyPokemonTitlePadding = 11;
        int xSize = 104;
        int xPartyPokemonTitlePadding = 1;
        int topSideOfPartyPokemon = (int)(bottomEdgeBackgroundScreen - (float)(35 + ySize));
        int leftSideOfPartyPokemon = xCenterBackgroundScreen - 80;
        TrainerEditorScreen.func_238467_a_((MatrixStack)matrix, (int)(leftSideOfPartyPokemon - 1), (int)(topSideOfPartyPokemon - 1), (int)(leftSideOfPartyPokemon + xSize), (int)(topSideOfPartyPokemon + ySize), (int)-16777215);
        TrainerEditorScreen.func_238467_a_((MatrixStack)matrix, (int)leftSideOfPartyPokemon, (int)topSideOfPartyPokemon, (int)(leftSideOfPartyPokemon + xSize), (int)(topSideOfPartyPokemon + ySize), (int)-6777215);
        this.field_230706_i_.field_71466_p.func_238421_b_(matrix, I18n.func_135052_a((String)"gui.trainereditor.partypokemon", (Object[])new Object[0]), (float)(leftSideOfPartyPokemon + xPartyPokemonTitlePadding), (float)(topSideOfPartyPokemon - yPartyPokemonTitlePadding), 0);
        for (int n = 0; n < pokemonList.size(); ++n) {
            Pokemon pokemon = pokemonList.get(n);
            if (pokemon == null) continue;
            this.field_230706_i_.field_71466_p.func_238421_b_(matrix, pokemon.getDisplayName(), (float)(leftSideOfPartyPokemon + 4), (float)(topSideOfPartyPokemon + 4 + n * 10), 0);
            this.field_230706_i_.field_71466_p.func_238421_b_(matrix, I18n.func_135052_a((String)"gui.trainereditor.lvl", (Object[])new Object[0]) + " " + pokemon.getPokemonLevel(), (float)(leftSideOfPartyPokemon + 65), (float)(topSideOfPartyPokemon + 4 + n * 10), 0);
        }
    }

    public boolean func_231046_a_(int key, int keyCode, int modifiers) {
        if (keyCode == 256 || keyCode == 257) {
            this.saveFields();
            return true;
        }
        super.func_231046_a_(key, keyCode, modifiers);
        if (this.textureEditor.customTextureBox.func_231046_a_(key, keyCode, 0)) {
            this.textureEditor.saveCustomTexture();
            return true;
        }
        return false;
    }

    public boolean func_231042_a_(char key, int keyCode) {
        this.textureEditor.keyTyped(key, keyCode, this.nameBox);
        if (keyCode == 256 || keyCode == 257) {
            this.saveFields();
        }
        return super.func_231042_a_(key, keyCode);
    }

    @Override
    public boolean mouseClickedUnderMenus(double x, double y, int mouseButton) {
        if (this.nameBox == null) {
            this.func_231160_c_();
        }
        this.textureEditor.mouseClicked(x, y, mouseButton);
        return super.mouseClickedUnderMenus(x, y, mouseButton);
    }

    protected void actionPerformed(Button button) {
        if (button.field_230693_o_ && button instanceof IndexedButton) {
            int id = ((IndexedButton)button).id;
            if (id == 1) {
                this.saveFields();
            } else if (id == 3) {
                this.field_230706_i_.func_147108_a((Screen)new TrainerEditorPartyScreen());
            } else if (id == 7) {
                this.field_230706_i_.func_147108_a((Screen)new TrainerEditorMoreScreen());
            } else if (id == 8) {
                NetworkHelper.sendToServer(new DeleteTrainerPacket(currentTrainerID));
                ScreenHelper.closeScreen();
            } else if (id == 11) {
                this.field_230706_i_.func_147108_a((Screen)new BattleRulesNPCEditorScreen());
            }
        }
    }

    @Override
    public boolean func_231177_au__() {
        return false;
    }

    private void saveFields() {
        if (this.checkFields()) {
            ScreenHelper.closeScreen();
        }
    }

    private boolean checkFields() {
        if (this.nameBox.func_146179_b().equals("") || trainerData == null) {
            return false;
        }
        if (currentTrainerID <= 0) {
            currentTrainerID = this.trainer.getNPCID();
        }
        if (!this.nameBox.func_146179_b().equals(TrainerEditorScreen.trainerData.name)) {
            NetworkHelper.sendToServer(new NPCServerPacket(currentTrainerID, EnumNPCServerPacketType.Name, this.nameBox.func_146179_b()));
        }
        NetworkHelper.sendToServer(new NPCServerPacket(currentTrainerID, this.trainer.getAIMode()));
        this.textureEditor.saveCustomTexture();
        return true;
    }

    static {
        leftEdgeBackgroundScreen = 0.0f;
        rightEdgeBackgroundScreen = 200.0f;
        topEdgeBackgroundScreen = 140.0f;
        bottomEdgeBackgroundScreen = 0.0f;
        xCenterBackgroundScreen = 70;
        yCenterBackgroundScreen = 70;
    }
}

