/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.gui.inventory.tabs.impl;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.pixelmonmod.pixelmon.api.pokemon.PokemonBase;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.storage.breeding.DayCareBox;
import com.pixelmonmod.pixelmon.api.storage.breeding.PlayerDayCare;
import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.ResourceLocationHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.StringHelper;
import com.pixelmonmod.pixelmon.client.gui.Resources;
import com.pixelmonmod.pixelmon.client.gui.ScreenHelper;
import com.pixelmonmod.pixelmon.client.gui.daycare.DayCareScreen;
import com.pixelmonmod.pixelmon.client.gui.daycare.DayCareSlot;
import com.pixelmonmod.pixelmon.client.gui.inventory.tabs.impl.SimpleSurvivalTab;
import com.pixelmonmod.pixelmon.client.gui.widgets.InvisibleButtonWithTooltip;
import com.pixelmonmod.pixelmon.client.storage.ClientStorageManager;
import com.pixelmonmod.pixelmon.comm.packetHandlers.daycare.DayCareRequestAllErrorsPacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.daycare.DayCareRequestConditionUpdatePacket;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.container.CraftingResultSlot;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.RecipeBookCategory;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class DayCareTab
extends SimpleSurvivalTab {
    private static final ResourceLocation GUI_LOCATION = ResourceLocationHelper.of("pixelmon", "textures/gui/daycare/inventory.png");
    private int startSlot = 0;
    private DayCareBox box;

    public DayCareTab(int id, int column, boolean topRow, boolean alignedRight, ItemStack iconItem) {
        super(id, column, topRow, alignedRight, iconItem);
    }

    @Override
    public void init() {
        int boxId;
        PlayerPartyStorage party = ClientStorageManager.party;
        this.minecraft.field_71439_g.func_199507_B().func_242139_a().func_242152_a(RecipeBookCategory.CRAFTING, false);
        this.selectBox(0);
        this.addButton(new InvisibleButtonWithTooltip(this.getGuiLeft() + this.imageWidth - 16 - 16 - 10, this.getGuiTop(), 16, 14, StringTextComponent.field_240750_d_, button -> this.swapPage(false), (a, matrix, mouseX, mouseY) -> this.minecraft.field_71462_r.func_238652_a_(matrix, (ITextComponent)new TranslationTextComponent("pixelmon.daycare.previous.page"), mouseX, mouseY)));
        this.addButton(new InvisibleButtonWithTooltip(this.getGuiLeft() + this.imageWidth - 16 - 10, this.getGuiTop(), 16, 14, StringTextComponent.field_240750_d_, button -> this.swapPage(true), (a, matrix, mouseX, mouseY) -> this.minecraft.field_71462_r.func_238652_a_(matrix, (ITextComponent)new TranslationTextComponent("pixelmon.daycare.next.page"), mouseX, mouseY)));
        int i = (this.minecraft.field_71462_r.field_230708_k_ - 176) / 2;
        int j = (this.minecraft.field_71462_r.field_230709_l_ - 166) / 2;
        int j1 = i + 60;
        PlayerDayCare dayCare = ClientStorageManager.party.getDayCare();
        for (int k = 0; k < 3 && (boxId = this.startSlot + k) < party.getDayCare().getAllowedBoxes(); ++k) {
            int finalK = k;
            this.addButton(new InvisibleButtonWithTooltip(j1, j + 14 + 19 * k, 108, 19, StringTextComponent.field_240750_d_, button -> this.selectBox(this.startSlot + finalK), (a, matrix, mouseX, mouseY) -> {
                Optional<DayCareBox> box = dayCare.getOrCreateBox(boxId);
                box.ifPresent(dayCareBox -> {
                    if (dayCareBox.canBreedingBegin() || dayCareBox.isEmpty()) {
                        this.minecraft.field_71462_r.renderWrappedToolTip(matrix, (List)Lists.newArrayList((Object[])new TranslationTextComponent[]{new TranslationTextComponent("pixelmon.daycare.box." + boxId)}), mouseX, mouseY, this.minecraft.field_71466_p);
                        return;
                    }
                    if (dayCareBox.getAllErrorMessages() == null) {
                        NetworkHelper.sendToServer(new DayCareRequestAllErrorsPacket(dayCareBox.getBoxId()));
                        this.minecraft.field_71462_r.renderWrappedToolTip(matrix, (List)Lists.newArrayList((Object[])new TranslationTextComponent[]{new TranslationTextComponent("pixelmon.daycare.box." + boxId)}), mouseX, mouseY, this.minecraft.field_71466_p);
                        return;
                    }
                    ArrayList allErrorMessages = Lists.newArrayList((Object[])new ITextComponent[]{new TranslationTextComponent("pixelmon.daycare.box." + boxId), new TranslationTextComponent("pixelmon.daycare.requirements")});
                    allErrorMessages.addAll(dayCareBox.getAllErrorMessages());
                    this.minecraft.field_71462_r.renderWrappedToolTip(matrix, (List)allErrorMessages, mouseX, mouseY, this.minecraft.field_71466_p);
                });
            }));
        }
    }

    private void selectBox(int boxId) {
        PlayerPartyStorage party = ClientStorageManager.party;
        DayCareBox dayCareBox = party.getDayCare().getOrCreateBox(boxId).orElse(null);
        if (dayCareBox == null || dayCareBox.isEmpty()) {
            this.box = party.getDayCare().getFirstEmptyBox();
        } else {
            this.box = dayCareBox;
            if (!dayCareBox.canBreedingBegin()) {
                NetworkHelper.sendToServer(new DayCareRequestConditionUpdatePacket(dayCareBox.getBoxId()));
            }
        }
    }

    private void renderToolTip(MatrixStack matrix, double mouseX, double mouseY, ITextComponent textComponent) {
        matrix.func_227860_a_();
        matrix.func_227861_a_(1.0, 1.0, 10.0);
        ScreenHelper.drawInUnicode(() -> {
            FontRenderer fontRenderer = this.minecraft.field_71466_p;
            float f = (float)mouseX - (float)this.minecraft.field_71466_p.func_238414_a_((ITextProperties)textComponent) / 2.0f;
            float f2 = (float)mouseY;
            this.minecraft.field_71466_p.getClass();
            fontRenderer.func_243248_b(matrix, textComponent, f, f2 - 9.0f, 1);
        });
        matrix.func_227865_b_();
    }

    @Override
    public void render(MatrixStack matrix, int mouseX, int mouseY, float partialTicks) {
        Minecraft minecraft = Minecraft.func_71410_x();
        PlayerPartyStorage party = ClientStorageManager.party;
        ContainerScreen containerScreen = (ContainerScreen)minecraft.field_71462_r;
        if (this.startSlot > 0) {
            ScreenHelper.drawImageQuad(Resources.UP, matrix, containerScreen.getGuiLeft() + 176 - 16 - 16 - 10, containerScreen.getGuiTop(), 16.0f, 16.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 0.91764706f, 0.23137255f, 1.0f, 1.0f);
        }
        if (this.startSlot < party.getDayCare().getAllowedBoxes() - 3) {
            ScreenHelper.drawImageQuad(Resources.DOWN, matrix, containerScreen.getGuiLeft() + 176 - 16 - 10, containerScreen.getGuiTop(), 16.0f, 16.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 0.91764706f, 0.23137255f, 1.0f, 1.0f);
        }
        List<PokemonBase> history = party.getDayCare().getHistory();
        List slots = containerScreen.func_212873_a_().field_75151_b;
        int pos = 0;
        for (int i = 0; i < slots.size(); ++i) {
            Slot slot = (Slot)slots.get(i);
            if (slot instanceof CraftingResultSlot || slot.field_75224_c instanceof CraftingInventory || slot.func_75219_a() == 1) continue;
            if (pos >= history.size()) break;
            ScreenHelper.drawImage(history.get(pos).getSprite(), matrix, (float)(this.getGuiLeft() + slot.field_75223_e), (float)(this.getGuiTop() + slot.field_75221_f), 16.0f, 16.0f, 1.0f);
            ++pos;
        }
        ScreenHelper.drawInUnicode(() -> {
            minecraft.func_110434_K().func_110577_a(GUI_LOCATION);
            int i = (minecraft.field_71462_r.field_230708_k_ - 176) / 2;
            int j = (minecraft.field_71462_r.field_230709_l_ - 166) / 2;
            minecraft.field_71462_r.func_238474_b_(matrix, i, j, 0, 0, 176, 166);
            int j1 = i + 60;
            for (int k = 0; k < 3; ++k) {
                int boxId = this.startSlot + k;
                if (boxId >= party.getDayCare().getAllowedBoxes()) {
                    minecraft.func_110434_K().func_110577_a(GUI_LOCATION);
                    minecraft.field_71462_r.func_238474_b_(matrix, j1 - 1, j + 14 + 19 * k, 0, 186, 108, 19);
                    continue;
                }
                DayCareBox box = party.getDayCare().getOrCreateBox(boxId).orElse(null);
                if (box == null) continue;
                if (!box.canBreedingBegin() && !box.isEmpty()) {
                    if (box.getErrorMessage() == null) {
                        NetworkHelper.sendToServer(new DayCareRequestConditionUpdatePacket(box.getBoxId()));
                        continue;
                    }
                    minecraft.func_110434_K().func_110577_a(GUI_LOCATION);
                    minecraft.field_71462_r.func_238474_b_(matrix, j1 - 1, j + 14 + 19 * k, 109, 205, 109, 19);
                    minecraft.field_71466_p.func_243248_b(matrix, box.getErrorMessage(), (float)(j1 + 20), (float)(j + 19 + 19 * k), 1);
                } else if (!box.isEmpty() && box.hasBreedingBegun()) {
                    if (box.getPercentComplete() < 100.0) {
                        minecraft.func_110434_K().func_110577_a(GUI_LOCATION);
                        minecraft.field_71462_r.func_238474_b_(matrix, j1 - 1, j + 14 + 19 * k, 0, 205, 109, 19);
                        this.minecraft.func_110434_K().func_110577_a(GUI_LOCATION);
                        this.minecraft.field_71462_r.func_238474_b_(matrix, j1 - 1 + 23, j + 19 + 19 * k, 19, 226, 81, 5);
                        this.minecraft.field_71462_r.func_238474_b_(matrix, j1 - 1 + 23, j + 19 + 19 * k, 19, 231, (int)(box.getPercentComplete() / 100.0 * 81.0), 5);
                        ITextComponent totalDuration = StringHelper.getFormattedDuration(box.getTotalDuration());
                        FontRenderer fontRenderer = this.minecraft.field_71466_p;
                        float f = j1 + 18 + 50 - this.minecraft.field_71466_p.func_238414_a_((ITextProperties)totalDuration);
                        this.minecraft.field_71466_p.getClass();
                        fontRenderer.func_243248_b(matrix, totalDuration, f, (float)(j + 33 + 19 * k - 9), 1);
                    } else {
                        minecraft.func_110434_K().func_110577_a(GUI_LOCATION);
                        minecraft.field_71462_r.func_238474_b_(matrix, j1 - 1, j + 14 + 19 * k, 109, 186, 109, 19);
                        TranslationTextComponent complete = new TranslationTextComponent("pixelmon.daycare.complete");
                        minecraft.field_71466_p.func_243248_b(matrix, (ITextComponent)complete, (float)(j1 + 18 + 45 - minecraft.field_71466_p.func_238414_a_((ITextProperties)complete) / 2), (float)(j + 18 + 19 * k), 1);
                    }
                }
                if (box.isEmpty()) continue;
                ScreenHelper.drawImageQuad(box.getEgg().getSprite(), matrix, j1, j + 13 + 19 * k, 16.0f, 16.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f);
            }
            if (this.box != null && !this.box.isEmpty()) {
                ScreenHelper.drawImageQuad(this.box.getEgg().getSprite(), matrix, this.getGuiLeft() + 16, (float)this.getGuiTop() + 12.5f, 32.0f, 32.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f);
            }
            if (this.box != null && !this.box.isEmpty()) {
                int id = 1;
                for (DayCareSlot slotData : DayCareScreen.SLOTS) {
                    ScreenHelper.drawImageQuad(this.box.getParent(id).getSprite(), matrix, (float)this.getGuiLeft() + (float)slotData.getStartX(), (float)this.getGuiTop() + (float)slotData.getStartY(), (float)slotData.getWidth(), (float)slotData.getHeight(), 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f);
                    if (slotData.inSlot(mouseX - this.getGuiLeft(), mouseY - this.getGuiTop())) {
                        ScreenHelper.drawPokemonHoverInfo(matrix, this.box.getParent(id), mouseX, mouseY);
                    }
                    ++id;
                }
            }
            this.minecraft.field_71466_p.func_243248_b(matrix, (ITextComponent)new TranslationTextComponent("pixelmon.daycare.title"), (float)(containerScreen.getGuiLeft() + 5), (float)(containerScreen.getGuiTop() + 3), 1);
            this.minecraft.field_71466_p.func_243248_b(matrix, (ITextComponent)new TranslationTextComponent("pixelmon.daycare.tab.history"), (float)(containerScreen.getGuiLeft() + 5), (float)(containerScreen.getGuiTop() + 72), 1);
        });
        for (Widget button : this.buttons) {
            if (!button.func_231047_b_((double)mouseX, (double)mouseY)) continue;
            button.func_230443_a_(matrix, mouseX, mouseY);
        }
    }

    @Override
    public boolean mouseClicked(double x, double y, int mouseButton) {
        PlayerPartyStorage party = ClientStorageManager.party;
        for (Widget button : this.buttons) {
            if (!button.func_231044_a_(x, y, mouseButton)) continue;
            return true;
        }
        return true;
    }

    private void swapPage(boolean forward) {
        if (this.startSlot == 0 && !forward) {
            return;
        }
        if (this.startSlot == ClientStorageManager.party.getDayCare().getAllowedBoxes() - 3 && forward) {
            return;
        }
        this.startSlot += forward ? 1 : -1;
        this.buttons.clear();
        this.init();
    }
}

