/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.gui.fishingLog;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.pixelmonmod.api.pokemon.PokemonSpecification;
import com.pixelmonmod.pixelmon.api.config.FormLogRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.PokemonFactory;
import com.pixelmonmod.pixelmon.api.pokemon.species.Species;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.client.gui.Resources;
import com.pixelmonmod.pixelmon.client.gui.ScreenHelper;
import com.pixelmonmod.pixelmon.client.gui.fishingLog.FishingLogInformationScreen;
import com.pixelmonmod.pixelmon.client.gui.widgets.IndexedButton;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import org.lwjgl.opengl.GL11;

public class FishingLogScreen
extends Screen {
    private int centerX;
    private int centerY;
    private float guiHeight;
    private float guiWidth;
    private Species species;
    private int[] encountered;
    private LinkedHashMultimap<Integer, PokemonSpecification> categories = LinkedHashMultimap.create();
    private BiMap<PokemonSpecification, IndexedButton> buttons = HashBiMap.create();
    private int currentScroll = 0;
    private int waitingScroll = 0;
    private int viewedForm = -1;
    private double percentComplete = 0.0;
    int maxScroll;

    public FishingLogScreen(int species, int ... data) {
        super(StringTextComponent.field_240750_d_);
        this.species = PixelmonSpecies.fromDex(species).orElse(PixelmonSpecies.MISSINGNO.getValueUnsafe());
        this.encountered = data;
        this.setCategories();
        for (int i : this.encountered) {
            if (i <= 0) continue;
            this.percentComplete += 1.0;
        }
        this.percentComplete /= (double)data.length;
        this.maxScroll = 240;
        int addScroll = 0;
        for (Integer category : this.categories.keySet()) {
            addScroll += 32;
            for (int i = 0; i < this.categories.get((Object)category).size(); ++i) {
                if (i % 3 != 0 && i != this.categories.get((Object)category).size()) continue;
                addScroll += 65;
            }
        }
        if (addScroll > 220) {
            this.maxScroll += addScroll - 190;
        }
    }

    public void setCategories() {
        LinkedHashMultimap<Integer, PokemonSpecification> c = FormLogRegistry.getFormsForSpecies(this.species);
        for (Integer integer : c.keySet()) {
            ArrayList specs = Lists.newArrayList();
            for (PokemonSpecification spec : c.get((Object)integer)) {
                int id = FormLogRegistry.getFormId(this.species, spec);
                if (this.encountered[id] <= 0) continue;
                specs.add(spec);
            }
            this.categories.putAll((Object)integer, (Iterable)specs);
        }
    }

    public void func_231160_c_() {
        super.func_231160_c_();
        this.centerX = this.field_230708_k_ / 2;
        this.centerY = this.field_230709_l_ / 2;
        this.guiHeight = 220.0f;
        this.guiWidth = this.guiHeight * 0.698571f;
        for (PokemonSpecification spec : this.categories.values()) {
            this.buttons.put((Object)spec, (Object)this.func_230480_a_((Widget)new IndexedButton(FormLogRegistry.getFormId(this.species, spec), 0, 0, 40, 46, (ITextComponent)new StringTextComponent(spec.toString()), this::actionPerformed)));
        }
    }

    public void func_230430_a_(MatrixStack matrix, int mouseX, int mouseY, float partialTicks) {
        ScreenHelper.getFontRenderer("pixelmon:textures/gui/pokemonfont.png", true);
        this.func_230446_a_(matrix);
        this.processScroll();
        Minecraft mc = Minecraft.func_71410_x();
        matrix.func_227860_a_();
        float sf = (float)mc.func_228018_at_().func_198100_s();
        float x1 = ((float)this.centerX - this.guiWidth / 2.0f) * sf;
        float x2 = ((float)this.centerX + this.guiWidth / 2.0f) * sf;
        float y1 = ((float)this.centerY - this.guiHeight / 2.0f + 5.0f) * sf;
        float y2 = ((float)this.centerY + this.guiHeight / 2.0f - 5.0f) * sf;
        GL11.glScissor((int)((int)x1), (int)((int)((float)mc.func_228018_at_().func_198083_n() - y2)), (int)((int)(x2 - x1)), (int)((int)(y2 - y1)));
        GL11.glEnable((int)3089);
        this.drawScreenForeground(matrix, mouseX, mouseY);
        GL11.glDisable((int)3089);
        matrix.func_227865_b_();
        int height = 15;
        float width = (float)height * 6.168067f;
        ScreenHelper.drawImageQuad(Resources.fishingLogTitle, matrix, (float)this.centerX - width / 2.0f, this.centerY - 117, width, height, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f);
        ScreenHelper.drawScaledCenteredString(matrix, I18n.func_135052_a((String)"gui.fishinglog.title", (Object[])new Object[]{this.percentComplete > 0.0 ? this.species.getLocalizedName() : "???"}), this.centerX, (float)this.centerY - 112.5f, -7781367, 14.0f);
    }

    public void func_230446_a_(MatrixStack matrix) {
        ScreenHelper.drawImageQuad(this.viewedForm == -1 ? Resources.fishingLogBackground : Resources.fishingLogInformationBackground, matrix, (float)this.centerX - this.guiWidth / 2.0f, (float)this.centerY - this.guiHeight / 2.0f, this.guiWidth, this.guiHeight, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    public void drawScreenForeground(MatrixStack matrix, int mouseX, int mouseY) {
        Minecraft mc = Minecraft.func_71410_x();
        float x = (float)this.centerX - this.guiWidth / 2.0f + 14.5f;
        AtomicInteger top = new AtomicInteger((int)((float)(-this.currentScroll + this.centerY) - this.guiHeight / 2.0f - 5.0f));
        DecimalFormat format = new DecimalFormat("###.#");
        ScreenHelper.drawScaledString(matrix, I18n.func_135052_a((String)"gui.fishinglog.percentage", (Object[])new Object[]{format.format(100.0 * this.percentComplete)}), x + 5.0f, top.addAndGet(21), -7781367, 10.0f);
        AbstractGui.func_238467_a_((MatrixStack)matrix, (int)((int)x), (int)top.get(), (int)((int)x + 2), (int)top.addAndGet(8), (int)-1276390);
        for (Integer category : this.categories.keySet()) {
            ScreenHelper.drawImageQuad(Resources.fishingLogCategory, matrix, x, top.addAndGet(14), 127.0f, 14.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f);
            ScreenHelper.drawScaledString(matrix, I18n.func_135052_a((String)("gui.fishinglog." + this.species.getName().toLowerCase(Locale.ROOT) + ".category" + category + ""), (Object[])new Object[0]), x + 4.0f, top.addAndGet(4), -7781367, 10.0f);
            top.addAndGet(14);
            int i = 0;
            for (PokemonSpecification form : this.categories.get((Object)category)) {
                IndexedButton button = (IndexedButton)((Object)this.buttons.get((Object)form));
                float height = 45.6f;
                float xPos = x + 43.5f * (float)(i % 3);
                ScreenHelper.drawImageQuad(Resources.fishingLogContainer, matrix, xPos, top.get(), 40.0f, height, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f);
                button.field_230690_l_ = (int)xPos;
                button.field_230691_m_ = top.get();
                Pokemon pokemon = PokemonFactory.create(this.species);
                form.apply(pokemon);
                ScreenHelper.drawImageQuad(pokemon.getPalette().getSprite(), matrix, xPos, top.get() - 1, 39.0f, 39.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f);
                int id = button.id + 1;
                ScreenHelper.drawScaledString(matrix, "No. " + id, xPos + (id < 10 ? 3.0f : 1.6f), top.get() + 2, -1, 8.0f);
                String paletteLogName = "";
                if (pokemon.getPalette().is("none")) {
                    paletteLogName = I18n.func_135052_a((String)"pixelmon.generic.form.base", (Object[])new Object[0]);
                } else if (!pokemon.getPalette().is("none")) {
                    paletteLogName = I18n.func_135052_a((String)("pixelmon.palette." + pokemon.getPalette().getName()), (Object[])new Object[0]);
                }
                ScreenHelper.drawScaledCenteredSplitString(matrix, paletteLogName, xPos + 20.0f, (float)top.get() + height + 4.0f, -7845363, 8.0f, 45, false);
                if (++i % 3 != 0 && i != this.categories.get((Object)category).size()) continue;
                top.addAndGet(65);
            }
        }
    }

    public void processScroll() {
        int mustard = 6;
        if (this.waitingScroll != 0) {
            if (Math.abs(this.waitingScroll) >= mustard) {
                if (this.waitingScroll < 0) {
                    this.waitingScroll += mustard;
                    this.currentScroll -= mustard;
                } else {
                    this.waitingScroll -= mustard;
                    this.currentScroll += mustard;
                }
            } else if (this.waitingScroll < 0) {
                ++this.waitingScroll;
                --this.currentScroll;
            } else {
                --this.waitingScroll;
                ++this.currentScroll;
            }
        }
    }

    public boolean func_231043_a_(double p_231043_1_, double p_231043_3_, double i) {
        if (this.viewedForm == -1) {
            int speed = 20;
            if (i < 0.0) {
                this.waitingScroll += speed;
                if (this.currentScroll + this.waitingScroll > this.maxScroll - 240) {
                    this.waitingScroll = this.maxScroll - 240 - this.currentScroll;
                }
            } else if (i > 0.0) {
                this.waitingScroll -= speed;
                if (this.currentScroll + this.waitingScroll < 0) {
                    this.waitingScroll = -this.currentScroll;
                }
            }
        }
        return true;
    }

    protected void actionPerformed(Button button) {
        if (button instanceof IndexedButton) {
            PokemonSpecification form = (PokemonSpecification)this.buttons.inverse().get((Object)button);
            int category = this.categories.entries().stream().filter(e -> ((PokemonSpecification)e.getValue()).equals(form)).mapToInt(Map.Entry::getKey).findFirst().orElse(0);
            Minecraft.func_71410_x().func_147108_a((Screen)new FishingLogInformationScreen(this.species.getDex(), category, form, this.encountered));
        }
    }
}

