/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.blocks;

import com.pixelmonmod.pixelmon.blocks.GenericModelBlock;
import com.pixelmonmod.pixelmon.blocks.tileentity.PicketFenceNormalTileEntity;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class PicketFenceBlock
extends GenericModelBlock
implements IWaterLoggable {
    public static final BooleanProperty NORTH = BooleanProperty.func_177716_a((String)"north");
    public static final BooleanProperty EAST = BooleanProperty.func_177716_a((String)"east");
    public static final BooleanProperty SOUTH = BooleanProperty.func_177716_a((String)"south");
    public static final BooleanProperty WEST = BooleanProperty.func_177716_a((String)"west");
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    protected static final AxisAlignedBB[] BOUNDING_BOXES = new AxisAlignedBB[]{new AxisAlignedBB(0.375, 0.0, 0.375, 0.625, 1.0, 0.625), new AxisAlignedBB(0.375, 0.0, 0.375, 0.625, 1.0, 1.0), new AxisAlignedBB(0.0, 0.0, 0.375, 0.625, 1.0, 0.625), new AxisAlignedBB(0.0, 0.0, 0.375, 0.625, 1.0, 1.0), new AxisAlignedBB(0.375, 0.0, 0.0, 0.625, 1.0, 0.625), new AxisAlignedBB(0.375, 0.0, 0.0, 0.625, 1.0, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 0.625, 1.0, 0.625), new AxisAlignedBB(0.0, 0.0, 0.0, 0.625, 1.0, 1.0), new AxisAlignedBB(0.375, 0.0, 0.375, 1.0, 1.0, 0.625), new AxisAlignedBB(0.375, 0.0, 0.375, 1.0, 1.0, 1.0), new AxisAlignedBB(0.0, 0.0, 0.375, 1.0, 1.0, 0.625), new AxisAlignedBB(0.0, 0.0, 0.375, 1.0, 1.0, 1.0), new AxisAlignedBB(0.375, 0.0, 0.0, 1.0, 1.0, 0.625), new AxisAlignedBB(0.375, 0.0, 0.0, 1.0, 1.0, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 0.625), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0)};
    public static final AxisAlignedBB PILLAR_AABB = new AxisAlignedBB(0.375, 0.0, 0.375, 0.625, 1.5, 0.625);
    public static final AxisAlignedBB SOUTH_AABB = new AxisAlignedBB(0.375, 0.0, 0.625, 0.625, 1.5, 1.0);
    public static final AxisAlignedBB WEST_AABB = new AxisAlignedBB(0.0, 0.0, 0.375, 0.375, 1.5, 0.625);
    public static final AxisAlignedBB NORTH_AABB = new AxisAlignedBB(0.375, 0.0, 0.0, 0.625, 1.5, 0.375);
    public static final AxisAlignedBB EAST_AABB = new AxisAlignedBB(0.625, 0.0, 0.375, 1.0, 1.5, 0.625);
    protected final VoxelShape[] collisionShapeByIndex;
    private final Object2IntMap<BlockState> stateToIndex = new Object2IntOpenHashMap();

    public PicketFenceBlock() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151575_d).func_200943_b(1.0f).func_200947_a(SoundType.field_185848_a));
        this.collisionShapeByIndex = this.makeShapes(2.0f, 2.0f, 16.0f, 0.0f, 16.0f);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)EAST, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)SOUTH, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)WEST, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)NORTH, (Comparable)Boolean.valueOf(false)));
    }

    protected VoxelShape[] makeShapes(float p_196408_1_, float p_196408_2_, float p_196408_3_, float p_196408_4_, float p_196408_5_) {
        float f = 8.0f - p_196408_1_;
        float f1 = 8.0f + p_196408_1_;
        float f2 = 8.0f - p_196408_2_;
        float f3 = 8.0f + p_196408_2_;
        VoxelShape voxelshape = Block.func_208617_a((double)f, (double)0.0, (double)f, (double)f1, (double)p_196408_3_, (double)f1);
        VoxelShape voxelshape1 = Block.func_208617_a((double)f2, (double)p_196408_4_, (double)0.0, (double)f3, (double)p_196408_5_, (double)f3);
        VoxelShape voxelshape2 = Block.func_208617_a((double)f2, (double)p_196408_4_, (double)f2, (double)f3, (double)p_196408_5_, (double)16.0);
        VoxelShape voxelshape3 = Block.func_208617_a((double)0.0, (double)p_196408_4_, (double)f2, (double)f3, (double)p_196408_5_, (double)f3);
        VoxelShape voxelshape4 = Block.func_208617_a((double)f2, (double)p_196408_4_, (double)f2, (double)16.0, (double)p_196408_5_, (double)f3);
        VoxelShape voxelshape5 = VoxelShapes.func_197872_a((VoxelShape)voxelshape1, (VoxelShape)voxelshape4);
        VoxelShape voxelshape6 = VoxelShapes.func_197872_a((VoxelShape)voxelshape2, (VoxelShape)voxelshape3);
        VoxelShape[] avoxelshape = new VoxelShape[]{VoxelShapes.func_197880_a(), voxelshape2, voxelshape3, voxelshape6, voxelshape1, VoxelShapes.func_197872_a((VoxelShape)voxelshape2, (VoxelShape)voxelshape1), VoxelShapes.func_197872_a((VoxelShape)voxelshape3, (VoxelShape)voxelshape1), VoxelShapes.func_197872_a((VoxelShape)voxelshape6, (VoxelShape)voxelshape1), voxelshape4, VoxelShapes.func_197872_a((VoxelShape)voxelshape2, (VoxelShape)voxelshape4), VoxelShapes.func_197872_a((VoxelShape)voxelshape3, (VoxelShape)voxelshape4), VoxelShapes.func_197872_a((VoxelShape)voxelshape6, (VoxelShape)voxelshape4), voxelshape5, VoxelShapes.func_197872_a((VoxelShape)voxelshape2, (VoxelShape)voxelshape5), VoxelShapes.func_197872_a((VoxelShape)voxelshape3, (VoxelShape)voxelshape5), VoxelShapes.func_197872_a((VoxelShape)voxelshape6, (VoxelShape)voxelshape5)};
        for (int i = 0; i < 16; ++i) {
            avoxelshape[i] = VoxelShapes.func_197872_a((VoxelShape)voxelshape, (VoxelShape)avoxelshape[i]);
        }
        return avoxelshape;
    }

    private static int indexFor(Direction p_196407_0_) {
        return 1 << p_196407_0_.func_176736_b();
    }

    protected int getAABBIndex(BlockState p_196406_1_) {
        return this.stateToIndex.computeIntIfAbsent((Object)p_196406_1_, p_223007_0_ -> {
            int i = 0;
            if (((Boolean)p_223007_0_.func_177229_b((Property)NORTH)).booleanValue()) {
                i |= PicketFenceBlock.indexFor(Direction.NORTH);
            }
            if (((Boolean)p_223007_0_.func_177229_b((Property)EAST)).booleanValue()) {
                i |= PicketFenceBlock.indexFor(Direction.EAST);
            }
            if (((Boolean)p_223007_0_.func_177229_b((Property)SOUTH)).booleanValue()) {
                i |= PicketFenceBlock.indexFor(Direction.SOUTH);
            }
            if (((Boolean)p_223007_0_.func_177229_b((Property)WEST)).booleanValue()) {
                i |= PicketFenceBlock.indexFor(Direction.WEST);
            }
            return i;
        });
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{NORTH, EAST, SOUTH, WEST, WATERLOGGED});
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader p_220071_2_, BlockPos p_220071_3_, ISelectionContext p_220071_4_) {
        return VoxelShapes.func_197881_a((AxisAlignedBB)BOUNDING_BOXES[PicketFenceBlock.getBoundingBoxIdx(state)]);
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return VoxelShapes.func_197881_a((AxisAlignedBB)BOUNDING_BOXES[PicketFenceBlock.getBoundingBoxIdx(state)]);
    }

    private static int getBoundingBoxIdx(BlockState state) {
        int i = 0;
        if (((Boolean)state.func_177229_b((Property)NORTH)).booleanValue()) {
            i |= 1 << Direction.NORTH.func_176736_b();
        }
        if (((Boolean)state.func_177229_b((Property)EAST)).booleanValue()) {
            i |= 1 << Direction.EAST.func_176736_b();
        }
        if (((Boolean)state.func_177229_b((Property)SOUTH)).booleanValue()) {
            i |= 1 << Direction.SOUTH.func_176736_b();
        }
        if (((Boolean)state.func_177229_b((Property)WEST)).booleanValue()) {
            i |= 1 << Direction.WEST.func_176736_b();
        }
        return i;
    }

    public boolean canConnectTo(IBlockReader worldIn, BlockPos pos, Direction facing) {
        BlockState iblockstate = worldIn.func_180495_p(pos);
        VoxelShape blockfaceshape = iblockstate.func_215702_a(worldIn, pos, facing);
        Block block = iblockstate.func_177230_c();
        return !PicketFenceBlock.isExcepBlockForAttachWithPiston(block) && blockfaceshape == VoxelShapes.func_197868_b() || block instanceof PicketFenceBlock;
    }

    protected static boolean isExcepBlockForAttachWithPiston(Block p_194142_0_) {
        return Block.func_220073_a((Block)p_194142_0_) || p_194142_0_ == Blocks.field_180401_cv || p_194142_0_ == Blocks.field_150440_ba || p_194142_0_ == Blocks.field_150423_aK;
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        return worldIn.field_72995_K ? ActionResultType.SUCCESS : ActionResultType.FAIL;
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        World worldIn = context.func_195991_k();
        BlockPos pos = context.func_195995_a();
        FluidState fluidstate = context.func_195991_k().func_204610_c(context.func_195995_a());
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)super.func_196258_a(context).func_206870_a((Property)NORTH, (Comparable)Boolean.valueOf(this.canConnectTo((IBlockReader)worldIn, pos.func_177978_c(), Direction.SOUTH)))).func_206870_a((Property)EAST, (Comparable)Boolean.valueOf(this.canConnectTo((IBlockReader)worldIn, pos.func_177974_f(), Direction.WEST)))).func_206870_a((Property)SOUTH, (Comparable)Boolean.valueOf(this.canConnectTo((IBlockReader)worldIn, pos.func_177968_d(), Direction.NORTH)))).func_206870_a((Property)WEST, (Comparable)Boolean.valueOf(this.canConnectTo((IBlockReader)worldIn, pos.func_177976_e(), Direction.EAST)))).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.func_206886_c() == Fluids.field_204546_a));
    }

    public FluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((Property)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    public BlockState rotate(BlockState state, IWorld world, BlockPos pos, Rotation direction) {
        switch (direction) {
            case CLOCKWISE_180: {
                return (BlockState)((BlockState)((BlockState)((BlockState)state.func_206870_a((Property)NORTH, state.func_177229_b((Property)SOUTH))).func_206870_a((Property)EAST, state.func_177229_b((Property)WEST))).func_206870_a((Property)SOUTH, state.func_177229_b((Property)NORTH))).func_206870_a((Property)WEST, state.func_177229_b((Property)EAST));
            }
            case COUNTERCLOCKWISE_90: {
                return (BlockState)((BlockState)((BlockState)((BlockState)state.func_206870_a((Property)NORTH, state.func_177229_b((Property)EAST))).func_206870_a((Property)EAST, state.func_177229_b((Property)SOUTH))).func_206870_a((Property)SOUTH, state.func_177229_b((Property)WEST))).func_206870_a((Property)WEST, state.func_177229_b((Property)NORTH));
            }
            case CLOCKWISE_90: {
                return (BlockState)((BlockState)((BlockState)((BlockState)state.func_206870_a((Property)NORTH, state.func_177229_b((Property)WEST))).func_206870_a((Property)EAST, state.func_177229_b((Property)NORTH))).func_206870_a((Property)SOUTH, state.func_177229_b((Property)EAST))).func_206870_a((Property)WEST, state.func_177229_b((Property)SOUTH));
            }
        }
        return state;
    }

    public BlockState func_185471_a(BlockState state, Mirror mirrorIn) {
        switch (mirrorIn) {
            case LEFT_RIGHT: {
                return (BlockState)((BlockState)state.func_206870_a((Property)NORTH, state.func_177229_b((Property)SOUTH))).func_206870_a((Property)SOUTH, state.func_177229_b((Property)NORTH));
            }
            case FRONT_BACK: {
                return (BlockState)((BlockState)state.func_206870_a((Property)EAST, state.func_177229_b((Property)WEST))).func_206870_a((Property)WEST, state.func_177229_b((Property)EAST));
            }
        }
        return state;
    }

    @Override
    public TileEntity func_196283_a_(IBlockReader worldIn) {
        return new PicketFenceNormalTileEntity();
    }
}

