/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.status;

import com.pixelmonmod.pixelmon.api.battles.AttackCategory;
import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.Element;
import com.pixelmonmod.pixelmon.api.pokemon.ability.AbstractAbility;
import com.pixelmonmod.pixelmon.api.pokemon.ability.abilities.Mimicry;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.attacks.EffectBase;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.status.Burn;
import com.pixelmonmod.pixelmon.battles.status.Freeze;
import com.pixelmonmod.pixelmon.battles.status.Paralysis;
import com.pixelmonmod.pixelmon.battles.status.Poison;
import com.pixelmonmod.pixelmon.battles.status.Sleep;
import com.pixelmonmod.pixelmon.battles.status.StatusBase;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import com.pixelmonmod.pixelmon.battles.status.Terrain;
import com.pixelmonmod.pixelmon.battles.status.Yawn;
import com.pixelmonmod.pixelmon.enums.heldItems.EnumHeldItems;
import java.util.List;
import javax.annotation.Nonnull;

public class MistyTerrain
extends Terrain {
    public MistyTerrain(boolean extended) {
        super(StatusType.MistyTerrain, "pixelmon.status.mistyterrain", "pixelmon.status.mistyterrainend", extended);
    }

    public MistyTerrain(int turnsToGo) {
        super(StatusType.MistyTerrain, turnsToGo, "pixelmon.status.mistyterrain", "pixelmon.status.mistyterrainend");
    }

    @Override
    public Terrain getNewInstance() {
        return new MistyTerrain(false);
    }

    @Override
    @Nonnull
    public com.pixelmonmod.pixelmon.api.battles.Terrain getTerrainType() {
        return com.pixelmonmod.pixelmon.api.battles.Terrain.MISTY;
    }

    @Override
    public Element getTypingForTerrain() {
        return Element.FAIRY;
    }

    @Override
    public int[] modifyPowerAndAccuracyTarget(int power, int accuracy, PixelmonWrapper user, PixelmonWrapper target, Attack a) {
        if (this.affectsPokemon(user) && a.getType() == Element.DRAGON) {
            power = (int)((double)power * 0.5);
        }
        if (a.isAttack(AttackRegistry.MISTY_EXPLOSION)) {
            power = (int)((double)power * 1.5);
        }
        return new int[]{power, accuracy};
    }

    @Override
    public boolean stopsStatusChange(StatusType t, PixelmonWrapper target, PixelmonWrapper user) {
        if (this.affectsPokemon(target) && (t == StatusType.Sleep || t == StatusType.Yawn || t == StatusType.Confusion || t == StatusType.Poison || t == StatusType.PoisonBadly || t == StatusType.Burn || t == StatusType.Freeze || t == StatusType.Paralysis)) {
            if (user != target && user.attack != null && user.attack.getAttackCategory() == AttackCategory.STATUS) {
                target.bc.sendToAll("pixelmon.effect.effectfailed", new Object[0]);
            }
            return true;
        }
        return false;
    }

    @Override
    protected int countBenefits(PixelmonWrapper user, PixelmonWrapper target) {
        int benefits = 0;
        if (this.affectsPokemon(target)) {
            List<Attack> moveset = user.getBattleAI().getMoveset(target);
            if (Attack.hasOffensiveAttackType(moveset, Element.DRAGON)) {
                --benefits;
            }
            if (target.hasStatus(StatusType.Yawn)) {
                ++benefits;
            }
            if (Attack.hasAttack(moveset, AttackRegistry.REST)) {
                --benefits;
            }
            for (Attack move : moveset) {
                for (EffectBase e : move.getMove().effects) {
                    if (!(e instanceof Sleep) && !(e instanceof Yawn) && !(e instanceof Burn) && !(e instanceof Poison) && !(e instanceof Freeze) && !(e instanceof Paralysis)) continue;
                    --benefits;
                    break;
                }
                if (!move.isAttack(AttackRegistry.NATURE_POWER) && !move.isAttack(AttackRegistry.SECRET_POWER) && !move.isAttack(AttackRegistry.CAMOUFLAGE) && !move.isAttack(AttackRegistry.MISTY_EXPLOSION) && !move.isAttack(AttackRegistry.TERRAIN_PULSE)) continue;
                ++benefits;
            }
            if (target.getBattleAbility().isAbility((Class<? extends AbstractAbility>)Mimicry.class)) {
                ++benefits;
            }
            if (target.hasHeldItem() && target.getHeldItem().getHeldItemType() == EnumHeldItems.terrainExtender || target.getHeldItem().getHeldItemType() == EnumHeldItems.terrainSeed) {
                ++benefits;
            }
        }
        return benefits;
    }

    @Override
    public StatusBase copy() {
        return new MistyTerrain(this.turnsToGo);
    }
}

