/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.status;

import com.pixelmonmod.pixelmon.battles.controller.ai.MoveChoice;
import com.pixelmonmod.pixelmon.battles.controller.log.AttackResult;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.status.StatusBase;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import com.pixelmonmod.pixelmon.items.HeldItem;
import java.util.List;

public class Embargo
extends StatusBase {
    transient int turnsRemaining = 5;

    public Embargo() {
        super(StatusType.Embargo);
    }

    @Override
    public void applyEffect(PixelmonWrapper user, PixelmonWrapper target) {
        if (target.addStatus(new Embargo(), target)) {
            user.bc.sendToAll("pixelmon.status.embargo", target.getNickname());
        } else {
            user.bc.sendToAll("pixelmon.effect.effectfailed", new Object[0]);
            user.attack.moveResult.result = AttackResult.failed;
        }
    }

    @Override
    public void applyRepeatedEffect(PixelmonWrapper pw) {
        if (--this.turnsRemaining <= 0) {
            pw.bc.sendToAll("pixelmon.status.embargoend", pw.getNickname());
            pw.removeStatus(this);
        }
    }

    @Override
    public void weightEffect(PixelmonWrapper pw, MoveChoice userChoice, List<MoveChoice> userChoices, List<MoveChoice> bestUserChoices, List<MoveChoice> opponentChoices, List<MoveChoice> bestOpponentChoices) {
        for (PixelmonWrapper target : userChoice.targets) {
            HeldItem heldItem = target.getUsableHeldItem();
            if (heldItem == null || heldItem.hasNegativeEffect()) continue;
            userChoice.raiseWeight(15.0f);
        }
    }
}

