/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.controller;

import com.pixelmonmod.pixelmon.battles.controller.BattleController;
import com.pixelmonmod.pixelmon.battles.controller.log.action.type.GlobalStatusAddAction;
import com.pixelmonmod.pixelmon.battles.controller.log.action.type.GlobalStatusRemoveAction;
import com.pixelmonmod.pixelmon.battles.controller.log.action.type.TerrainChangeAction;
import com.pixelmonmod.pixelmon.battles.controller.log.action.type.WeatherChangeAction;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.status.GlobalStatusBase;
import com.pixelmonmod.pixelmon.battles.status.NoTerrain;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import com.pixelmonmod.pixelmon.battles.status.Terrain;
import com.pixelmonmod.pixelmon.battles.status.Weather;
import com.pixelmonmod.pixelmon.comm.packetHandlers.battles.UpdateTerrainPacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.battles.UpdateWeatherPacket;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class GlobalStatusController {
    public BattleController bc;
    private List<GlobalStatusBase> globalStatuses = new ArrayList<GlobalStatusBase>();

    public GlobalStatusController(BattleController bc) {
        this.bc = bc;
    }

    public List<GlobalStatusBase> getGlobalStatuses() {
        ArrayList<GlobalStatusBase> effectiveStatuses = new ArrayList<GlobalStatusBase>(this.globalStatuses.size());
        effectiveStatuses.addAll(this.globalStatuses.stream().filter(status -> !status.isWeather() || !GlobalStatusBase.ignoreWeather(this.bc)).collect(Collectors.toList()));
        return effectiveStatuses;
    }

    public Weather getWeather() {
        if (this.getWeatherIgnoreAbility() == null || GlobalStatusBase.ignoreWeather(this.bc) && !this.getWeatherIgnoreAbility().extreme) {
            return null;
        }
        for (GlobalStatusBase g : this.globalStatuses) {
            if (!g.isWeather()) continue;
            return (Weather)g;
        }
        return null;
    }

    public Weather getWeatherIgnoreAbility() {
        for (GlobalStatusBase g : this.globalStatuses) {
            if (!g.isWeather()) continue;
            return (Weather)g;
        }
        return null;
    }

    public Terrain getTerrain() {
        for (GlobalStatusBase g : this.globalStatuses) {
            if (!g.isTerrain()) continue;
            return (Terrain)g;
        }
        return new NoTerrain();
    }

    public boolean removeGlobalStatus(StatusType status) {
        return this.globalStatuses.removeIf(g -> {
            if (g.type == status && !this.bc.simulateMode) {
                this.onRemoveStatus((GlobalStatusBase)g);
                return true;
            }
            return false;
        });
    }

    public boolean removeGlobalStatuses(StatusType ... statuses) {
        boolean hadStatus = false;
        for (StatusType status : statuses) {
            hadStatus = this.removeGlobalStatus(status) || hadStatus;
        }
        return hadStatus;
    }

    public void removeGlobalStatus(GlobalStatusBase g) {
        if (!this.bc.simulateMode) {
            this.onRemoveStatus(g);
            this.globalStatuses.remove(g);
        }
    }

    private void onRemoveStatus(GlobalStatusBase g) {
        this.bc.battleLog.logEvent(new GlobalStatusRemoveAction(this.bc.battleTurn, g));
        if (g.isWeather()) {
            this.triggerWeatherChange(null);
            this.bc.battleLog.logEvent(new WeatherChangeAction(this.bc.battleTurn, null, null, g));
        }
        if (g.isTerrain()) {
            if (!(g instanceof NoTerrain)) {
                this.triggerTerrainChange(null);
            }
            this.bc.battleLog.logEvent(new TerrainChangeAction(this.bc.battleTurn, null, null, (Terrain)g));
        }
    }

    public void addGlobalStatus(PixelmonWrapper cause, GlobalStatusBase g) {
        if (!this.bc.simulateMode) {
            if (g.isWeather()) {
                Weather oldWeather = this.getWeatherIgnoreAbility();
                this.globalStatuses.removeIf(GlobalStatusBase::isWeather);
                if (!GlobalStatusBase.ignoreWeather(this.bc) && this.bc.globalStatusController.canWeatherChange((Weather)g)) {
                    this.triggerWeatherChange((Weather)g);
                    this.bc.battleLog.logEvent(new WeatherChangeAction(this.bc.battleTurn, cause, g, oldWeather));
                }
            }
            if (g.isTerrain()) {
                Terrain oldTerrain = this.getTerrain();
                this.globalStatuses.removeIf(GlobalStatusBase::isTerrain);
                this.triggerTerrainChange((Terrain)g);
                this.bc.battleLog.logEvent(new TerrainChangeAction(this.bc.battleTurn, cause, (Terrain)g, oldTerrain));
            }
            this.bc.battleLog.logEvent(new GlobalStatusAddAction(this.bc.battleTurn, cause, g));
            this.globalStatuses.add(g);
        }
    }

    public GlobalStatusBase getGlobalStatus(int index) {
        return this.globalStatuses.get(index);
    }

    public GlobalStatusBase getGlobalStatus(StatusType type) {
        for (GlobalStatusBase g : this.globalStatuses) {
            if (g.type != type) continue;
            return g;
        }
        return null;
    }

    public int getGlobalStatusSize() {
        return this.globalStatuses.size();
    }

    public boolean hasStatus(StatusType type) {
        return this.getGlobalStatus(type) != null;
    }

    public void endBattle() {
        this.globalStatuses.clear();
    }

    public void triggerWeatherChange(Weather weather) {
        for (PixelmonWrapper pw : this.bc.getActiveUnfaintedPokemon()) {
            pw.getBattleAbility().onWeatherChange(pw, weather);
        }
        this.bc.sendToPlayers(new UpdateWeatherPacket(weather == null ? null : weather.type));
    }

    public void triggerTerrainChange(Terrain terrain) {
        for (PixelmonWrapper pw : this.bc.getActiveUnfaintedPokemon()) {
            pw.getUsableHeldItem().onTerrainSwitch(this.bc, pw, terrain);
            pw.getBattleAbility().onTerrainSwitch(this.bc, pw, terrain);
        }
        this.bc.sendToPlayers(new UpdateTerrainPacket(terrain == null ? null : terrain.type));
    }

    public boolean canWeatherChange(Weather newWeather) {
        Weather weather = this.getWeather();
        if (weather == null) {
            return true;
        }
        return !weather.extreme || newWeather != null && newWeather.extreme;
    }
}

