/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.controller;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.enums.ExperienceGainType;
import com.pixelmonmod.pixelmon.api.events.battles.CatchComboEvent;
import com.pixelmonmod.pixelmon.api.pokemon.species.evs.EVYields;
import com.pixelmonmod.pixelmon.api.pokemon.stats.BattleStatsType;
import com.pixelmonmod.pixelmon.api.pokemon.stats.PermanentStats;
import com.pixelmonmod.pixelmon.api.pokemon.stats.PokemonLevel;
import com.pixelmonmod.pixelmon.api.pokemon.stats.evolution.Evolution;
import com.pixelmonmod.pixelmon.api.pokemon.stats.evolution.types.LevelingEvolution;
import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.battles.api.rules.BattleRuleRegistry;
import com.pixelmonmod.pixelmon.battles.controller.participants.BattleParticipant;
import com.pixelmonmod.pixelmon.battles.controller.participants.ParticipantType;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.controller.participants.PlayerParticipant;
import com.pixelmonmod.pixelmon.battles.controller.participants.Spectator;
import com.pixelmonmod.pixelmon.client.gui.battles.PixelmonClientData;
import com.pixelmonmod.pixelmon.comm.EnumUpdateType;
import com.pixelmonmod.pixelmon.comm.packetHandlers.battles.SetPokemonBattleDataPacket;
import com.pixelmonmod.pixelmon.enums.heldItems.EnumHeldItems;
import com.pixelmonmod.pixelmon.items.ExpAllItem;
import com.pixelmonmod.pixelmon.items.HeldItem;
import com.pixelmonmod.pixelmon.items.heldItems.EVAdjusting;
import com.pixelmonmod.pixelmon.storage.playerData.CaptureCombo;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.minecraft.item.ItemStack;
import net.minecraftforge.eventbus.api.Event;

public final class Experience {
    public static void awardExp(List<BattleParticipant> participants, BattleParticipant losingTeamOwner, PixelmonWrapper faintedPokemon) {
        if (faintedPokemon == null || faintedPokemon.bc.isRaid() || faintedPokemon.bc.isLevelingDisabled()) {
            return;
        }
        for (BattleParticipant teamOwner : participants) {
            if (teamOwner.team == losingTeamOwner.team || !(teamOwner instanceof PlayerParticipant)) continue;
            PlayerParticipant player = (PlayerParticipant)teamOwner;
            Set<PixelmonWrapper> attackers = faintedPokemon.getAttackers();
            for (PixelmonWrapper pw : attackers) {
                if (pw.getParticipant() != teamOwner) continue;
                Experience.calcExp(faintedPokemon, pw, 1.0);
            }
            boolean hasExpAll = false;
            ArrayList items = new ArrayList();
            items.addAll(player.player.field_71071_by.field_70462_a);
            items.addAll(player.player.field_71071_by.field_184439_c);
            for (ItemStack item : items) {
                if (item == null || !(item.func_77973_b() instanceof ExpAllItem) || !item.func_77942_o() || !ExpAllItem.isActivated(item)) continue;
                hasExpAll = true;
                break;
            }
            for (PixelmonWrapper pw : teamOwner.allPokemon) {
                if (attackers.contains(pw)) continue;
                boolean getsExp = false;
                if (hasExpAll || pw.getHeldItem().getHeldItemType() == EnumHeldItems.expShare) {
                    getsExp = true;
                }
                if (!getsExp) continue;
                Experience.calcExp(faintedPokemon, pw, 0.5);
            }
            player.givePlayerExp(faintedPokemon);
        }
    }

    private static void calcExp(PixelmonWrapper faintedPokemon, PixelmonWrapper expReceiver, double scaleFactor) {
        float captureCombo;
        if (expReceiver.isFainted()) {
            return;
        }
        if (faintedPokemon != null && faintedPokemon.bc.isRaid()) {
            return;
        }
        HeldItem heldItem = expReceiver.initialCopyOfPokemon.getHeldItemAsItemHeld();
        EnumHeldItems heldItemType = heldItem.getHeldItemType();
        PokemonLevel pokemonLevel = expReceiver.getPokemonLevel();
        EVYields evYields = faintedPokemon.getForm().getEVYields();
        if (heldItemType == EnumHeldItems.evAdjusting) {
            EVAdjusting item = (EVAdjusting)heldItem;
            if (item.type == BattleStatsType.NONE) {
                evYields.doubleYields();
            } else {
                evYields.addToYield(item.type, 8);
            }
        }
        if (PixelmonConfigProxy.getGeneral().getPokerus().isEnabled() && expReceiver.getPokerus().isPresent()) {
            evYields.doubleYields();
        }
        PermanentStats permanentStats = expReceiver.getStats();
        permanentStats.getEVs().gainEV(evYields);
        int beforeHP = permanentStats.getHP();
        permanentStats.setLevelStats(expReceiver.getNature(), expReceiver.getForm(), pokemonLevel.getPokemonLevel());
        if (permanentStats.getHP() > beforeHP) {
            expReceiver.setHealth((int)Math.ceil((double)expReceiver.getHealth() / (double)beforeHP * (double)permanentStats.getHP()));
            expReceiver.updateHPIncrease();
        }
        expReceiver.update(EnumUpdateType.HP, EnumUpdateType.Stats);
        if (expReceiver.getPokemonLevelNum() >= expReceiver.bc.rules.getOrDefault(BattleRuleRegistry.LEVEL_CAP)) {
            return;
        }
        double a = 1.0;
        if (faintedPokemon.getParticipant().getType() != ParticipantType.WildPokemon) {
            a = 1.5;
        }
        double t = expReceiver.getOriginalTrainer().equals(expReceiver.getParticipant().getDisplayName()) ? 1.0 : 1.5;
        double baseExp = faintedPokemon.getForm().getSpawn().getBaseExp();
        double eggMultiplier = heldItemType == EnumHeldItems.luckyEgg ? 1.5 : 1.0;
        double faintedLevel = faintedPokemon.getPokemonLevelNum();
        PlayerParticipant participant = (PlayerParticipant)expReceiver.getParticipant();
        CaptureCombo combo = participant.getStorage().transientData.captureCombo;
        boolean getsCombo = combo.getCurrentSpecies() != null && combo.getCurrentSpecies().is(faintedPokemon.getSpecies());
        float f = captureCombo = getsCombo ? combo.getExpBouns() : combo.getBaseExpBonus();
        if (captureCombo != 1.0f) {
            CatchComboEvent.ComboExperienceBonus event = new CatchComboEvent.ComboExperienceBonus(participant.player, captureCombo);
            Pixelmon.EVENT_BUS.post((Event)event);
            captureCombo = event.getExperienceModifier();
        }
        double exp = a * t * baseExp * eggMultiplier * (double)captureCombo * faintedLevel * (scaleFactor *= (double)PixelmonConfigProxy.getBattle().getExpModifier()) / 7.0;
        for (Evolution e : expReceiver.getForm().getEvolutions()) {
            if (!(e instanceof LevelingEvolution) || pokemonLevel.getPokemonLevel() < ((LevelingEvolution)e).getPokemonLevel()) continue;
            exp *= 1.2;
            break;
        }
        pokemonLevel.awardEXP(expReceiver.bc, (int)exp, ExperienceGainType.BATTLE);
        if (!expReceiver.bc.battleEnded) {
            expReceiver.updateHPIncrease();
        }
        if (!expReceiver.bc.battleEnded && expReceiver.getParticipant() instanceof PlayerParticipant) {
            ArrayList<PixelmonWrapper> teamPokemon = participant.getTeamPokemonList();
            NetworkHelper.sendPacket(new SetPokemonBattleDataPacket(PixelmonClientData.convertToGUI(teamPokemon), false), participant.player);
            ArrayList<Spectator> playerSpectators = expReceiver.bc.getPlayerSpectators(participant);
            playerSpectators.forEach(spectator -> spectator.sendMessage(new SetPokemonBattleDataPacket(PixelmonClientData.convertToGUI(teamPokemon), false)));
        }
    }
}

