/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.basic;

import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.basic.PartingShot;
import com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.basic.SpecialAttackBase;
import com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.basic.SwitchOut;
import com.pixelmonmod.pixelmon.battles.controller.BattlePriorityHelper;
import com.pixelmonmod.pixelmon.battles.controller.ai.MoveChoice;
import com.pixelmonmod.pixelmon.battles.controller.log.AttackResult;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.tasks.EnforcedSwitchTask;
import java.util.List;

public class Pursuit
extends SpecialAttackBase {
    @Override
    public AttackResult applyEffectStart(PixelmonWrapper user, PixelmonWrapper target) {
        if (target.isSwitching || target.nextSwitchIsMove) {
            user.attack.setOverridePower(user.attack.getMove().getBasePower() * 2);
        }
        return AttackResult.proceed;
    }

    public void switchOutRetreatingTarget(PixelmonWrapper user, PixelmonWrapper target) {
        int userIndex;
        int targetIndex;
        if (target == null || target.attack == null || target.attack.getActualMove() == null) {
            return;
        }
        if ((target.attack.getActualMove().hasEffect(SwitchOut.class) || target.attack.getActualMove().hasEffect(PartingShot.class)) && (targetIndex = user.bc.turnList.indexOf(target)) < (userIndex = user.bc.turnList.indexOf(user))) {
            PixelmonWrapper nextAttacker = null;
            if (userIndex + 1 < user.bc.turnList.size()) {
                nextAttacker = user.bc.turnList.get(userIndex + 1);
            }
            if (!(nextAttacker != null && nextAttacker.attack.isAttack(AttackRegistry.PURSUIT) && nextAttacker.targets.contains(target) || !target.isAlive())) {
                target.wait = true;
                NetworkHelper.sendPacket(new EnforcedSwitchTask(target.bc.getPositionOfPokemon(target, target.getParticipant()), true), target.getPlayerOwner());
            }
        }
    }

    @Override
    public void applyEffect(PixelmonWrapper user, PixelmonWrapper target) {
        if (target.isSwitching && target.isFainted()) {
            for (int i = user.bc.turn + 1; i < user.bc.turnList.size(); ++i) {
                PixelmonWrapper pw = user.bc.turnList.get(i);
                if (pw.attack == null || !pw.attack.isAttack(AttackRegistry.PURSUIT)) continue;
                BattlePriorityHelper.recalculateMoveSpeed(user.bc, user.bc.turn + 1);
                break;
            }
        }
        if (target.isSwitching || target.nextSwitchIsMove) {
            this.switchOutRetreatingTarget(user, target);
        }
    }

    @Override
    public void weightEffect(PixelmonWrapper pw, MoveChoice userChoice, List<MoveChoice> userChoices, List<MoveChoice> bestUserChoices, List<MoveChoice> opponentChoices, List<MoveChoice> bestOpponentChoices) {
        if (!userChoice.hitsAlly()) {
            if (userChoice.tier >= 3) {
                userChoice.raiseWeight(1.0f);
            } else {
                for (PixelmonWrapper target : userChoice.targets) {
                    if (!(target.getHealthPercent(userChoice.weight) >= 50.0f)) continue;
                    userChoice.raiseWeight(userChoice.weight);
                }
            }
        }
    }
}

