/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.attacks;

import com.pixelmonmod.pixelmon.api.pokemon.Element;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.attacks.DamageTypeEnum;
import com.pixelmonmod.pixelmon.battles.attacks.ImmutableAttack;
import com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.modifiers.ModifierBase;
import com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.modifiers.ModifierType;
import com.pixelmonmod.pixelmon.battles.controller.BattleController;
import com.pixelmonmod.pixelmon.battles.controller.ai.MoveChoice;
import com.pixelmonmod.pixelmon.battles.controller.log.AttackResult;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import java.util.ArrayList;
import java.util.List;

public abstract class EffectBase {
    public ArrayList<ModifierBase> modifiers = new ArrayList();
    private boolean persists;

    public EffectBase() {
        this(false);
    }

    public EffectBase(boolean persists) {
        this.persists = persists;
    }

    public AttackResult applyEffectStart(PixelmonWrapper user, PixelmonWrapper target) {
        return AttackResult.proceed;
    }

    public abstract void applyEffect(PixelmonWrapper var1, PixelmonWrapper var2);

    public boolean checkChance() {
        for (ModifierBase m : this.modifiers) {
            if (m.type != ModifierType.Chance) continue;
            boolean b = (float)RandomHelper.rand.nextInt(100) < m.value * (m.multiplier == null ? 1.0f : m.multiplier.floatValue());
            m.multiplier = Float.valueOf(1.0f);
            return b;
        }
        return true;
    }

    public boolean isChance() {
        for (ModifierBase m : this.modifiers) {
            if (m.type != ModifierType.Chance) continue;
            return true;
        }
        return false;
    }

    public float getChance() {
        for (ModifierBase m : this.modifiers) {
            if (m.type != ModifierType.Chance) continue;
            return m.value;
        }
        return 100.0f;
    }

    public void changeChance(float multiplier) {
        for (ModifierBase m : this.modifiers) {
            if (m.type != ModifierType.Chance) continue;
            m.multiplier = Float.valueOf(multiplier);
        }
    }

    public abstract boolean cantMiss(PixelmonWrapper var1);

    public boolean doesPersist(PixelmonWrapper user) {
        return this.persists;
    }

    public void applyMissEffect(PixelmonWrapper user, PixelmonWrapper target) {
    }

    public void applyEarlyEffect(PixelmonWrapper user) {
    }

    public void applyEffectAfterAllTargets(PixelmonWrapper user) {
    }

    public void applyEffectHitOrMiss(PixelmonWrapper user, PixelmonWrapper target) {
    }

    public void applyEffectAfterStatus(PixelmonWrapper user) {
    }

    public void dealtDamage(PixelmonWrapper attacker, PixelmonWrapper defender, Attack attack, DamageTypeEnum damageType) {
    }

    public void weightEffect(PixelmonWrapper pw, MoveChoice userChoice, List<MoveChoice> userChoices, List<MoveChoice> bestUserChoices, List<MoveChoice> opponentChoices, List<MoveChoice> bestOpponentChoices) {
    }

    protected float getWeightWithChance(float weight) {
        float chance = this.getChance() / 100.0f;
        return chance >= 0.5f ? weight : chance;
    }

    public double modifyTypeEffectiveness(List<Element> effectiveTypes, Element moveType, double baseEffectiveness) {
        return baseEffectiveness;
    }

    public double modifyTypeEffectiveness(List<Element> effectiveTypes, Element moveType, double baseEffectiveness, BattleController bc) {
        return this.modifyTypeEffectiveness(effectiveTypes, moveType, baseEffectiveness);
    }

    public int modifyPriority(int priority, ImmutableAttack attack, PixelmonWrapper pw) {
        return priority;
    }

    public int modifyDamage(int damage, PixelmonWrapper user, PixelmonWrapper target, Attack a) {
        return damage;
    }
}

