/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.util.helpers;

import com.google.common.collect.Lists;
import com.pixelmonmod.pixelmon.client.models.animations.EnumRotation;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;

public class EntityHelper {
    public static double getMotion(Entity entity, EnumRotation axis) {
        switch (axis) {
            case x: {
                return entity.func_213322_ci().field_72450_a;
            }
            case y: {
                return entity.func_213322_ci().field_72448_b;
            }
            case z: {
                return entity.func_213322_ci().field_72449_c;
            }
        }
        return Double.NaN;
    }

    public static void setMotion(Entity entity, EnumRotation axis, double motion) {
        switch (axis) {
            case x: {
                entity.func_213293_j(motion, entity.func_213322_ci().func_82617_b(), entity.func_213322_ci().func_82616_c());
                break;
            }
            case y: {
                entity.func_213293_j(entity.func_213322_ci().func_82615_a(), motion, entity.func_213322_ci().func_82616_c());
                break;
            }
            case z: {
                entity.func_213293_j(entity.func_213322_ci().func_82615_a(), entity.func_213322_ci().func_82617_b(), motion);
            }
        }
        entity.field_70133_I = true;
    }

    public static void setMotion(Entity entity, double x, double y, double z) {
        entity.func_213293_j(x, y, z);
        entity.field_70133_I = true;
    }

    public static void addMotion(Entity entity, EnumRotation axis, double motion) {
        EntityHelper.setMotion(entity, axis, EntityHelper.getMotion(entity, axis) + motion);
    }

    public static void setPosition(Entity entity, EnumRotation axis, double position) {
        switch (axis) {
            case x: {
                entity.func_70107_b(position, entity.func_226278_cu_(), entity.func_226281_cx_());
                break;
            }
            case y: {
                entity.func_70107_b(entity.func_226277_ct_(), position, entity.func_226281_cx_());
                break;
            }
            case z: {
                entity.func_70107_b(entity.func_226277_ct_(), entity.func_226278_cu_(), position);
            }
        }
    }

    public static <T extends Entity> List<T> getNearbyEntities(Class<T> entityType, World world, double x, double y, double z, float radius) {
        ArrayList found = Lists.newArrayList();
        for (int cX = (int)x - (int)radius >> 4; cX < (int)x + (int)(radius + 1.0f) >> 4; ++cX) {
            for (int cY = (int)y - (int)radius >> 4; cY < (int)y + (int)(radius + 1.0f) >> 4; ++cY) {
                Chunk chunk = world.func_212866_a_(cX, cY);
                chunk.func_177430_a(entityType, new AxisAlignedBB(x - (double)radius, 0.0, z - (double)radius, x + (double)radius, 500.0, z + (double)radius), (List)found, e -> true);
            }
        }
        return found;
    }

    public static CompoundNBT getPersistentData(PlayerEntity player) {
        CompoundNBT data = player.getPersistentData();
        if (!data.func_74764_b("PlayerPersisted")) {
            data.func_218657_a("PlayerPersisted", (INBT)new CompoundNBT());
        }
        return data.func_74775_l("PlayerPersisted");
    }
}

