/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.util.helpers;

import com.google.common.collect.Maps;
import com.pixelmonmod.pixelmon.Pixelmon;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.block.BedBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BedPart;
import net.minecraft.tileentity.BedTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeMod;

public class BlockHelper {
    public static final VoxelShape EMPTY_SHAPE = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0);

    public static <T extends TileEntity> T findClosestTileEntity(Class<T> tileEntity, Entity entity, double range, Predicate<T> predicate) {
        Map<BlockPos, T> map = BlockHelper.findAllTileEntityWithinRange(tileEntity, entity.field_70170_p, entity.func_213303_ch(), range, predicate);
        if (map.size() == 0) {
            return null;
        }
        Map.Entry<BlockPos, T> closest = null;
        double distance = range + 0.1;
        for (Map.Entry<BlockPos, T> entry : map.entrySet()) {
            double dis = BlockHelper.getDistance(entity, entry.getKey());
            if (!(dis < distance)) continue;
            closest = entry;
            distance = dis;
        }
        return (T)(closest == null ? null : (TileEntity)closest.getValue());
    }

    public static <T extends TileEntity> Map<BlockPos, T> findAllTileEntityWithinRange(Class<T> tileEntity, Entity entity, double range, Predicate<T> predicate) {
        return BlockHelper.findAllTileEntityWithinRange(tileEntity, entity.field_70170_p, entity.func_213303_ch(), range, predicate);
    }

    public static <T extends TileEntity> Map<BlockPos, T> findAllTileEntityWithinRange(Class<T> tileEntity, World world, Vector3d pos, double range, Predicate<T> predicate) {
        int chunkXPos = MathHelper.func_76128_c((double)pos.func_82615_a()) >> 4;
        int chunkZPos = MathHelper.func_76128_c((double)pos.func_82616_c()) >> 4;
        int chunkRange = Math.max((int)(range / 16.0), 1) + 1;
        HashMap map = Maps.newHashMap();
        for (int x = chunkXPos - chunkRange + 1; x < chunkXPos + chunkRange; ++x) {
            for (int z = chunkZPos - chunkRange + 1; z < chunkZPos + chunkRange; ++z) {
                if (!world.func_72863_F().func_73149_a(x, z)) continue;
                Chunk chunk = world.func_212866_a_(x, z);
                for (Map.Entry entry : chunk.func_177434_r().entrySet()) {
                    if (!tileEntity.isAssignableFrom(((TileEntity)entry.getValue()).getClass()) || !(Math.sqrt(((BlockPos)entry.getKey()).func_218140_a(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, true)) <= range) || predicate != null && !predicate.test((TileEntity)entry.getValue())) continue;
                    map.put(entry.getKey(), (TileEntity)entry.getValue());
                }
            }
        }
        return map;
    }

    public static int countTileEntitiesOfType(World world, ChunkPos pos, Class<? extends TileEntity> clazz) {
        int count = 0;
        Chunk chunk = world.func_212866_a_(pos.field_77276_a, pos.field_77275_b);
        for (TileEntity te : chunk.func_177434_r().values()) {
            if (!clazz.isInstance(te)) continue;
            ++count;
        }
        return count;
    }

    public static <T extends TileEntity> T getTileEntity(Class<T> clazz, IBlockReader world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (te != null && !clazz.isInstance(te)) {
            te.func_222814_r();
            te = world.func_175625_s(pos);
            if (te != null && !clazz.isInstance(te)) {
                te.func_222814_r();
                Pixelmon.LOGGER.info("Bad TileEntity " + pos + " expected " + clazz.getSimpleName() + " got " + te.getClass().getSimpleName());
                return null;
            }
            if (te != null && world instanceof ServerWorld) {
                te.func_70296_d();
                ((ServerWorld)world).func_72863_F().func_217217_a(pos);
            }
        }
        try {
            return (T)te;
        }
        catch (Exception e) {
            te.func_222814_r();
            return null;
        }
    }

    public static boolean validateReach(ServerPlayerEntity player, BlockPos pos) {
        ServerWorld world = player.func_71121_q();
        double dist = player.func_110148_a((Attribute)ForgeMod.REACH_DISTANCE.get()).func_111126_e() + 3.0;
        dist *= dist;
        return world.func_175667_e(pos) && player.func_70092_e((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5) < dist;
    }

    private static double getDistance(Entity entity, BlockPos pos) {
        return Math.sqrt(entity.func_70092_e((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5));
    }

    public static void placeBed(World world, BlockPos pos1, Direction facing, DyeColor color) {
        TileEntity tileentity1;
        BlockPos pos2 = pos1.func_177972_a(facing);
        BlockState iblockstate2 = (BlockState)((BlockState)((BlockState)Blocks.field_196550_aA.func_176223_P().func_206870_a((Property)BedBlock.field_176471_b, (Comparable)Boolean.FALSE)).func_206870_a((Property)BedBlock.field_185512_D, (Comparable)facing)).func_206870_a((Property)BedBlock.field_176472_a, (Comparable)BedPart.FOOT);
        world.func_180501_a(pos1, iblockstate2, 10);
        world.func_180501_a(pos2, (BlockState)iblockstate2.func_206870_a((Property)BedBlock.field_176472_a, (Comparable)BedPart.HEAD), 10);
        TileEntity tileentity = world.func_175625_s(pos2);
        if (tileentity instanceof BedTileEntity) {
            ((BedTileEntity)tileentity).func_193052_a(color);
        }
        if ((tileentity1 = world.func_175625_s(pos1)) instanceof BedTileEntity) {
            ((BedTileEntity)tileentity1).func_193052_a(color);
        }
        world.func_195593_d(pos1, iblockstate2.func_177230_c());
        world.func_195593_d(pos2, iblockstate2.func_177230_c());
    }

    public static <T extends Comparable<T>> Optional<T> getPropertyValue(BlockState state, Property<T> property) {
        if (!state.func_235901_b_(property)) {
            return Optional.empty();
        }
        return Optional.of(state.func_177229_b(property));
    }
}

