/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.test;

import com.google.common.collect.Lists;
import com.pixelmonmod.pixelmon.api.test.TestResult;
import com.pixelmonmod.pixelmon.api.test.UnitTest;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class UnitTestRegistry {
    private static final List<TestData> REGISTERED_TESTS = Lists.newCopyOnWriteArrayList();

    public static void register(Class<?> testClass) {
        for (Method declaredMethod : testClass.getDeclaredMethods()) {
            UnitTest testData;
            if (!UnitTestRegistry.isValidTestMethod(declaredMethod) || (testData = declaredMethod.getAnnotation(UnitTest.class)) == null) continue;
            declaredMethod.setAccessible(true);
            REGISTERED_TESTS.add(new TestData(testData.value(), () -> {
                try {
                    return (CompletableFuture)declaredMethod.invoke(null, new Object[0]);
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
            }));
        }
    }

    public static CompletableFuture<Boolean> runTests(Loggable loggable) {
        ArrayList results = Lists.newArrayList();
        ArrayList testResults = Lists.newArrayList();
        for (TestData registeredTest : REGISTERED_TESTS) {
            loggable.log("Starting test: " + registeredTest.getId());
            results.add(((CompletableFuture)((CompletableFuture)registeredTest.testLogic.get()).thenApply(testResult -> {
                loggable.log("Completed test " + registeredTest.getId() + " " + (testResult.isSuccess() ? "successfully" : "but it failed. " + testResult.getReason()));
                testResults.add(testResult);
                return testResult;
            })).exceptionally(throwable -> {
                TestResult error = TestResult.error(throwable);
                loggable.log("Completed test " + registeredTest.getId() + " but it failed. " + throwable.getMessage());
                loggable.log(Arrays.stream(throwable.getStackTrace()).map(StackTraceElement::toString).collect(Collectors.joining(System.lineSeparator())));
                testResults.add(TestResult.error(throwable));
                return error;
            }));
        }
        return CompletableFuture.allOf(results.toArray(new CompletableFuture[0])).thenApply(unused -> {
            for (TestResult testResult : testResults) {
                if (testResult.isSuccess()) continue;
                return false;
            }
            return true;
        });
    }

    private static boolean isValidTestMethod(Method method) {
        if (!Modifier.isStatic(method.getModifiers())) {
            return false;
        }
        if (method.getParameterCount() > 0) {
            return false;
        }
        return method.getReturnType() == CompletableFuture.class;
    }

    public static interface Loggable {
        public void log(String var1);
    }

    public static class TestData {
        private final String id;
        private final Supplier<CompletableFuture<TestResult>> testLogic;

        public TestData(String id, Supplier<CompletableFuture<TestResult>> testLogic) {
            this.id = id;
            this.testLogic = testLogic;
        }

        public String getId() {
            return this.id;
        }

        public Supplier<CompletableFuture<TestResult>> getTestLogic() {
            return this.testLogic;
        }
    }
}

