/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.pokemon.stats;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.events.pokemon.EVsGainedEvent;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.species.evs.EVYields;
import com.pixelmonmod.pixelmon.api.pokemon.stats.BattleStatsType;
import com.pixelmonmod.pixelmon.api.pokemon.stats.IStatStore;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.comm.EnumUpdateType;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.eventbus.api.Event;

public class EVStore
implements IStatStore {
    public static final int MAX_EVS = 252;
    public static final int MAX_TOTAL_EVS = 510;
    private Pokemon pokemon = null;
    private int hp = 0;
    private int attack = 0;
    private int defense = 0;
    private int specialAttack = 0;
    private int specialDefense = 0;
    private int speed = 0;

    public EVStore() {
    }

    public EVStore(int ... evs) {
        this.fillFromArray(evs);
    }

    public EVStore(HashMap<BattleStatsType, Integer> evGain) {
        int[] evs = new int[]{0, 0, 0, 0, 0, 0};
        BattleStatsType[] values = BattleStatsType.values();
        for (int i = 1; i < 7; ++i) {
            if (!evGain.containsKey(values[i])) continue;
            evs[i - 1] = evGain.get(values[i]);
        }
        this.fillFromArray(evs);
    }

    public EVStore withPokemon(Pokemon pokemon) {
        this.pokemon = pokemon;
        return this;
    }

    @Override
    public int getStat(BattleStatsType type) {
        switch (type) {
            case ATTACK: {
                return this.attack;
            }
            case DEFENSE: {
                return this.defense;
            }
            case HP: {
                return this.hp;
            }
            case SPECIAL_ATTACK: {
                return this.specialAttack;
            }
            case SPECIAL_DEFENSE: {
                return this.specialDefense;
            }
            case SPEED: {
                return this.speed;
            }
        }
        return -1;
    }

    @Override
    public void setStat(BattleStatsType type, int value) {
        value = MathHelper.func_76125_a((int)value, (int)0, (int)252);
        switch (type) {
            case ATTACK: {
                this.attack = value;
                break;
            }
            case DEFENSE: {
                this.defense = value;
                break;
            }
            case HP: {
                this.hp = value;
                break;
            }
            case SPECIAL_ATTACK: {
                this.specialAttack = value;
                break;
            }
            case SPECIAL_DEFENSE: {
                this.specialDefense = value;
                break;
            }
            case SPEED: {
                this.speed = value;
                break;
            }
        }
        if (this.pokemon != null) {
            this.pokemon.getStats().recalculateStats();
        }
        this.markDirty();
    }

    public void markDirty() {
        if (this.pokemon != null) {
            this.pokemon.markDirty(EnumUpdateType.EVs, EnumUpdateType.Stats);
        }
    }

    public void fillFromArray(int ... evs) {
        if (evs.length < 6) {
            return;
        }
        this.hp = evs[0];
        this.attack = evs[1];
        this.defense = evs[2];
        this.specialAttack = evs[3];
        this.specialDefense = evs[4];
        this.speed = evs[5];
        this.markDirty();
    }

    public void gainEV(EVYields evYields) {
        EVsGainedEvent event;
        int remainingEVs = this.getRemainingEVs();
        if (this.pokemon != null && Pixelmon.EVENT_BUS.post((Event)(event = new EVsGainedEvent(this.pokemon, this, evYields)))) {
            return;
        }
        this.hp = Math.min(252, this.hp + Math.min(remainingEVs, evYields.getYield(BattleStatsType.HP)));
        remainingEVs = this.getRemainingEVs();
        this.attack = Math.min(252, this.attack + Math.min(remainingEVs, evYields.getYield(BattleStatsType.ATTACK)));
        remainingEVs = this.getRemainingEVs();
        this.defense = Math.min(252, this.defense + Math.min(remainingEVs, evYields.getYield(BattleStatsType.DEFENSE)));
        remainingEVs = this.getRemainingEVs();
        this.specialAttack = Math.min(252, this.specialAttack + Math.min(remainingEVs, evYields.getYield(BattleStatsType.SPECIAL_ATTACK)));
        remainingEVs = this.getRemainingEVs();
        this.specialDefense = Math.min(252, this.specialDefense + Math.min(remainingEVs, evYields.getYield(BattleStatsType.SPECIAL_DEFENSE)));
        remainingEVs = this.getRemainingEVs();
        this.speed = Math.min(252, this.speed + Math.min(remainingEVs, evYields.getYield(BattleStatsType.SPEED)));
        this.markDirty();
    }

    private int getRemainingEVs() {
        return Math.max(0, 510 - this.hp - this.attack - this.defense - this.specialAttack - this.specialDefense - this.speed);
    }

    public void writeToNBT(CompoundNBT nbt) {
        nbt.func_74777_a("EVHP", (short)this.hp);
        nbt.func_74777_a("EVAttack", (short)this.attack);
        nbt.func_74777_a("EVDefense", (short)this.defense);
        nbt.func_74777_a("EVSpecialAttack", (short)this.specialAttack);
        nbt.func_74777_a("EVSpecialDefense", (short)this.specialDefense);
        nbt.func_74777_a("EVSpeed", (short)this.speed);
    }

    public void readFromNBT(CompoundNBT nbt) {
        this.hp = nbt.func_74765_d("EVHP");
        this.attack = nbt.func_74765_d("EVAttack");
        this.defense = nbt.func_74765_d("EVDefense");
        this.specialAttack = nbt.func_74765_d("EVSpecialAttack");
        this.specialDefense = nbt.func_74765_d("EVSpecialDefense");
        this.speed = nbt.func_74765_d("EVSpeed");
    }

    public void writeToByteBuffer(ByteBuf buf) {
        buf.writeByte(this.getStat(BattleStatsType.HP));
        buf.writeByte(this.getStat(BattleStatsType.ATTACK));
        buf.writeByte(this.getStat(BattleStatsType.DEFENSE));
        buf.writeByte(this.getStat(BattleStatsType.SPECIAL_ATTACK));
        buf.writeByte(this.getStat(BattleStatsType.SPECIAL_DEFENSE));
        buf.writeByte(this.getStat(BattleStatsType.SPEED));
    }

    public EVStore readFromByteBuffer(ByteBuf buf) {
        this.hp = buf.readUnsignedByte();
        this.attack = buf.readUnsignedByte();
        this.defense = buf.readUnsignedByte();
        this.specialAttack = buf.readUnsignedByte();
        this.specialDefense = buf.readUnsignedByte();
        this.speed = buf.readUnsignedByte();
        return this;
    }

    public int[] getArray() {
        return new int[]{this.hp, this.attack, this.defense, this.specialAttack, this.specialDefense, this.speed};
    }

    public EVStore cloneEVs() {
        EVStore s = new EVStore();
        s.hp = this.hp;
        s.attack = this.attack;
        s.defense = this.defense;
        s.specialAttack = this.specialAttack;
        s.specialDefense = this.specialDefense;
        s.speed = this.speed;
        return s;
    }

    public void doubleValues() {
        this.attack *= 2;
        this.defense *= 2;
        this.hp *= 2;
        this.specialAttack *= 2;
        this.specialDefense *= 2;
        this.speed *= 2;
        this.markDirty();
    }

    public boolean berryEVs(BattleStatsType stat) {
        if (stat == BattleStatsType.ATTACK) {
            if (this.attack > 0) {
                this.setStat(stat, Math.max(this.attack - 10, 0));
                return true;
            }
        } else if (stat == BattleStatsType.DEFENSE) {
            if (this.defense > 0) {
                this.defense = Math.max(this.defense - 10, 0);
                this.setStat(stat, this.defense);
                return true;
            }
        } else if (stat == BattleStatsType.HP) {
            if (this.hp > 0) {
                this.hp = Math.max(this.hp - 10, 0);
                this.setStat(stat, this.hp);
                return true;
            }
        } else if (stat == BattleStatsType.SPECIAL_ATTACK) {
            if (this.specialAttack > 0) {
                this.specialAttack = Math.max(this.specialAttack - 10, 0);
                this.setStat(stat, this.specialAttack);
                return true;
            }
        } else if (stat == BattleStatsType.SPECIAL_DEFENSE) {
            if (this.specialDefense > 0) {
                this.specialDefense = Math.max(this.specialDefense - 10, 0);
                this.setStat(stat, this.specialDefense);
                return true;
            }
        } else if (stat == BattleStatsType.SPEED && this.speed > 0) {
            this.speed = Math.max(this.speed - 10, 0);
            this.setStat(stat, this.speed);
            return true;
        }
        return false;
    }

    public boolean vitaminEVs(BattleStatsType stat) {
        return this.addEVsOfType(stat, 10, 252);
    }

    public boolean wingEVs(BattleStatsType stat) {
        return this.addEVsOfType(stat, 1, 252);
    }

    public boolean addEVsOfType(BattleStatsType stat, int evIncrease, int maxValue) {
        int remainingEVs = this.getRemainingEVs();
        evIncrease = Math.min(evIncrease, remainingEVs);
        if (remainingEVs > 0) {
            if (stat == BattleStatsType.ATTACK) {
                if (this.attack < maxValue) {
                    this.setStat(stat, Math.min(this.attack + evIncrease, maxValue));
                    return true;
                }
            } else if (stat == BattleStatsType.DEFENSE) {
                if (this.defense < maxValue) {
                    this.setStat(stat, Math.min(this.defense + evIncrease, maxValue));
                    return true;
                }
            } else if (stat == BattleStatsType.HP) {
                if (this.hp < maxValue) {
                    this.setStat(stat, Math.min(this.hp + evIncrease, maxValue));
                    return true;
                }
            } else if (stat == BattleStatsType.SPECIAL_ATTACK) {
                if (this.specialAttack < maxValue) {
                    this.setStat(stat, Math.min(this.specialAttack + evIncrease, maxValue));
                    return true;
                }
            } else if (stat == BattleStatsType.SPECIAL_DEFENSE) {
                if (this.specialDefense < maxValue) {
                    this.setStat(stat, Math.min(this.specialDefense + evIncrease, maxValue));
                    return true;
                }
            } else if (stat == BattleStatsType.SPEED && this.speed < maxValue) {
                this.setStat(stat, Math.min(this.speed + evIncrease, maxValue));
                return true;
            }
        }
        return false;
    }

    public void randomizeMaxEVs() {
        int remainingEVs = 510;
        int[] evs = new int[6];
        while (remainingEVs > 0) {
            int index = RandomHelper.getRandomNumberBetween(0, evs.length - 1);
            if (evs[index] >= 252) continue;
            int n = index;
            evs[n] = evs[n] + 1;
            --remainingEVs;
        }
        this.hp = evs[0];
        this.attack = evs[1];
        this.defense = evs[2];
        this.specialAttack = evs[3];
        this.specialDefense = evs[4];
        this.speed = evs[5];
        this.pokemon.getStats().recalculateStats();
        this.markDirty();
    }
}

