/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.pokemon.ability.abilities;

import com.pixelmonmod.pixelmon.api.pokemon.ability.AbstractAbility;
import com.pixelmonmod.pixelmon.api.pokemon.stats.BattleStatsType;
import com.pixelmonmod.pixelmon.api.pokemon.stats.Moveset;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;

public class GorillaTactics
extends AbstractAbility {
    @Override
    public void preProcessAttackUser(PixelmonWrapper pokemon, PixelmonWrapper target, Attack a) {
        if (!pokemon.bc.simulateMode && pokemon.isDynamax <= 0) {
            pokemon.choiceLocked = a;
        }
    }

    @Override
    public void applySwitchInEffect(PixelmonWrapper pw) {
        if (!pw.bc.simulateMode) {
            pw.choiceLocked = null;
        }
    }

    @Override
    public void applySwitchOutEffect(PixelmonWrapper pw) {
        if (!pw.bc.simulateMode) {
            pw.choiceLocked = null;
        }
    }

    @Override
    public int[] modifyStats(PixelmonWrapper user, int[] stats) {
        if (user.isDynamax <= 0) {
            int n = BattleStatsType.ATTACK.getStatIndex();
            stats[n] = (int)((double)stats[n] * 1.5);
        }
        return stats;
    }

    @Override
    public void applyRepeatedEffect(PixelmonWrapper pokemon) {
        Moveset moveset = pokemon.getMoveset();
        for (int i = 0; i < moveset.size(); ++i) {
            Attack currentMove = moveset.get(i);
            if (pokemon.choiceLocked == null || currentMove.equals(pokemon.choiceLocked)) continue;
            currentMove.setDisabled(true, pokemon);
        }
    }
}

