/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.api.requirement;

import com.google.common.collect.Sets;
import com.pixelmonmod.api.requirement.AbstractRequirement;
import com.pixelmonmod.api.requirement.Requirement;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Set;

public abstract class AbstractBooleanRequirement<A, B>
extends AbstractRequirement<A, B, Boolean> {
    private static final Set<String> FALSE_IDENTIFIERS = Sets.newHashSet((Object[])new String[]{"0", "false"});
    private static final Set<String> TRUE_IDENTIFIERS = Sets.newHashSet((Object[])new String[]{"1", "true"});
    protected boolean value;

    public AbstractBooleanRequirement(Set<String> keys) {
        super(keys);
    }

    public AbstractBooleanRequirement(Set<String> keys, boolean value) {
        super(keys);
        this.value = value;
    }

    @Override
    public List<Requirement<A, B, ?>> createSimple(String key, String spec) {
        if (spec.equalsIgnoreCase(key)) {
            return Collections.singletonList(this.createInstance(true));
        }
        if (spec.startsWith(key + ":")) {
            String[] args = spec.split(key + ":");
            boolean invert = args.length > 0 && args[0].startsWith("!") || spec.startsWith("!");
            boolean value = args.length > 0 && this.parseBoolean(args[1]);
            return Collections.singletonList(this.createInstance(invert != value));
        }
        return Collections.emptyList();
    }

    protected boolean parseBoolean(String s) {
        if (s == null || FALSE_IDENTIFIERS.contains(s.toLowerCase(Locale.ROOT))) {
            return false;
        }
        return TRUE_IDENTIFIERS.contains(s.toLowerCase(Locale.ROOT));
    }

    @Override
    public Boolean getValue() {
        return this.value;
    }
}

