/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.api.pokemon.requirement.impl;

import com.google.common.collect.Sets;
import com.pixelmonmod.api.pokemon.requirement.AbstractPokemonRequirement;
import com.pixelmonmod.api.requirement.Requirement;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.species.aggression.Aggression;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class AIRequirement
extends AbstractPokemonRequirement<Aggression> {
    private static final Set<String> KEYS = Sets.newHashSet((Object[])new String[]{"ai", "artificialintelligence", "aggression", "agro"});
    private Aggression aggression;

    public AIRequirement() {
        super(KEYS);
    }

    public AIRequirement(Aggression aggression) {
        this();
        this.aggression = aggression;
    }

    @Override
    public List<Requirement<Pokemon, PixelmonEntity, ?>> createSimple(String key, String spec) {
        if (!spec.startsWith(key + ":")) {
            return Collections.emptyList();
        }
        String[] args = spec.split(key + ":");
        if (args.length == 0) {
            return Collections.singletonList(this.createInstance(Aggression.AGGRESSIVE));
        }
        return Collections.singletonList(this.createInstance(Aggression.valueOf(args[1].toUpperCase())));
    }

    @Override
    public Requirement<Pokemon, PixelmonEntity, Aggression> createInstance(Aggression value) {
        return new AIRequirement(value);
    }

    @Override
    public boolean isDataMatch(Pokemon pixelmon) {
        return false;
    }

    @Override
    public boolean isMinecraftMatch(PixelmonEntity entityPixelmon) {
        return Objects.equals(entityPixelmon.getAggression(), this.aggression);
    }

    @Override
    public void applyData(Pokemon pixelmon) {
    }

    @Override
    public void applyMinecraft(PixelmonEntity entityPixelmon) {
        entityPixelmon.setAggression(this.aggression);
    }

    @Override
    public Aggression getValue() {
        return this.aggression;
    }
}

