/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.api.pokemon.requirement;

import com.google.common.collect.Lists;
import com.pixelmonmod.api.SpecificationFactory;
import com.pixelmonmod.api.pokemon.PokemonSpecification;
import com.pixelmonmod.api.requirement.Requirement;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public abstract class AbstractRecursivePokemonRequirement
implements Requirement<Pokemon, PixelmonEntity, List<Requirement<Pokemon, PixelmonEntity, ?>>> {
    private final Set<String> keys;
    protected List<Requirement<Pokemon, PixelmonEntity, ?>> requirements;

    public AbstractRecursivePokemonRequirement(Set<String> keys) {
        this.keys = keys;
    }

    public AbstractRecursivePokemonRequirement(Set<String> keys, List<Requirement<Pokemon, PixelmonEntity, ?>> requirements) {
        this(keys);
        this.requirements = requirements;
    }

    @Override
    public List<String> getAliases() {
        return Lists.newArrayList(this.keys);
    }

    @Override
    public int getPriority() {
        return 10;
    }

    @Override
    public boolean shouldContinue() {
        return false;
    }

    @Override
    public boolean fits(String spec) {
        for (String key : this.keys) {
            if (!spec.contains(key)) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<Requirement<Pokemon, PixelmonEntity, ?>> create(String spec) {
        for (String key : this.keys) {
            if (!spec.contains(key)) continue;
            String[] args = spec.split(key);
            if (args.length == 0) {
                return Collections.emptyList();
            }
            ArrayList requirements = Lists.newArrayList();
            for (String arg : args) {
                this.requirements.addAll(SpecificationFactory.requirements(PokemonSpecification.class, arg));
            }
            return Collections.singletonList(this.createInstance(requirements));
        }
        return Collections.emptyList();
    }

    @Override
    public List<Requirement<Pokemon, PixelmonEntity, ?>> getValue() {
        return this.requirements;
    }
}

