/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.blaze3d.platform;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.Version;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWErrorCallback;
import org.lwjgl.glfw.GLFWErrorCallbackI;
import org.lwjgl.glfw.GLFWVidMode;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GLCapabilities;
import oshi.SystemInfo;
import oshi.hardware.Processor;

public class GLX {
    private static final Logger LOGGER = LogManager.getLogger();
    private static String capsString = "";
    private static String cpuInfo;
    private static final Map<Integer, String> LOOKUP_MAP;

    public static String getOpenGLVersionString() {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        if (GLFW.glfwGetCurrentContext() == 0L) {
            return "NO CONTEXT";
        }
        return dem.B(7937) + " GL version " + dem.B(7938) + ", " + dem.B(7936);
    }

    public static int _getRefreshRate(dez dez2) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        long l2 = GLFW.glfwGetWindowMonitor((long)dez2.i());
        if (l2 == 0L) {
            l2 = GLFW.glfwGetPrimaryMonitor();
        }
        GLFWVidMode \u26032 = l2 == 0L ? null : GLFW.glfwGetVideoMode((long)l2);
        return \u26032 == null ? 0 : \u26032.refreshRate();
    }

    public static String _getLWJGLVersion() {
        RenderSystem.assertThread(RenderSystem::isInInitPhase);
        return Version.getVersion();
    }

    public static LongSupplier _initGlfw() {
        LongSupplier longSupplier;
        RenderSystem.assertThread(RenderSystem::isInInitPhase);
        dez.a((n2, string) -> {
            throw new IllegalStateException(String.format("GLFW error before init: [0x%X]%s", n2, string));
        });
        ArrayList arrayList = Lists.newArrayList();
        GLFWErrorCallback \u26032 = GLFW.glfwSetErrorCallback((n2, l2) -> arrayList.add(String.format("GLFW error during init: [0x%X]%s", n2, l2)));
        if (GLFW.glfwInit()) {
            longSupplier = () -> (long)(GLFW.glfwGetTime() * 1.0E9);
            for (String string2 : arrayList) {
                LOGGER.error("GLFW error collected during initialization: {}", (Object)string2);
            }
        } else {
            throw new IllegalStateException("Failed to initialize GLFW, errors: " + Joiner.on((String)",").join((Iterable)arrayList));
        }
        RenderSystem.setErrorCallback((GLFWErrorCallbackI)\u26032);
        return longSupplier;
    }

    public static void _setGlfwErrorCallback(GLFWErrorCallbackI gLFWErrorCallbackI) {
        RenderSystem.assertThread(RenderSystem::isInInitPhase);
        GLFWErrorCallback gLFWErrorCallback = GLFW.glfwSetErrorCallback((GLFWErrorCallbackI)gLFWErrorCallbackI);
        if (gLFWErrorCallback != null) {
            gLFWErrorCallback.free();
        }
    }

    public static boolean _shouldClose(dez dez2) {
        return GLFW.glfwWindowShouldClose((long)dez2.i());
    }

    public static void _setupNvFogDistance() {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        if (GL.getCapabilities().GL_NV_fog_distance) {
            dem.l(34138, 34139);
        }
    }

    public static void _init(int n22, boolean bl2) {
        int n22;
        RenderSystem.assertThread(RenderSystem::isInInitPhase);
        GLCapabilities gLCapabilities = GL.getCapabilities();
        capsString = "Using framebuffer using " + dem.a(gLCapabilities);
        try {
            Processor[] processorArray = new SystemInfo().getHardware().getProcessors();
            cpuInfo = String.format("%dx %s", processorArray.length, processorArray[0]).replaceAll("\\s+", " ");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        del.a(n22, bl2);
    }

    public static String _getCapsString() {
        return capsString;
    }

    public static String _getCpuInfo() {
        return cpuInfo == null ? "<unknown>" : cpuInfo;
    }

    public static void _renderCrosshair(int n2, boolean bl2, boolean bl3, boolean bl4) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        dem.L();
        dem.a(false);
        dfo dfo2 = RenderSystem.renderThreadTesselator();
        dfh \u26032 = dfo2.c();
        GL11.glLineWidth((float)4.0f);
        \u26032.a(1, dfk.l);
        if (bl2) {
            \u26032.a(0.0, 0.0, 0.0).a(0, 0, 0, 255).d();
            \u26032.a((double)n2, 0.0, 0.0).a(0, 0, 0, 255).d();
        }
        if (bl3) {
            \u26032.a(0.0, 0.0, 0.0).a(0, 0, 0, 255).d();
            \u26032.a(0.0, (double)n2, 0.0).a(0, 0, 0, 255).d();
        }
        if (bl4) {
            \u26032.a(0.0, 0.0, 0.0).a(0, 0, 0, 255).d();
            \u26032.a(0.0, 0.0, (double)n2).a(0, 0, 0, 255).d();
        }
        dfo2.b();
        GL11.glLineWidth((float)2.0f);
        \u26032.a(1, dfk.l);
        if (bl2) {
            \u26032.a(0.0, 0.0, 0.0).a(255, 0, 0, 255).d();
            \u26032.a((double)n2, 0.0, 0.0).a(255, 0, 0, 255).d();
        }
        if (bl3) {
            \u26032.a(0.0, 0.0, 0.0).a(0, 255, 0, 255).d();
            \u26032.a(0.0, (double)n2, 0.0).a(0, 255, 0, 255).d();
        }
        if (bl4) {
            \u26032.a(0.0, 0.0, 0.0).a(127, 127, 255, 255).d();
            \u26032.a(0.0, 0.0, (double)n2).a(127, 127, 255, 255).d();
        }
        dfo2.b();
        GL11.glLineWidth((float)1.0f);
        dem.a(true);
        dem.K();
    }

    public static String getErrorString(int n2) {
        return LOOKUP_MAP.get(n2);
    }

    public static <T> T make(Supplier<T> supplier) {
        return supplier.get();
    }

    public static <T> T make(T t2, Consumer<T> consumer) {
        consumer.accept(t2);
        return t2;
    }

    static {
        LOOKUP_MAP = GLX.make(Maps.newHashMap(), hashMap -> {
            hashMap.put(0, "No error");
            hashMap.put(1280, "Enum parameter is invalid for this function");
            hashMap.put(1281, "Parameter is invalid for this function");
            hashMap.put(1282, "Current state is invalid for this function");
            hashMap.put(1283, "Stack overflow");
            hashMap.put(1284, "Stack underflow");
            hashMap.put(1285, "Out of memory");
            hashMap.put(1286, "Operation on incomplete framebuffer");
            hashMap.put(1286, "Operation on incomplete framebuffer");
        });
    }
}

