/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.tcg.duel.attack.effects;

import com.pixelmonmod.tcg.api.card.attack.CardAttack;
import com.pixelmonmod.tcg.api.util.helper.SelectorHelper;
import com.pixelmonmod.tcg.duel.attack.effects.BaseAttackEffect;
import com.pixelmonmod.tcg.duel.attack.effects.BaseAttackEffectWithOptionalFlip;
import com.pixelmonmod.tcg.duel.state.CardSelectorState;
import com.pixelmonmod.tcg.duel.state.GameServerState;
import com.pixelmonmod.tcg.duel.state.PlayerServerState;
import com.pixelmonmod.tcg.duel.state.PokemonAttackStatus;
import com.pixelmonmod.tcg.duel.state.PokemonCardState;
import java.util.List;

public class BenchDamageOppSelectEffect
extends BaseAttackEffectWithOptionalFlip {
    private static final String CODE = "BENCHDAMAGEOPPSELECT";
    private int count;
    private int amount;

    public BenchDamageOppSelectEffect() {
        super(CODE);
    }

    @Override
    public CardSelectorState getOpponentSelectorState(GameServerState server) {
        if (this.isCorrectCoinSide(server)) {
            PlayerServerState opp = server.getPlayer(server.getNextTurn());
            return SelectorHelper.generateSelectorForBench(opp, "attack.effect.catpunch.byopp");
        }
        return null;
    }

    @Override
    public boolean canApply(List<Object> parameters, CardAttack cardAttack, GameServerState server) {
        PokemonCardState[] benchCards;
        if (!this.isCorrectCoinSide(server)) {
            return true;
        }
        for (PokemonCardState card : benchCards = server.getPlayer(server.getNextTurn()).getBenchCards()) {
            if (card == null) continue;
            return parameters.size() == 1;
        }
        return true;
    }

    @Override
    public void applyOnCorrectCoinSideBeforeDamage(List<Object> parameters, PokemonAttackStatus attack, PokemonCardState card, GameServerState server) {
        if (!parameters.isEmpty()) {
            PokemonCardState bench = (PokemonCardState)parameters.get(0);
            bench.addDamage(card, this.amount, server);
        }
    }

    @Override
    public BaseAttackEffect parse(String ... args) {
        this.count = Integer.parseInt(args[1]);
        this.amount = Integer.parseInt(args[2]);
        return super.parse(args);
    }
}

