/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.world.listener;

import com.pixelmonmod.pixelmon.api.util.helpers.ResourceLocationHelper;
import com.pixelmonmod.pixelmon.client.gui.ScreenHelper;
import com.pixelmonmod.pixelmon.world.dimension.drowned.DrownedWorld;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.gui.ForgeIngameGui;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class DrownedWorldClientListener {
    private static final ResourceLocation EXCLAMATION = ResourceLocationHelper.of("pixelmon:textures/gui/exclamation.png");
    private int ticker = 0;

    @SubscribeEvent
    public void onRenderAirBar(RenderGameOverlayEvent.Pre event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (event.getType() == RenderGameOverlayEvent.ElementType.AIR) {
            event.getMatrixStack().func_227860_a_();
            if (mc.field_71441_e != null && DrownedWorld.WORLD == mc.field_71441_e.func_234923_W_() && mc.field_71439_g != null && mc.field_71439_g.func_204231_K() && !mc.field_71439_g.func_70648_aU()) {
                boolean drawHPWarning;
                ++this.ticker;
                double air = (double)mc.field_71439_g.func_70086_ai() / (double)mc.field_71439_g.func_205010_bg();
                double hp = mc.field_71439_g.func_110143_aJ() / mc.field_71439_g.func_110138_aP();
                boolean flicker = this.ticker % 100 > 50;
                boolean drawAirWarning = air > 0.5 || flicker;
                boolean bl = drawHPWarning = air <= 0.0 && (hp > 0.5 || flicker);
                if (drawAirWarning) {
                    ScreenHelper.drawImage(EXCLAMATION, event.getMatrixStack(), (float)event.getWindow().func_198107_o() / 2.0f + 91.0f, (float)(event.getWindow().func_198087_p() - ForgeIngameGui.right_height), 9.0f, 9.0f, 0.0f);
                }
                if (drawHPWarning) {
                    ScreenHelper.drawImage(EXCLAMATION, event.getMatrixStack(), (float)event.getWindow().func_198107_o() / 2.0f - 100.0f, (float)(event.getWindow().func_198087_p() - ForgeIngameGui.right_height + 10), 9.0f, 9.0f, 0.0f);
                }
                mc.func_110434_K().func_110577_a(AbstractGui.field_230665_h_);
            } else {
                this.ticker = 0;
            }
        }
    }

    @SubscribeEvent
    public void onRenderAirBarPost(RenderGameOverlayEvent.Post event) {
        if (event.getType() == RenderGameOverlayEvent.ElementType.AIR) {
            event.getMatrixStack().func_227865_b_();
        }
    }

    @SubscribeEvent
    public void onRenderFog(EntityViewRenderEvent.FogDensity event) {
        if (DrownedWorld.is(event.getInfo().func_216773_g().field_70170_p)) {
            event.setCanceled(true);
            event.getInfo().func_216773_g().field_70170_p.func_242406_i(event.getInfo().func_216773_g().func_233580_cy_()).ifPresent(biome -> {
                event.setCanceled(true);
                if (biome.func_240901_a_().toString().contains("drowned_crimson")) {
                    event.setDensity(0.07725f);
                } else if (biome.func_240901_a_().toString().contains("drowned_warm")) {
                    event.setDensity(0.057f);
                } else if (biome.func_240901_a_().toString().contains("drowned_dark")) {
                    event.setDensity(0.059f);
                } else {
                    event.setCanceled(false);
                }
            });
        }
    }
}

