/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities.pixelmon.interactions.formChanges;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.api.events.pokemon.ItemFormChangeEvent;
import com.pixelmonmod.pixelmon.api.pokemon.LearnMoveController;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.PokemonFactory;
import com.pixelmonmod.pixelmon.api.pokemon.species.Species;
import com.pixelmonmod.pixelmon.api.pokemon.species.Stats;
import com.pixelmonmod.pixelmon.api.registries.PixelmonForms;
import com.pixelmonmod.pixelmon.api.registries.PixelmonItems;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.attacks.ImmutableAttack;
import com.pixelmonmod.pixelmon.client.particle.ParticleSystems;
import com.pixelmonmod.pixelmon.comm.packetHandlers.PlayParticleSystemPacket;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import com.pixelmonmod.pixelmon.entities.pixelmon.interactions.formChanges.IFormChange;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraftforge.eventbus.api.Event;

public class NecrozmaFormChange
implements IFormChange {
    @Override
    public boolean isValidItem(ItemStack stack) {
        Item item = stack.func_77973_b();
        return item == PixelmonItems.n_lunarizer || item == PixelmonItems.n_solarizer;
    }

    @Override
    public boolean isValidPokemon(PixelmonEntity pixelmon) {
        return pixelmon.isPokemon(PixelmonSpecies.NECROZMA) && !pixelmon.isEvolving();
    }

    @Override
    public boolean execute(PixelmonEntity pixelmon, ItemStack stack, ServerPlayerEntity player) {
        Pokemon toFuse;
        Item item = stack.func_77973_b();
        Pokemon pokemon = pixelmon.getPokemon();
        Species partner = item == PixelmonItems.n_lunarizer ? PixelmonSpecies.LUNALA.getValueUnsafe() : PixelmonSpecies.SOLGALEO.getValueUnsafe();
        Stats toForm = partner.is(PixelmonSpecies.LUNALA) ? pokemon.getSpecies().getForm("dawn") : pokemon.getSpecies().getForm("dusk");
        PlayerPartyStorage storage = StorageProxy.getParty(player.func_110124_au());
        if (pokemon.getForm().is(toForm)) {
            ItemFormChangeEvent event;
            CompoundNBT fusedPokemonNBT = pokemon.getPersistentData().func_74775_l("FusedPokemon");
            Pokemon fused = null;
            if (!fusedPokemonNBT.isEmpty()) {
                try {
                    fused = PokemonFactory.create(fusedPokemonNBT);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (fused == null) {
                    Pixelmon.LOGGER.error("Couldn't get fused Pok\u00e9mon from NBT for player: " + player.func_200200_C_());
                }
            }
            if (Pixelmon.EVENT_BUS.post((Event)(event = new ItemFormChangeEvent(player, stack, pixelmon, fused)))) {
                return false;
            }
            pixelmon.func_130014_f_().func_184148_a(null, pixelmon.func_226277_ct_(), pixelmon.func_226278_cu_(), pixelmon.func_226281_cx_(), SoundEvents.field_187534_aX, SoundCategory.NEUTRAL, 1.0f, 0.1f);
            NetworkHelper.sendToDimension(new PlayParticleSystemPacket(ParticleSystems.DISCHARGE, pixelmon.func_226277_ct_(), pixelmon.func_226278_cu_(), pixelmon.func_226281_cx_(), pixelmon.field_70170_p, pixelmon.getPixelmonScale(), pixelmon.getPokemon().isShiny(), partner.is(PixelmonSpecies.SOLGALEO) ? 1.0 : 0.5, 0.5, partner != PixelmonSpecies.SOLGALEO.getValueUnsafe() ? 1.0 : 0.5, 0.0), player.field_70170_p);
            pokemon.setForm(PixelmonForms.NONE);
            if ((pokemon.getMoveset().removeAttack((ImmutableAttack)AttackRegistry.SUNSTEEL_STRIKE.orElse(null)) || pokemon.getMoveset().removeAttack((ImmutableAttack)AttackRegistry.MOONGEIST_BEAM.orElse(null))) && pokemon.getMoveset().size() == 0) {
                pokemon.getMoveset().add(new Attack(AttackRegistry.CONFUSION));
            }
            if (fused != null) {
                storage.add(event.fusion);
            }
            pixelmon.getPersistentData().func_82580_o("FusedPokemon");
        } else if (pokemon.getForm().isForm(PixelmonForms.NONE) && (toFuse = storage.findOne(pk -> pk.getSpecies().is(partner))) != null) {
            Attack specialMove;
            ItemFormChangeEvent event = new ItemFormChangeEvent(player, stack, pixelmon, toFuse);
            if (Pixelmon.EVENT_BUS.post((Event)event)) {
                return false;
            }
            toFuse.ifEntityExists(pixelmonEntity -> pixelmonEntity.retrieve("FormChange"));
            pixelmon.func_130014_f_().func_184148_a(null, pixelmon.func_226277_ct_(), pixelmon.func_226278_cu_(), pixelmon.func_226281_cx_(), SoundEvents.field_187853_gC, SoundCategory.NEUTRAL, 0.3f, 0.2f);
            NetworkHelper.sendToDimension(new PlayParticleSystemPacket(ParticleSystems.RADIALTHUNDER, pixelmon.func_226277_ct_(), pixelmon.func_226278_cu_(), pixelmon.func_226281_cx_(), pixelmon.field_70170_p, pixelmon.getPixelmonScale(), pixelmon.getPokemon().isShiny(), partner.is(PixelmonSpecies.SOLGALEO) ? 1.0 : 0.5, 0.5, partner != PixelmonSpecies.SOLGALEO.getValueUnsafe() ? 1.0 : 0.5), pixelmon.field_70170_p);
            storage.set(toFuse.getPosition(), null);
            pokemon.getPersistentData().func_218657_a("FusedPokemon", (INBT)toFuse.writeToNBT(new CompoundNBT()));
            pokemon.setForm(toForm);
            Attack attack = specialMove = partner.is(PixelmonSpecies.SOLGALEO) ? new Attack(AttackRegistry.SUNSTEEL_STRIKE) : new Attack(AttackRegistry.MOONGEIST_BEAM);
            if (!pokemon.getMoveset().add(specialMove)) {
                LearnMoveController.sendLearnMove(player, pokemon.getUUID(), specialMove.getActualMove());
            }
        }
        return true;
    }
}

