/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.command.impl.wiki;

import com.pixelmonmod.pixelmon.api.command.PixelmonCommandUtils;
import com.pixelmonmod.pixelmon.api.command.WikiCommandStrategy;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.util.ITranslatable;
import com.pixelmonmod.pixelmon.api.util.helpers.PokemonHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.TextHelper;
import com.pixelmonmod.pixelmon.battles.attacks.ImmutableAttack;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.command.CommandSource;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;

public class MovesStrategy
extends WikiCommandStrategy {
    public MovesStrategy() {
        super("moves");
    }

    @Override
    public int getPriority() {
        return 70;
    }

    @Override
    public void execute(CommandSource sender, Pokemon pokemon, String[] args) {
        Set<ImmutableAttack> tmMoves;
        Set<ImmutableAttack> eggMoves;
        IFormattableTextComponent text;
        sender.func_197030_a((ITextComponent)new StringTextComponent(""), false);
        sender.func_197030_a((ITextComponent)PixelmonCommandUtils.format("pixelmon.command.wiki.moves.header", PokemonHelper.getFullName(pokemon).func_240701_a_(new TextFormatting[]{TextFormatting.DARK_GREEN, TextFormatting.BOLD})), false);
        Map<Integer, Set<ImmutableAttack>> levelUpMoves = pokemon.getForm().getMoves().getPokemonLevelUpMoves();
        if (!levelUpMoves.isEmpty()) {
            sender.func_197030_a((ITextComponent)TextHelper.space(2).func_230529_a_((ITextComponent)PixelmonCommandUtils.format("pixelmon.command.wiki.moves.leveltm.header", new Object[0])), false);
            for (Map.Entry entry : levelUpMoves.entrySet().stream().sorted(Map.Entry.comparingByKey()).collect(Collectors.toList())) {
                text = TextHelper.space(4).func_230529_a_((ITextComponent)PixelmonCommandUtils.format("pixelmon.command.wiki.moves.leveltm.lvl", new Object[0])).func_230529_a_((ITextComponent)new StringTextComponent(" " + entry.getKey() + ": ")).func_240702_b_(((Set)entry.getValue()).stream().map(ITranslatable::getLocalizedName).collect(Collectors.joining(", "))).func_240699_a_(TextFormatting.GRAY);
                sender.func_197030_a((ITextComponent)text, false);
            }
        }
        if (!(eggMoves = pokemon.getForm().getMoves().getEggMoves()).isEmpty()) {
            sender.func_197030_a((ITextComponent)TextHelper.space(2).func_230529_a_((ITextComponent)PixelmonCommandUtils.format("pixelmon.command.wiki.moves.eggmoves.header", new Object[0])), false);
            IFormattableTextComponent text2 = TextHelper.space(4).func_240702_b_(eggMoves.stream().map(ITranslatable::getLocalizedName).collect(Collectors.joining(", "))).func_240699_a_(TextFormatting.GRAY);
            sender.func_197030_a((ITextComponent)text2, false);
        }
        if (!(tmMoves = pokemon.getForm().getMoves().getAllTMTRHMMoves()).isEmpty()) {
            sender.func_197030_a((ITextComponent)TextHelper.space(2).func_230529_a_((ITextComponent)PixelmonCommandUtils.format("pixelmon.command.wiki.moves.tmmoves.header", new Object[0])), false);
            text = TextHelper.space(4).func_240702_b_(tmMoves.stream().map(ITranslatable::getLocalizedName).collect(Collectors.joining(", "))).func_240699_a_(TextFormatting.GRAY);
            sender.func_197030_a((ITextComponent)text, false);
        }
    }
}

